/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.serialization.impl.vlt;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.api.RegexpPathMapping;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.Importer;
import org.apache.jackrabbit.vault.fs.io.ZipStreamArchive;
import org.apache.jackrabbit.vault.packaging.ExportOptions;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.serialization.DistributionContentSerializer;
import org.apache.sling.distribution.serialization.DistributionExportOptions;
import org.apache.sling.distribution.serialization.impl.vlt.VltUtils;
import org.apache.sling.distribution.util.DistributionJcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileVaultContentSerializer
implements DistributionContentSerializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String TYPE = "filevault";
    private static final String VERSION = "0.0.1";
    private static final String PACKAGE_GROUP = "sling/distribution";
    private static final String PATH_MAPPING_PROPERTY = "Path-Mapping";
    private static final String MAPPING_SEPARATOR = "=";
    private static final String MAPPING_DELIMITER = ";";
    private final Packaging packaging;
    private final ImportMode importMode;
    private final AccessControlHandling aclHandling;
    private final AccessControlHandling cugHandling;
    private final String[] packageRoots;
    private final int autosaveThreshold;
    private final TreeMap<String, List<String>> nodeFilters;
    private final TreeMap<String, List<String>> propertyFilters;
    private final boolean useBinaryReferences;
    private final String name;
    private final Map<String, String> exportPathMapping;
    private final boolean strict;

    public FileVaultContentSerializer(String name, Packaging packaging, ImportMode importMode, AccessControlHandling aclHandling, AccessControlHandling cugHandling, String[] packageRoots, String[] nodeFilters, String[] propertyFilters, boolean useBinaryReferences, int autosaveThreshold, Map<String, String> exportPathMapping, boolean strict) {
        this.name = name;
        this.packaging = packaging;
        this.importMode = importMode;
        this.aclHandling = aclHandling;
        this.cugHandling = cugHandling;
        this.packageRoots = packageRoots;
        this.autosaveThreshold = autosaveThreshold;
        this.nodeFilters = VltUtils.parseFilters(nodeFilters);
        this.propertyFilters = VltUtils.parseFilters(propertyFilters);
        this.useBinaryReferences = useBinaryReferences;
        this.exportPathMapping = exportPathMapping;
        this.strict = strict;
    }

    @Override
    public void exportToStream(ResourceResolver resourceResolver, DistributionExportOptions exportOptions, OutputStream outputStream) throws DistributionException {
        Session session = null;
        try {
            DistributionRequest request = VltUtils.sanitizeRequest(exportOptions.getRequest());
            session = this.getSession(resourceResolver);
            String packageGroup = PACKAGE_GROUP;
            String packageName = "filevault_" + System.currentTimeMillis() + "_" + UUID.randomUUID();
            WorkspaceFilter filter = VltUtils.createFilter(request, this.nodeFilters, this.propertyFilters);
            ExportOptions opts = VltUtils.getExportOptions(filter, this.packageRoots, packageGroup, packageName, VERSION, this.useBinaryReferences, this.exportPathMapping);
            this.log.debug("assembling package {} user {}", (Object)(packageGroup + '/' + packageName + "-" + VERSION), (Object)resourceResolver.getUserID());
            this.packaging.getPackageManager().assemble(session, opts, outputStream);
            this.ungetSession(session);
        }
        catch (Exception e) {
            try {
                throw new DistributionException(e);
            }
            catch (Throwable throwable) {
                this.ungetSession(session);
                throw throwable;
            }
        }
    }

    @Override
    public void importFromStream(ResourceResolver resourceResolver, InputStream inputStream) throws DistributionException {
        Session session = null;
        ZipStreamArchive archive = null;
        try {
            String pathsMappingProperty;
            Properties metaInfProperties;
            session = this.getSession(resourceResolver);
            ImportOptions importOptions = VltUtils.getImportOptions(this.aclHandling, this.cugHandling, this.importMode, this.autosaveThreshold, this.strict);
            Importer importer = new Importer(importOptions);
            archive = new ZipStreamArchive(inputStream);
            archive.open(false);
            MetaInf metaInf = archive.getMetaInf();
            if (metaInf != null && (metaInfProperties = metaInf.getProperties()) != null && (pathsMappingProperty = metaInfProperties.getProperty(PATH_MAPPING_PROPERTY)) != null && !pathsMappingProperty.isEmpty()) {
                RegexpPathMapping pathMapping = new RegexpPathMapping();
                StringTokenizer pathsMappingTokenizer = new StringTokenizer(pathsMappingProperty, MAPPING_DELIMITER);
                while (pathsMappingTokenizer.hasMoreTokens()) {
                    String[] pathMappingHeader = pathsMappingTokenizer.nextToken().split(MAPPING_SEPARATOR);
                    pathMapping.addMapping(pathMappingHeader[0], pathMappingHeader[1]);
                }
                importOptions.setPathMapping((PathMapping)pathMapping);
            }
            importer.run((Archive)archive, session, "/");
            if (importer.hasErrors() && importOptions.isStrict()) {
                throw new PackageException("Errors during import.");
            }
            if (session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (Exception e) {
            throw new DistributionException(e);
        }
        finally {
            this.ungetSession(session);
            if (archive != null) {
                archive.close();
            }
        }
    }

    private Session getSession(ResourceResolver resourceResolver) throws RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        if (session == null) {
            throw new RepositoryException("could not obtain a session from calling user " + resourceResolver.getUserID());
        }
        DistributionJcrUtils.setDoNotDistribute(session);
        return session;
    }

    private void ungetSession(Session session) {
        if (session != null) {
            try {
                if (session.hasPendingChanges()) {
                    session.save();
                }
            }
            catch (RepositoryException e) {
                this.log.error("Cannot save session", (Throwable)e);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRequestFiltering() {
        return true;
    }
}

