/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.InputStream;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.importer.RepositoryDistributionPackageImporter;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;

@Component(label="Apache Sling Distribution Importer - Repository Package Importer Factory", metatype=true, configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionPackageImporter.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Importer name: {name}"})
public class RepositoryDistributionPackageImporterFactory
implements DistributionPackageImporter {
    @Property
    private static final String NAME = "name";
    @Property(name="service.name")
    private static String SERVICE_NAME;
    @Property(name="path")
    private static String PATH;
    @Property(name="privilege.name")
    private static String PRIVILEGE_NAME;
    @Reference
    private SlingRepository repository;
    private RepositoryDistributionPackageImporter importer;

    @Activate
    protected void activate(Map<String, Object> config) {
        this.importer = new RepositoryDistributionPackageImporter(this.repository, PropertiesUtil.toString((Object)config.get(SERVICE_NAME), (String)"admin"), PropertiesUtil.toString((Object)config.get(PATH), (String)"/var/sling/distribution/import"), PropertiesUtil.toString((Object)config.get(PRIVILEGE_NAME), (String)"jcr:read"));
    }

    @Override
    public void importPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        this.importer.importPackage(resourceResolver, distributionPackage);
    }

    @Override
    @NotNull
    public DistributionPackageInfo importStream(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.importer.importStream(resourceResolver, stream);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

