/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.discovery.PropertyProvider;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;

@Component(immediate=true)
@Reference(referenceInterface=HttpService.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class StandardPropertyProvider {
    private static final String REG_PROPERTY_ENDPOINTS = "osgi.http.endpoint";
    private static final String REG_PROPERTY_ENDPOINTS_RFC = "osgi.http.service.endpoints";
    private volatile long changeCount;
    private ServiceRegistration propagationService;
    private final Map<Long, String[]> endpoints = new HashMap<Long, String[]>();
    private String endpointString;
    @Reference
    SlingSettingsService settings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dictionary<String, Object> getRegistrationProperties() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("org.apache.sling.instance.name");
        names.add("org.apache.sling.instance.description");
        names.add("org.apache.sling.instance.endpoints");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Map<Long, String[]> map = this.endpoints;
        synchronized (map) {
            for (String[] points : this.endpoints.values()) {
                for (String point : points) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(point);
                }
            }
        }
        this.endpointString = sb.toString();
        Hashtable<String, Object> serviceProps = new Hashtable<String, Object>();
        ((Dictionary)serviceProps).put("instance.properties", names.toArray(new String[names.size()]));
        StandardPropertyProvider standardPropertyProvider = this;
        synchronized (standardPropertyProvider) {
            ((Dictionary)serviceProps).put("changeCount", this.changeCount++);
        }
        return serviceProps;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.modified(cc);
    }

    @Modified
    protected void modified(ComponentContext cc) {
        this.propagationService = cc.getBundleContext().registerService(PropertyProvider.class.getName(), (Object)new PropertyProvider(){

            public String getProperty(String name) {
                if ("org.apache.sling.instance.description".equals(name)) {
                    return StandardPropertyProvider.this.settings.getSlingDescription();
                }
                if ("org.apache.sling.instance.name".equals(name)) {
                    return StandardPropertyProvider.this.settings.getSlingName();
                }
                if ("org.apache.sling.instance.endpoints".equals(name)) {
                    return StandardPropertyProvider.this.endpointString;
                }
                return null;
            }
        }, this.getRegistrationProperties());
    }

    @Deactivate
    protected void deactivate() {
        if (this.propagationService != null) {
            this.propagationService.unregister();
            this.propagationService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindHttpService(ServiceReference reference) {
        String[] endpointUrls = this.toStringArray(reference.getProperty(REG_PROPERTY_ENDPOINTS));
        if (endpointUrls == null) {
            endpointUrls = this.toStringArray(reference.getProperty(REG_PROPERTY_ENDPOINTS_RFC));
        }
        if (endpointUrls != null) {
            Map<Long, String[]> map = this.endpoints;
            synchronized (map) {
                this.endpoints.put((Long)reference.getProperty("service.id"), endpointUrls);
            }
            if (this.propagationService != null) {
                this.propagationService.setProperties(this.getRegistrationProperties());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindHttpService(ServiceReference reference) {
        boolean changed = false;
        Map<Long, String[]> map = this.endpoints;
        synchronized (map) {
            if (this.endpoints.remove(reference.getProperty("service.id")) != null) {
                changed = true;
            }
        }
        if (changed && this.propagationService != null) {
            this.propagationService.setProperties(this.getRegistrationProperties());
        }
    }

    private String[] toStringArray(Object propValue) {
        if (propValue == null) {
            return null;
        }
        if (propValue instanceof String) {
            return new String[]{(String)propValue};
        }
        if (propValue instanceof String[]) {
            return (String[])propValue;
        }
        if (propValue.getClass().isArray()) {
            Object[] valueArray = (Object[])propValue;
            ArrayList<String> values = new ArrayList<String>(valueArray.length);
            for (Object value : valueArray) {
                if (value == null) continue;
                values.add(value.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (propValue instanceof Collection) {
            Collection valueCollection = (Collection)propValue;
            ArrayList<String> valueList = new ArrayList<String>(valueCollection.size());
            for (Object value : valueCollection) {
                if (value == null) continue;
                valueList.add(value.toString());
            }
            return valueList.toArray(new String[valueList.size()]);
        }
        return null;
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }
}

