/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteConfig;
import org.apache.sling.discovery.oak.DiscoveryServiceCentralConfig;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Config.class, BaseConfig.class, DiscoveryLiteConfig.class})
@Designate(ocd=DiscoveryServiceCentralConfig.class)
public class Config
implements BaseConfig,
DiscoveryLiteConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CLUSTERINSTANCES_RESOURCE = "clusterInstances";
    private static final String SYNC_TOKEN_RESOURCE = "syncTokens";
    private static final String ID_MAP_RESOURCE = "idMap";
    private boolean autoStopLocalLoopEnabled;
    private boolean hmacEnabled;
    private String sharedKey;
    private long keyInterval;
    private boolean encryptionEnabled;
    private boolean gzipConnectorRequestsEnabled;
    private int backoffStandbyFactor = 5;
    private int backoffStableFactor = 5;
    private boolean syncTokenEnabled;
    private long joinerDelayOverwriteNextCheck;
    private boolean joinerDelayOverwrite;
    protected long connectorPingTimeout = 120L;
    protected long connectorPingInterval = 30L;
    protected long discoveryLiteCheckInterval = 2L;
    protected long clusterSyncServiceTimeout = 120L;
    protected long clusterSyncServiceInterval = 2L;
    protected int minEventDelay = 3;
    private int socketConnectTimeout = 10;
    private int soTimeout = 10;
    private URL[] topologyConnectorUrls = new URL[]{null};
    protected String[] topologyConnectorWhitelist = DiscoveryServiceCentralConfig.DEFAULT_TOPOLOGY_CONNECTOR_WHITELIST;
    protected String discoveryResourcePath = "/var/discovery/oak/";
    protected long leaderElectionPrefix = 1L;
    protected boolean invertLeaderElectionPrefixOrder = false;
    protected boolean suppressPartiallyStartedInstance = false;
    protected long suppressionTimeoutSeconds = -1L;
    protected long joinerDelaySeconds = 0L;

    @Activate
    protected void activate(BundleContext context, DiscoveryServiceCentralConfig config) {
        this.logger.debug("activate: config activated.");
        this.configure(config);
    }

    protected void configure(DiscoveryServiceCentralConfig config) {
        this.connectorPingTimeout = config.connectorPingTimeout();
        this.logger.debug("configure: connectorPingTimeout='{}'", (Object)this.connectorPingTimeout);
        this.connectorPingInterval = config.connectorPingInterval();
        this.logger.debug("configure: connectorPingInterval='{}'", (Object)this.connectorPingInterval);
        this.discoveryLiteCheckInterval = config.discoveryLiteCheckInterval();
        this.logger.debug("configure: discoveryLiteCheckInterval='{}'", (Object)this.discoveryLiteCheckInterval);
        this.clusterSyncServiceTimeout = config.clusterSyncServiceTimeout();
        this.logger.debug("configure: clusterSyncServiceTimeout='{}'", (Object)this.clusterSyncServiceTimeout);
        this.clusterSyncServiceInterval = config.clusterSyncServiceInterval();
        this.logger.debug("configure: clusterSyncServiceInterval='{}'", (Object)this.clusterSyncServiceInterval);
        this.minEventDelay = config.minEventDelay();
        this.logger.debug("configure: minEventDelay='{}'", (Object)this.minEventDelay);
        this.socketConnectTimeout = config.socketConnectTimeout();
        this.logger.debug("configure: socketConnectTimeout='{}'", (Object)this.socketConnectTimeout);
        this.soTimeout = config.soTimeout();
        this.logger.debug("configure: soTimeout='{}'", (Object)this.soTimeout);
        String[] topologyConnectorUrlsStr = config.topologyConnectorUrls();
        if (topologyConnectorUrlsStr != null && topologyConnectorUrlsStr.length > 0) {
            LinkedList<URL> urls = new LinkedList<URL>();
            for (int i = 0; i < topologyConnectorUrlsStr.length; ++i) {
                String anUrlStr = topologyConnectorUrlsStr[i];
                try {
                    if (anUrlStr == null || anUrlStr.length() <= 0) continue;
                    URL url = new URL(anUrlStr);
                    this.logger.debug("configure: a topologyConnectorbUrl='{}'", (Object)url);
                    urls.add(url);
                    continue;
                }
                catch (MalformedURLException e) {
                    this.logger.error("configure: could not set a topologyConnectorUrl: " + e, (Throwable)e);
                }
            }
            if (urls.size() > 0) {
                this.topologyConnectorUrls = urls.toArray(new URL[urls.size()]);
                this.logger.debug("configure: number of topologyConnectorUrls='{}''", (Object)urls.size());
            } else {
                this.topologyConnectorUrls = null;
                this.logger.debug("configure: no (valid) topologyConnectorUrls configured");
            }
        } else {
            this.topologyConnectorUrls = null;
            this.logger.debug("configure: no (valid) topologyConnectorUrls configured");
        }
        this.topologyConnectorWhitelist = config.topologyConnectorWhitelist();
        this.logger.debug("configure: topologyConnectorWhitelist='{}'", (Object[])this.topologyConnectorWhitelist);
        this.discoveryResourcePath = config.discoveryResourcePath();
        while (this.discoveryResourcePath.endsWith("/")) {
            this.discoveryResourcePath = this.discoveryResourcePath.substring(0, this.discoveryResourcePath.length() - 1);
        }
        this.discoveryResourcePath = this.discoveryResourcePath + "/";
        if (this.discoveryResourcePath == null || this.discoveryResourcePath.length() <= 1) {
            this.discoveryResourcePath = "/var/discovery/oak/";
        }
        this.logger.debug("configure: discoveryResourcePath='{}'", (Object)this.discoveryResourcePath);
        this.autoStopLocalLoopEnabled = config.autoStopLocalLoopEnabled();
        this.gzipConnectorRequestsEnabled = config.gzipConnectorRequestsEnabled();
        this.hmacEnabled = config.hmacEnabled();
        this.encryptionEnabled = config.enableEncryption();
        this.syncTokenEnabled = config.enableSyncToken();
        this.sharedKey = config.sharedKey();
        this.keyInterval = config.hmacSharedKeyTTL();
        this.backoffStandbyFactor = config.backoffStandbyFactor();
        this.backoffStableFactor = config.backoffStableFactor();
        this.invertLeaderElectionPrefixOrder = config.invertLeaderElectionPrefixOrder();
        this.logger.debug("configure: invertLeaderElectionPrefixOrder='{}'", (Object)this.invertLeaderElectionPrefixOrder);
        this.leaderElectionPrefix = config.leaderElectionPrefix();
        this.logger.debug("configure: leaderElectionPrefix='{}'", (Object)this.leaderElectionPrefix);
        this.suppressPartiallyStartedInstance = config.suppressPartiallyStartedInstance();
        this.logger.debug("configure: suppressPartiallyStartedInstance='{}'", (Object)this.suppressPartiallyStartedInstance);
        this.suppressionTimeoutSeconds = config.suppressionTimeoutSeconds();
        this.logger.debug("configure: suppressionTimeoutSeconds='{}'", (Object)this.suppressionTimeoutSeconds);
        this.joinerDelaySeconds = config.joinerDelaySeconds();
        this.logger.debug("configure: joinerDelaySeconds='{}'", (Object)this.joinerDelaySeconds);
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getMinEventDelay() {
        return this.minEventDelay;
    }

    public URL[] getTopologyConnectorURLs() {
        return this.topologyConnectorUrls;
    }

    public String[] getTopologyConnectorWhitelist() {
        return this.topologyConnectorWhitelist;
    }

    protected String getDiscoveryResourcePath() {
        return this.discoveryResourcePath;
    }

    public String getClusterInstancesPath() {
        return this.getDiscoveryResourcePath() + CLUSTERINSTANCES_RESOURCE;
    }

    public String getSyncTokenPath() {
        return this.getDiscoveryResourcePath() + SYNC_TOKEN_RESOURCE;
    }

    public String getIdMapPath() {
        return this.getDiscoveryResourcePath() + ID_MAP_RESOURCE;
    }

    public boolean isHmacEnabled() {
        return this.hmacEnabled;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public long getKeyInterval() {
        return this.keyInterval;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public boolean isGzipConnectorRequestsEnabled() {
        return this.gzipConnectorRequestsEnabled;
    }

    public boolean isAutoStopLocalLoopEnabled() {
        return this.autoStopLocalLoopEnabled;
    }

    public int getBackoffStandbyFactor() {
        return this.backoffStandbyFactor;
    }

    public int getBackoffStableFactor() {
        return this.backoffStableFactor;
    }

    public long getBackoffStandbyInterval() {
        int factor = this.getBackoffStandbyFactor();
        if (factor <= 1) {
            return -1L;
        }
        return (long)factor * this.getConnectorPingInterval();
    }

    public long getConnectorPingInterval() {
        return this.connectorPingInterval;
    }

    public long getConnectorPingTimeout() {
        return this.connectorPingTimeout;
    }

    public long getDiscoveryLiteCheckInterval() {
        return this.discoveryLiteCheckInterval;
    }

    public long getClusterSyncServiceTimeoutMillis() {
        return this.clusterSyncServiceTimeout * 1000L;
    }

    public long getClusterSyncServiceIntervalMillis() {
        return this.clusterSyncServiceInterval * 1000L;
    }

    public boolean getSyncTokenEnabled() {
        return this.syncTokenEnabled;
    }

    public boolean isInvertLeaderElectionPrefixOrder() {
        return this.invertLeaderElectionPrefixOrder;
    }

    public long getLeaderElectionPrefix() {
        return this.leaderElectionPrefix;
    }

    private boolean applyJoinerDelayOverwrite(boolean configValue) {
        long now = System.currentTimeMillis();
        if (this.joinerDelayOverwriteNextCheck != 0L && now < this.joinerDelayOverwriteNextCheck) {
            return this.joinerDelayOverwrite;
        }
        String systemPropertyValue = System.getProperty("org.apache.sling.discovery.oak.joinerdelay.enabled");
        boolean newJoinerDelayOverwrite = (Boolean)((Converting)Converters.standardConverter().convert((Object)systemPropertyValue).defaultValue((Object)configValue)).to(Boolean.class);
        if (this.joinerDelayOverwriteNextCheck == 0L) {
            this.logger.info("applyJoinerDelayOverwrite : initialization. system property 'org.apache.sling.discovery.oak.joinerdelay.enabled' = " + systemPropertyValue + ", config value = " + configValue + ", resulting value = " + newJoinerDelayOverwrite);
        } else if (newJoinerDelayOverwrite != this.joinerDelayOverwrite) {
            this.logger.info("applyJoinerDelayOverwrite : value change. system property 'org.apache.sling.discovery.oak.joinerdelay.enabled' = " + systemPropertyValue + ", config value = " + configValue + ", resulting value = " + newJoinerDelayOverwrite);
        }
        this.joinerDelayOverwrite = newJoinerDelayOverwrite;
        this.joinerDelayOverwriteNextCheck = now + 300000L;
        return this.joinerDelayOverwrite;
    }

    public boolean getSuppressPartiallyStartedInstances() {
        return this.applyJoinerDelayOverwrite(this.suppressPartiallyStartedInstance);
    }

    public long getSuppressionTimeoutSeconds() {
        return this.suppressionTimeoutSeconds;
    }

    public long getJoinerDelayMillis() {
        return Math.max(0L, this.joinerDelaySeconds * 1000L);
    }
}

