/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.testing.jcr.RepositoryProvider;
import org.apache.sling.commons.testing.jcr.RepositoryUtil;
import org.apache.sling.discovery.commons.providers.spi.base.MockedResource;
import org.apache.sling.jcr.api.SlingRepository;

public class MockedResourceResolver
implements ResourceResolver {
    private final SlingRepository repository;
    private Session session;
    private List<MockedResource> resources = new LinkedList<MockedResource>();

    public MockedResourceResolver() throws RepositoryException {
        this(null);
    }

    public MockedResourceResolver(SlingRepository repositoryOrNull) throws RepositoryException {
        if (repositoryOrNull == null) {
            this.repository = RepositoryProvider.instance().getRepository();
            Session adminSession = null;
            try {
                adminSession = this.repository.loginAdministrative(null);
                RepositoryUtil.registerSlingNodeTypes((Session)adminSession);
            }
            catch (IOException ioe) {
                throw new RepositoryException((Throwable)ioe);
            }
            finally {
                if (adminSession != null) {
                    adminSession.logout();
                }
            }
        } else {
            this.repository = repositoryOrNull;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() throws RepositoryException {
        MockedResourceResolver mockedResourceResolver = this;
        synchronized (mockedResourceResolver) {
            if (this.session != null) {
                return this.session;
            }
            this.session = this.createSession();
            return this.session;
        }
    }

    private Repository getRepository() {
        return this.repository;
    }

    private Session createSession() throws RepositoryException {
        SimpleCredentials credentials = new SimpleCredentials("admin", "admin".toCharArray());
        return this.repository.login((Credentials)credentials, "default");
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type.equals(Session.class)) {
            try {
                return (AdapterType)this.getSession();
            }
            catch (RepositoryException e) {
                throw new RuntimeException("RepositoryException: " + (Object)((Object)e), e);
            }
        }
        if (type.equals(Repository.class)) {
            return (AdapterType)this.getRepository();
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public Resource resolve(HttpServletRequest request, String absPath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Resource resolve(String absPath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    public Resource resolve(HttpServletRequest request) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String map(String resourcePath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String map(HttpServletRequest request, String resourcePath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Resource getResource(String path) {
        try {
            Session session = this.getSession();
            session.getNode(path);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("RepositoryException: " + (Object)((Object)e), e);
        }
        return new MockedResource(this, path, "nt:unstructured");
    }

    public Resource getResource(Resource base, String path) {
        if (base.getPath().equals("/")) {
            return this.getResource("/" + path);
        }
        return this.getResource(base.getPath() + "/" + path);
    }

    public String[] getSearchPath() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Iterator<Resource> listChildren(Resource parent) {
        try {
            Node node = (Node)parent.adaptTo(Node.class);
            final NodeIterator nodes = node.getNodes();
            return new Iterator<Resource>(){

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Resource next() {
                    Node next = nodes.nextNode();
                    try {
                        return new MockedResource(MockedResourceResolver.this, next.getPath(), "nt:unstructured");
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException("RepositoryException: " + (Object)((Object)e), e);
                    }
                }

                @Override
                public boolean hasNext() {
                    return nodes.hasNext();
                }
            };
        }
        catch (RepositoryException e) {
            throw new RuntimeException("RepositoryException: " + (Object)((Object)e), e);
        }
    }

    public Iterable<Resource> getChildren(Resource parent) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Iterator<Resource> findResources(String query, String language) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isLive() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        for (MockedResource r : this.resources) {
            r.close();
        }
        if (this.session != null) {
            if (this.session.isLive()) {
                this.session.logout();
            }
            this.session = null;
        }
    }

    public void register(MockedResource mockedResource) {
        this.resources.add(mockedResource);
    }

    public String getUserID() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Iterator<String> getAttributeNames() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Object getAttribute(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void delete(Resource resource) throws PersistenceException {
        if (this.resources.contains(resource)) {
            this.resources.remove(resource);
            Node node = (Node)resource.adaptTo(Node.class);
            try {
                node.remove();
            }
            catch (RepositoryException e) {
                throw new PersistenceException("RepositoryException: " + (Object)((Object)e), (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    public Resource create(Resource parent, String name, Map<String, Object> properties) throws PersistenceException {
        Node parentNode = (Node)parent.adaptTo(Node.class);
        try {
            Node child = properties != null && properties.containsKey("jcr:primaryType") ? parentNode.addNode(name, (String)properties.get("jcr:primaryType")) : parentNode.addNode(name);
            if (properties != null) {
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    if (entry.getKey().equals("jcr:primaryType")) continue;
                    if (entry.getValue() instanceof String) {
                        child.setProperty(entry.getKey(), (String)entry.getValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Boolean) {
                        child.setProperty(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Calendar) {
                        child.setProperty(entry.getKey(), (Calendar)entry.getValue());
                        continue;
                    }
                    throw new UnsupportedOperationException("Not implemented (entry.getValue(): " + entry.getValue() + ")");
                }
            }
            return this.getResource(parent, name);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void revert() {
        try {
            this.session.refresh(false);
        }
        catch (RepositoryException re) {
            throw new RuntimeException("Unable to commit changes.", re);
        }
    }

    public void commit() throws PersistenceException {
        try {
            this.session.save();
        }
        catch (RepositoryException re) {
            throw new PersistenceException("Unable to commit changes.", (Throwable)re);
        }
    }

    public boolean hasChanges() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getParentResourceType(Resource resource) {
        return null;
    }

    public String getParentResourceType(String resourceType) {
        return null;
    }

    public boolean isResourceType(Resource resource, String resourceType) {
        return false;
    }

    public void refresh() {
    }

    public boolean hasChildren(Resource arg0) {
        Iterable<Resource> iter = this.getChildren(arg0);
        return iter.iterator().hasNext();
    }

    public Resource getParent(Resource child) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Resource copy(String srcAbsPath, String destAbsPath) throws PersistenceException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Resource move(String srcAbsPath, String destAbsPath) throws PersistenceException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

