/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.sling.commons.testing.junit.categories.Slow;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DummyTopologyView;
import org.apache.sling.discovery.commons.providers.EventHelper;
import org.apache.sling.discovery.commons.providers.base.DummyListener;
import org.apache.sling.discovery.commons.providers.base.TestHelper;
import org.apache.sling.discovery.commons.providers.base.TestViewStateManager;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerImpl;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Slow.class})
public class TestSlowViewStateManager
extends TestViewStateManager {
    @Override
    protected void randomEventLoop(Random random, DummyListener ... listeners) throws InterruptedException {
        TestHelper.randomEventLoop(this.mgr, null, 100, -1, random, listeners);
    }

    @Category(value={Slow.class})
    @Test
    public void testClusterSyncService_withConcurrency() throws Exception {
        LogManager.getRootLogger();
        Logger commonsLogger = Logger.getLogger((String)"org.apache.sling.discovery.commons.providers");
        Level logLevel = commonsLogger.getLevel();
        commonsLogger.setLevel(Level.INFO);
        Semaphore serviceSemaphore = new Semaphore(0);
        final Semaphore testSemaphore = new Semaphore(0);
        ReentrantLock lock = new ReentrantLock();
        TestViewStateManager.ClusterSyncServiceWithSemaphore cs = new TestViewStateManager.ClusterSyncServiceWithSemaphore(this, lock, serviceSemaphore);
        this.mgr = new ViewStateManagerImpl((Lock)lock, (ClusterSyncService)cs);
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        String slingId1 = UUID.randomUUID().toString();
        String slingId2 = UUID.randomUUID().toString();
        String slingId3 = UUID.randomUUID().toString();
        String clusterId = UUID.randomUUID().toString();
        DefaultClusterView cluster = new DefaultClusterView(clusterId);
        final DummyTopologyView view1 = new DummyTopologyView().addInstance(slingId1, cluster, true, true).addInstance(slingId2, cluster, false, false).addInstance(slingId3, cluster, false, false);
        final DummyTopologyView view2 = DummyTopologyView.clone(view1).removeInstance(slingId2);
        final DummyTopologyView view3 = DummyTopologyView.clone(view1).removeInstance(slingId2).removeInstance(slingId3);
        this.async(new Runnable(){

            @Override
            public void run() {
                TestSlowViewStateManager.this.mgr.handleNewView((BaseTopologyView)view1);
            }
        });
        Thread.sleep(1000L);
        TestHelper.assertNoEvents(listener);
        Assert.assertEquals((String)"should have one thread now waiting", (long)1L, (long)serviceSemaphore.getQueueLength());
        serviceSemaphore.release(1);
        Thread.sleep(1000L);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view1));
        this.mgr.handleChanging();
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(500L));
        this.assertEvents(listener, EventHelper.newChangingEvent((BaseTopologyView)view1));
        this.async(new Runnable(){

            @Override
            public void run() {
                TestSlowViewStateManager.this.mgr.handleNewView((BaseTopologyView)view2);
            }
        });
        logger.debug("run: waiting 1sec");
        Thread.sleep(1000L);
        logger.debug("run: asserting no events");
        TestHelper.assertNoEvents(listener);
        Assert.assertEquals((String)"should have one thread now waiting", (long)1L, (long)serviceSemaphore.getQueueLength());
        Assert.assertFalse((String)"should not be locked", (boolean)lock.isLocked());
        logger.debug("run: issuing a second event");
        this.async(new Runnable(){

            @Override
            public void run() {
                TestViewStateManager.logger.debug("run2: calling handleChanging...");
                TestSlowViewStateManager.this.mgr.handleChanging();
                try {
                    TestViewStateManager.logger.debug("run2: done with handleChanging, acquiring testSemaphore...");
                    testSemaphore.acquire();
                    TestViewStateManager.logger.debug("run2: calling handleNewView...");
                    TestSlowViewStateManager.this.mgr.handleNewView((BaseTopologyView)view3);
                    TestViewStateManager.logger.debug("run2: done with handleNewView...");
                }
                catch (InterruptedException e) {
                    TestViewStateManager.logger.error("interrupted: " + e, (Throwable)e);
                }
            }
        });
        logger.debug("run: waiting 1sec");
        Thread.sleep(1000L);
        int remainingAsyncEvents = this.mgr.waitForAsyncEvents(2000L);
        logger.info("run: result of waitForAsyncEvent is: " + remainingAsyncEvents);
        Assert.assertEquals((String)"should have one thread now waiting", (long)1L, (long)serviceSemaphore.getQueueLength());
        Assert.assertEquals((String)"should be acquiring (by thread2)", (long)1L, (long)testSemaphore.getQueueLength());
        testSemaphore.release();
        logger.debug("run: waiting 1sec");
        Thread.sleep(1000L);
        Assert.assertEquals((String)"should have two async events now in the queue or being sent", (long)2L, (long)this.mgr.waitForAsyncEvents(500L));
        Assert.assertEquals((String)"but should only have 1 thread actually sitting on the semaphore waiting", (long)1L, (long)serviceSemaphore.getQueueLength());
        logger.debug("run: releasing consistencyService");
        serviceSemaphore.release(1);
        logger.debug("run: waiting 1sec");
        Thread.sleep(1000L);
        Assert.assertFalse((String)"should not be locked", (boolean)lock.isLocked());
        TestHelper.assertNoEvents(listener);
        serviceSemaphore.release(1);
        logger.debug("run: waiting 1sec");
        Thread.sleep(1000L);
        logger.debug("run: asserting 1 event");
        TopologyEvent changedEvent = EventHelper.newChangedEvent((BaseTopologyView)view1, (BaseTopologyView)view3);
        this.assertEvents(listener, changedEvent);
        commonsLogger.setLevel(Level.INFO);
    }
}

