/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.lang.reflect.Field;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.spi.RootLogger;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.testing.junit.categories.Slow;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DummyTopologyView;
import org.apache.sling.discovery.commons.providers.EventHelper;
import org.apache.sling.discovery.commons.providers.base.AsyncEventSender;
import org.apache.sling.discovery.commons.providers.base.DummyDiscoveryService;
import org.apache.sling.discovery.commons.providers.base.DummyListener;
import org.apache.sling.discovery.commons.providers.base.DummyScheduler;
import org.apache.sling.discovery.commons.providers.base.MinEventDelayHandler;
import org.apache.sling.discovery.commons.providers.base.TestHelper;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerImpl;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMinEventDelayHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ViewStateManagerImpl mgr;
    private Random defaultRandom;
    private DummyDiscoveryService sds;
    private Level logLevel;
    private DummyScheduler scheduler;

    @Before
    public void setup() throws Exception {
        this.mgr = new ViewStateManagerImpl((Lock)new ReentrantLock(), new ClusterSyncService(){

            public void sync(BaseTopologyView view, Runnable callback) {
                callback.run();
            }

            public void cancelSync() {
            }
        });
        this.defaultRandom = new Random(1234123412L);
        this.scheduler = new DummyScheduler();
        this.sds = new DummyDiscoveryService();
        this.mgr.installMinEventDelayHandler((DiscoveryService)this.sds, (Scheduler)this.scheduler, 1L);
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        this.logLevel = discoveryLogger.getLevel();
        discoveryLogger.setLevel(Level.INFO);
    }

    @After
    public void teardown() throws Exception {
        this.mgr = null;
        this.defaultRandom = null;
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        discoveryLogger.setLevel(this.logLevel);
    }

    @Test
    public void testReactivate() throws Exception {
        this.logger.info("testReactivate: start");
        this.mgr.installMinEventDelayHandler((DiscoveryService)this.sds, (Scheduler)this.scheduler, 2L);
        DummyListener listener = new DummyListener();
        this.logger.info("testReactivate: calling handleActivated");
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view1 = new DummyTopologyView().addInstance();
        DummyTopologyView view2 = DummyTopologyView.clone(view1).addInstance(UUID.randomUUID().toString(), (DefaultClusterView)view1.getLocalInstance().getClusterView(), false, false);
        DummyTopologyView view3 = DummyTopologyView.clone(view1).addInstance(UUID.randomUUID().toString(), (DefaultClusterView)view1.getLocalInstance().getClusterView(), false, false);
        this.logger.info("testReactivate: calling handleNewView...");
        this.mgr.handleNewView((BaseTopologyView)view1);
        this.logger.info("testReactivate: asserting init event");
        TestHelper.assertEvents(this.mgr, listener, EventHelper.newInitEvent((BaseTopologyView)view1));
        this.logger.info("testReactivate: calling handleChanging...");
        this.mgr.handleChanging();
        TestHelper.assertEvents(this.mgr, listener, EventHelper.newChangingEvent((BaseTopologyView)view1));
        this.logger.info("testReactivate: calling handleNewView 2nd time...");
        this.mgr.handleNewView((BaseTopologyView)view2);
        TestHelper.assertNoEvents(listener);
        this.sds.setTopoology(view2);
        this.logger.info("testReactivate: waiting for async events to have been processed - 4sec");
        Thread.sleep(4000L);
        this.logger.info("testReactivate: waiting for async events to have been processed - max another 2sec");
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(2000L));
        this.logger.info("testReactivate: asserting CHANGED event");
        TestHelper.assertEvents(this.mgr, listener, EventHelper.newChangedEvent((BaseTopologyView)view1, (BaseTopologyView)view2));
        this.logger.info("testReactivate: calling handleChanging...");
        this.mgr.handleChanging();
        TestHelper.assertEvents(this.mgr, listener, EventHelper.newChangingEvent((BaseTopologyView)view2));
        this.logger.info("testReactivate: calling handleNewView 2nd time...");
        this.mgr.handleNewView((BaseTopologyView)view3);
        TestHelper.assertNoEvents(listener);
        this.sds.setTopoology(view3);
        this.logger.info("testReactivate: doing handleDeactivated");
        AsyncEventSender asyncEventSender = this.mgr.getAsyncEventSender();
        Field field = this.mgr.getClass().getDeclaredField("minEventDelayHandler");
        field.setAccessible(true);
        MinEventDelayHandler minEventDelayHandler = (MinEventDelayHandler)field.get(this.mgr);
        Assert.assertNotNull((Object)minEventDelayHandler);
        view3.setNotCurrent();
        this.sds.setTopoology(view3);
        this.mgr.handleDeactivated();
        TestHelper.assertNoEvents(listener);
        this.logger.info("testReactivate: now waiting 5 sec to make sure the MinEventDelayHandler would be finished");
        TestHelper.assertNoEvents(listener);
        Thread.sleep(5000L);
        this.logger.info("testReactivate: after those 5 sec there should however still not be any new event");
        TestHelper.assertNoEvents(listener);
        int cnt = asyncEventSender.getInFlightEventCnt();
        if (minEventDelayHandler != null && minEventDelayHandler.isDelaying()) {
            ++cnt;
        }
        Assert.assertEquals((long)0L, (long)cnt);
    }

    private void assertNoEvents(DummyListener listener) {
        Assert.assertEquals((long)0L, (long)listener.countEvents());
    }

    @Category(value={Slow.class})
    @Test
    public void testNormalDelaying() throws Exception {
        DummyListener listener = new DummyListener();
        this.logger.info("testNormalDelaying: calling handleActivated...");
        this.mgr.handleActivated();
        this.assertNoEvents(listener);
        this.logger.info("testNormalDelaying: calling bind...");
        this.mgr.bind((TopologyEventListener)listener);
        this.assertNoEvents(listener);
        this.logger.info("testNormalDelaying: calling handleChanging...");
        this.mgr.handleChanging();
        this.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.logger.info("testNormalDelaying: calling handleNewView...");
        this.mgr.handleNewView((BaseTopologyView)view);
        TestHelper.assertEvents(this.mgr, listener, EventHelper.newInitEvent((BaseTopologyView)view));
        for (int i = 0; i < 7; ++i) {
            this.logger.info("testNormalDelaying: calling randomEventLoop...");
            TestHelper.randomEventLoop(this.mgr, this.sds, 4, 1500, this.defaultRandom, listener);
            Thread.sleep(1000L);
        }
    }

    @Category(value={Slow.class})
    @Test
    public void testFailedDelaying() throws Exception {
        this.scheduler.failMode();
        DummyListener listener = new DummyListener();
        this.mgr.handleActivated();
        this.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        this.assertNoEvents(listener);
        this.mgr.handleChanging();
        this.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        TestHelper.assertEvents(this.mgr, listener, EventHelper.newInitEvent((BaseTopologyView)view));
        for (int i = 0; i < 7; ++i) {
            TestHelper.randomEventLoop(this.mgr, this.sds, 100, -1, this.defaultRandom, listener);
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testLongMinDelay() throws Exception {
        this.mgr.installMinEventDelayHandler((DiscoveryService)this.sds, (Scheduler)this.scheduler, 5L);
        DummyListener listener = new DummyListener();
        this.logger.info("testLongMinDelay: calling handleActivated...");
        this.mgr.handleActivated();
        this.assertNoEvents(listener);
        this.logger.info("testLongMinDelay: calling bind...");
        this.mgr.bind((TopologyEventListener)listener);
        this.assertNoEvents(listener);
        this.logger.info("testLongMinDelay: calling handleChanging...");
        this.mgr.handleChanging();
        this.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        DummyTopologyView clonedView = view.clone();
        this.logger.info("testLongMinDelay: calling handleNewView...");
        this.mgr.handleNewView((BaseTopologyView)view);
        TestHelper.assertEvents(this.mgr, listener, EventHelper.newInitEvent((BaseTopologyView)view));
        DummyTopologyView view2 = new DummyTopologyView().addInstance();
        view2.addInstance(UUID.randomUUID().toString(), (DefaultClusterView)view2.getLocalInstance().getClusterView(), false, false);
        this.logger.info("testLongMinDelay: calling handleNewView...");
        clonedView.setNotCurrent();
        this.mgr.handleNewView((BaseTopologyView)view2);
        TestHelper.assertEvents(this.mgr, listener, EventHelper.newChangingEvent((BaseTopologyView)clonedView));
        Assert.assertFalse((boolean)view.isCurrent());
    }
}

