/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.InstanceFilter;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstancesDiff {
    private static final InstanceFilter LOCAL_INSTANCE = new LocalInstanceFilter();
    private static final InstanceFilter NOT_LOCAL_INSTANCE = new NotFilter(LOCAL_INSTANCE);
    private static final InstanceFilter LEADER_INSTANCE = new LeaderInstanceFilter();
    private static final InstanceFilter NOT_LEADER_INSTANCE = new NotFilter(LEADER_INSTANCE);
    private final Map<String, InstanceDescription> oldInstances;
    private final Map<String, InstanceDescription> newInstances;

    public InstancesDiff(@NotNull TopologyEvent event) {
        this(InstancesDiff.instancesOrEmpty(event.getOldView()), InstancesDiff.instancesOrEmpty(event.getNewView()));
    }

    public InstancesDiff(@NotNull TopologyView oldView, @NotNull TopologyView newView) {
        this(oldView.getInstances(), newView.getInstances());
    }

    public InstancesDiff(@NotNull ClusterView oldView, @NotNull ClusterView newView) {
        this(oldView.getInstances(), newView.getInstances());
    }

    public <T extends InstanceDescription> InstancesDiff(@NotNull Collection<T> oldInstances, @NotNull Collection<T> newInstances) {
        this.newInstances = InstancesDiff.getInstancesMap(newInstances);
        this.oldInstances = InstancesDiff.getInstancesMap(oldInstances);
    }

    @NotNull
    public InstanceCollection all(boolean retainFromNewCollection) {
        return new InstanceCollection(this.partitionAll(retainFromNewCollection));
    }

    @NotNull
    public InstanceCollection added() {
        return new InstanceCollection(this.partitionAdded());
    }

    @NotNull
    public InstanceCollection removed() {
        return new InstanceCollection(this.partitionRemoved());
    }

    @NotNull
    public InstanceCollection retained(boolean retainFromNewCollection) {
        return new InstanceCollection(this.partitionRetained(retainFromNewCollection));
    }

    @NotNull
    public InstanceCollection retained(boolean retainFromNewCollection, boolean propertyChanged) {
        return new InstanceCollection(this.partitionRetained(retainFromNewCollection, propertyChanged));
    }

    @NotNull
    private Map<String, InstanceDescription> partitionAll(boolean retainFromNewCollection) {
        HashMap<String, InstanceDescription> partition = new HashMap<String, InstanceDescription>();
        if (retainFromNewCollection) {
            partition.putAll(this.oldInstances);
            partition.putAll(this.newInstances);
        } else {
            partition.putAll(this.newInstances);
            partition.putAll(this.oldInstances);
        }
        return partition;
    }

    @NotNull
    private Map<String, InstanceDescription> partitionRemoved() {
        HashMap<String, InstanceDescription> partition = new HashMap<String, InstanceDescription>(this.oldInstances);
        partition.keySet().removeAll(this.newInstances.keySet());
        return partition;
    }

    @NotNull
    private Map<String, InstanceDescription> partitionAdded() {
        HashMap<String, InstanceDescription> partition = new HashMap<String, InstanceDescription>(this.newInstances);
        partition.keySet().removeAll(this.oldInstances.keySet());
        return partition;
    }

    @NotNull
    private Map<String, InstanceDescription> partitionRetained(boolean retainFromNewCollection, boolean propertyChanged) {
        HashMap<String, InstanceDescription> partition = new HashMap<String, InstanceDescription>();
        for (Map.Entry<String, InstanceDescription> oldEntry : this.oldInstances.entrySet()) {
            String slingId = oldEntry.getKey();
            InstanceDescription newDescription = this.newInstances.get(slingId);
            if (newDescription == null) continue;
            InstanceDescription oldDescription = oldEntry.getValue();
            boolean propertiesSame = newDescription.getProperties().equals(oldDescription.getProperties());
            if ((!propertiesSame || propertyChanged) && (propertiesSame || !propertyChanged)) continue;
            partition.put(slingId, retainFromNewCollection ? newDescription : oldDescription);
        }
        return partition;
    }

    @NotNull
    private Map<String, InstanceDescription> partitionRetained(boolean retainFromNewCollection) {
        HashMap<String, InstanceDescription> partition = new HashMap<String, InstanceDescription>();
        if (retainFromNewCollection) {
            partition.putAll(this.newInstances);
            partition.keySet().retainAll(this.oldInstances.keySet());
        } else {
            partition.putAll(this.oldInstances);
            partition.keySet().retainAll(this.newInstances.keySet());
        }
        return partition;
    }

    @NotNull
    private static Set<InstanceDescription> instancesOrEmpty(@Nullable TopologyView topologyView) {
        return topologyView != null ? topologyView.getInstances() : Collections.emptySet();
    }

    @NotNull
    private static <T extends InstanceDescription> Map<String, InstanceDescription> getInstancesMap(@NotNull Collection<T> instances) {
        HashMap<String, InstanceDescription> instancesMap = new HashMap<String, InstanceDescription>();
        for (InstanceDescription instance : instances) {
            String slingId = instance.getSlingId();
            if (slingId == null || instancesMap.put(slingId, instance) == null) continue;
            throw new IllegalArgumentException(String.format("Duplicated instance found for slingId: %s", slingId));
        }
        return instancesMap;
    }

    public final class InstanceCollection {
        private final Map<String, InstanceDescription> instances;
        private final Set<InstanceFilter> filters = new HashSet<InstanceFilter>();

        @NotNull
        public InstanceCollection filterWith(@Nullable InstanceFilter filter) {
            if (filter != null) {
                this.filters.add(filter);
            }
            return this;
        }

        @NotNull
        public InstanceCollection isLocal() {
            this.filters.add(LOCAL_INSTANCE);
            return this;
        }

        @NotNull
        public InstanceCollection isNotLocal() {
            this.filters.add(NOT_LOCAL_INSTANCE);
            return this;
        }

        @NotNull
        public InstanceCollection isLeader() {
            this.filters.add(LEADER_INSTANCE);
            return this;
        }

        @NotNull
        public InstanceCollection isNotLeader() {
            this.filters.add(NOT_LEADER_INSTANCE);
            return this;
        }

        @NotNull
        public InstanceCollection isInClusterView(@Nullable ClusterView clusterView) {
            if (clusterView != null) {
                this.filters.add(new InClusterView(clusterView));
            }
            return this;
        }

        @NotNull
        public InstanceCollection isNotInClusterView(@Nullable ClusterView clusterView) {
            if (clusterView != null) {
                this.filters.add(new NotFilter(new InClusterView(clusterView)));
            }
            return this;
        }

        @NotNull
        public Collection<InstanceDescription> get() {
            return this.applyFilters();
        }

        private InstanceCollection(Map<String, InstanceDescription> instances) {
            this.instances = instances;
        }

        @NotNull
        private Collection<InstanceDescription> applyFilters() {
            Iterator<Map.Entry<String, InstanceDescription>> entries = this.instances.entrySet().iterator();
            block0: while (entries.hasNext()) {
                Map.Entry<String, InstanceDescription> entry = entries.next();
                for (InstanceFilter filter : this.filters) {
                    if (filter.accept(entry.getValue())) continue;
                    entries.remove();
                    continue block0;
                }
            }
            return Collections.unmodifiableCollection(this.instances.values());
        }
    }

    private static final class InClusterView
    implements InstanceFilter {
        private final ClusterView view;

        private InClusterView(ClusterView view) {
            this.view = view;
        }

        public boolean accept(InstanceDescription instance) {
            return this.view.getId().equals(instance.getClusterView().getId());
        }
    }

    private static final class LeaderInstanceFilter
    implements InstanceFilter {
        private LeaderInstanceFilter() {
        }

        public boolean accept(InstanceDescription instance) {
            return instance.isLeader();
        }
    }

    private static final class LocalInstanceFilter
    implements InstanceFilter {
        private LocalInstanceFilter() {
        }

        public boolean accept(InstanceDescription instance) {
            return instance.isLocal();
        }
    }

    private static final class NotFilter
    implements InstanceFilter {
        final InstanceFilter filter;

        private NotFilter(InstanceFilter filter) {
            this.filter = filter;
        }

        public boolean accept(InstanceDescription instance) {
            return !this.filter.accept(instance);
        }
    }
}

