/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.base;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.spi.RootLogger;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.DummyTopologyView;
import org.apache.sling.discovery.commons.providers.EventHelper;
import org.apache.sling.discovery.commons.providers.base.DummyListener;
import org.apache.sling.discovery.commons.providers.base.DummyScheduler;
import org.apache.sling.discovery.commons.providers.base.TestHelper;
import org.apache.sling.discovery.commons.providers.base.ViewStateManagerImpl;
import org.apache.sling.discovery.commons.providers.spi.ClusterSyncService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewStateManager {
    protected static final Logger logger = LoggerFactory.getLogger(TestViewStateManager.class);
    protected ViewStateManagerImpl mgr;
    private Random defaultRandom;
    private Level logLevel;

    @Before
    public void setup() throws Exception {
        this.mgr = new ViewStateManagerImpl((Lock)new ReentrantLock(), new ClusterSyncService(){

            public void sync(BaseTopologyView view, Runnable callback) {
                callback.run();
            }

            public void cancelSync() {
            }
        });
        this.defaultRandom = new Random(1234123412L);
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        this.logLevel = discoveryLogger.getLevel();
        discoveryLogger.setLevel(Level.INFO);
    }

    @After
    public void teardown() throws Exception {
        if (this.mgr != null) {
            this.mgr.handleDeactivated();
        }
        this.mgr = null;
        this.defaultRandom = null;
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        discoveryLogger.setLevel(this.logLevel);
    }

    void assertEvents(DummyListener listener, TopologyEvent ... events) {
        TestHelper.assertEvents(this.mgr, listener, events);
    }

    protected void randomEventLoop(Random random, DummyListener ... listeners) throws InterruptedException {
        TestHelper.randomEventLoop(this.mgr, null, 5, -1, random, listeners);
    }

    @Test
    public void testChangedPropertiesChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.installMinEventDelayHandler(new DiscoveryService(){

            public TopologyView getTopology() {
                throw new IllegalStateException("not yet impl");
            }
        }, (Scheduler)new DummyScheduler(), 1L);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view1 = new DummyTopologyView().addInstance();
        InstanceDescription instance1 = (InstanceDescription)view1.getInstances().iterator().next();
        ClusterView cluster1 = instance1.getClusterView();
        this.mgr.handleNewView((BaseTopologyView)view1);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view1));
        DefaultClusterView cluster2 = new DefaultClusterView(new String(cluster1.getId()));
        DummyTopologyView view2 = new DummyTopologyView(view1.getLocalClusterSyncTokenId()).addInstance(instance1.getSlingId(), cluster2, instance1.isLeader(), instance1.isLocal());
        DefaultInstanceDescription instance2 = (DefaultInstanceDescription)view2.getLocalInstance();
        instance2.setProperty("foo", "bar");
        this.mgr.handleNewView((BaseTopologyView)view2);
        this.assertEvents(listener, EventHelper.newPropertiesChangedEvent((BaseTopologyView)view1, (BaseTopologyView)view2));
    }

    @Test
    public void testDuplicateListeners() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.bind((TopologyEventListener)listener);
        Assert.assertTrue((boolean)this.mgr.unbind((TopologyEventListener)listener));
        Assert.assertFalse((boolean)this.mgr.unbind((TopologyEventListener)listener));
        this.mgr.handleActivated();
        Assert.assertFalse((boolean)this.mgr.unbind((TopologyEventListener)listener));
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.bind((TopologyEventListener)listener);
        Assert.assertTrue((boolean)this.mgr.unbind((TopologyEventListener)listener));
        Assert.assertFalse((boolean)this.mgr.unbind((TopologyEventListener)listener));
    }

    @Test
    public void testBindActivateChangingChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testBindChangingActivateChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testBindChangingChangedActivate() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testBindChangingChangedChangingActivate() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view2 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view2);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view2));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testBindChangedChangingActivate() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view2 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view2);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view2));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelSync() throws Exception {
        final LinkedList syncCallbacks = new LinkedList();
        this.mgr = new ViewStateManagerImpl((Lock)new ReentrantLock(), new ClusterSyncService(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sync(BaseTopologyView view, Runnable callback) {
                List list = syncCallbacks;
                synchronized (list) {
                    syncCallbacks.add(callback);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancelSync() {
                List list = syncCallbacks;
                synchronized (list) {
                    syncCallbacks.clear();
                }
            }
        });
        this.mgr.handleActivated();
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.handleChanging();
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(1000L));
        TestHelper.assertNoEvents(listener);
        LinkedList linkedList = syncCallbacks;
        synchronized (linkedList) {
            Assert.assertEquals((long)1L, (long)syncCallbacks.size());
        }
        String id1 = UUID.randomUUID().toString();
        String id2 = UUID.randomUUID().toString();
        DummyTopologyView view2 = TestHelper.newView(true, id1, id1, id1, id2);
        this.mgr.handleNewView((BaseTopologyView)view2);
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(1000L));
        TestHelper.assertNoEvents(listener);
        LinkedList linkedList2 = syncCallbacks;
        synchronized (linkedList2) {
            Assert.assertEquals((long)1L, (long)syncCallbacks.size());
            ((Runnable)syncCallbacks.get(0)).run();
            syncCallbacks.clear();
        }
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(1000L));
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view2));
    }

    @Test
    public void testActivateBindChangingChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testPropertiesChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.handleActivated();
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.handleChanging();
        DummyTopologyView oldView = new DummyTopologyView().addInstance();
        DefaultInstanceDescription localInstance = (DefaultInstanceDescription)oldView.getLocalInstance();
        localInstance.setProperty("foo", "bar1");
        this.mgr.handleNewView((BaseTopologyView)oldView);
        TopologyEvent initEvent = EventHelper.newInitEvent((BaseTopologyView)oldView.clone());
        this.assertEvents(listener, initEvent);
        DummyTopologyView newView = oldView.clone();
        oldView.setNotCurrent();
        localInstance = (DefaultInstanceDescription)newView.getLocalInstance();
        localInstance.setProperty("foo", "bar2");
        this.mgr.handleNewView((BaseTopologyView)newView);
        Thread.sleep(2000L);
        TopologyEvent propertiesChangedEvent = EventHelper.newPropertiesChangedEvent((BaseTopologyView)oldView.clone(), (BaseTopologyView)newView.clone());
        this.assertEvents(listener, propertiesChangedEvent);
    }

    @Test
    public void testActivateChangingBindChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testActivateChangingChangedBind() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testBindActivateBindChangingChanged() throws Exception {
        DummyListener listener1 = new DummyListener();
        DummyListener listener2 = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener1);
        TestHelper.assertNoEvents(listener1);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener1);
        this.mgr.bind((TopologyEventListener)listener2);
        TestHelper.assertNoEvents(listener1);
        TestHelper.assertNoEvents(listener2);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener1);
        TestHelper.assertNoEvents(listener2);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        this.assertEvents(listener1, EventHelper.newInitEvent((BaseTopologyView)view));
        this.assertEvents(listener2, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener1, listener2);
    }

    @Test
    public void testBindActivateChangingBindChanged() throws Exception {
        DummyListener listener1 = new DummyListener();
        DummyListener listener2 = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener1);
        TestHelper.assertNoEvents(listener1);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener1);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener1);
        this.mgr.bind((TopologyEventListener)listener2);
        TestHelper.assertNoEvents(listener1);
        TestHelper.assertNoEvents(listener2);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        this.assertEvents(listener1, EventHelper.newInitEvent((BaseTopologyView)view));
        this.assertEvents(listener2, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener1, listener2);
    }

    @Test
    public void testActivateBindChangingDuplicateHandleNewView() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.handleActivated();
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.handleChanging();
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view));
        this.mgr.handleNewView((BaseTopologyView)DummyTopologyView.clone(view));
        TestHelper.assertNoEvents(listener);
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testActivateBindChangingChangedBindDuplicateHandleNewView() throws Exception {
        DummyListener listener1 = new DummyListener();
        this.mgr.handleActivated();
        this.mgr.bind((TopologyEventListener)listener1);
        this.mgr.handleChanging();
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        this.assertEvents(listener1, EventHelper.newInitEvent((BaseTopologyView)view));
        DummyListener listener2 = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener2);
        this.mgr.handleNewView((BaseTopologyView)DummyTopologyView.clone(view));
        TestHelper.assertNoEvents(listener1);
        this.assertEvents(listener2, EventHelper.newInitEvent((BaseTopologyView)view));
        this.randomEventLoop(this.defaultRandom, listener1, listener2);
    }

    @Test
    public void testActivateChangedBindDuplicateHandleNewView() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view);
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view));
        this.mgr.handleNewView((BaseTopologyView)DummyTopologyView.clone(view));
        TestHelper.assertNoEvents(listener);
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testBindActivateChangedChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view1 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view1);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view1));
        DummyTopologyView view2 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view2);
        this.assertEvents(listener, EventHelper.newChangingEvent((BaseTopologyView)view1), EventHelper.newChangedEvent((BaseTopologyView)view1, (BaseTopologyView)view2));
        this.randomEventLoop(this.defaultRandom, listener);
    }

    @Test
    public void testBindActivateChangedDeactivateChangingActivateChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view1 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view1);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view1));
        this.mgr.handleDeactivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view2 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view2);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view2));
    }

    @Test
    public void testBindActivateChangedDeactivateChangedActivateChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view1 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view1);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view1));
        this.mgr.handleDeactivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view2 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view2);
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.handleActivated();
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view2));
        DummyTopologyView view3 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view3);
        this.assertEvents(listener, EventHelper.newChangingEvent((BaseTopologyView)view2), EventHelper.newChangedEvent((BaseTopologyView)view2, (BaseTopologyView)view3));
    }

    @Test
    public void testBindActivateChangedChangingDeactivateActivateChangingChanged() throws Exception {
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view1 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view1);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view1));
        this.mgr.handleChanging();
        this.assertEvents(listener, EventHelper.newChangingEvent((BaseTopologyView)view1));
        this.mgr.handleDeactivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.bind((TopologyEventListener)listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        this.mgr.handleChanging();
        TestHelper.assertNoEvents(listener);
        DummyTopologyView view2 = new DummyTopologyView().addInstance();
        this.mgr.handleNewView((BaseTopologyView)view2);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view2));
    }

    @Test
    public void testClusterSyncService_noConcurrency() throws Exception {
        org.apache.log4j.Logger commonsLogger = RootLogger.getLogger((String)"org.apache.sling.discovery.commons.providers");
        commonsLogger.setLevel(Level.INFO);
        Semaphore serviceSemaphore = new Semaphore(0);
        ReentrantLock lock = new ReentrantLock();
        ClusterSyncServiceWithSemaphore cs = new ClusterSyncServiceWithSemaphore(lock, serviceSemaphore);
        this.mgr = new ViewStateManagerImpl((Lock)lock, (ClusterSyncService)cs);
        DummyListener listener = new DummyListener();
        this.mgr.bind((TopologyEventListener)listener);
        TestHelper.assertNoEvents(listener);
        this.mgr.handleActivated();
        TestHelper.assertNoEvents(listener);
        String slingId1 = UUID.randomUUID().toString();
        String slingId2 = UUID.randomUUID().toString();
        String clusterId = UUID.randomUUID().toString();
        DefaultClusterView cluster = new DefaultClusterView(clusterId);
        final DummyTopologyView view1 = new DummyTopologyView().addInstance(slingId1, cluster, true, true).addInstance(slingId2, cluster, false, false);
        this.async(new Runnable(){

            @Override
            public void run() {
                TestViewStateManager.this.mgr.handleNewView((BaseTopologyView)view1);
            }
        });
        Thread.sleep(1000L);
        TestHelper.assertNoEvents(listener);
        serviceSemaphore.release(1);
        Thread.sleep(1000L);
        this.assertEvents(listener, EventHelper.newInitEvent((BaseTopologyView)view1));
        final DummyTopologyView view2 = view1.clone();
        this.mgr.handleChanging();
        this.assertEvents(listener, EventHelper.newChangingEvent((BaseTopologyView)view1));
        view2.removeInstance(slingId2);
        this.async(new Runnable(){

            @Override
            public void run() {
                TestViewStateManager.this.mgr.handleNewView((BaseTopologyView)view2);
            }
        });
        logger.debug("run: waiting for 1sec");
        Thread.sleep(1000L);
        logger.debug("run: asserting no events");
        TestHelper.assertNoEvents(listener);
        logger.debug("run: releasing consistencyService");
        serviceSemaphore.release(1);
        logger.debug("run: waiting 1sec");
        Thread.sleep(1000L);
        logger.debug("run: asserting 1 event");
        this.assertEvents(listener, EventHelper.newChangedEvent((BaseTopologyView)view1, (BaseTopologyView)view2));
        commonsLogger.setLevel(Level.INFO);
    }

    protected void async(Runnable runnable) {
        new Thread(runnable).start();
    }

    @Test
    public void testOnlyDiffersInProperties() throws Exception {
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        discoveryLogger.setLevel(Level.INFO);
        logger.info("testOnlyDiffersInProperties: start");
        String slingId1 = UUID.randomUUID().toString();
        String slingId2 = UUID.randomUUID().toString();
        String slingId3 = UUID.randomUUID().toString();
        String clusterId = UUID.randomUUID().toString();
        DefaultClusterView cluster = new DefaultClusterView(clusterId);
        DummyTopologyView view1 = new DummyTopologyView().addInstance(slingId1, cluster, true, true).addInstance(slingId2, cluster, false, false).addInstance(slingId3, cluster, false, false);
        DummyTopologyView view2 = DummyTopologyView.clone(view1).removeInstance(slingId2);
        DummyTopologyView view3 = DummyTopologyView.clone(view1).removeInstance(slingId2).removeInstance(slingId3);
        DummyTopologyView view1Cloned = DummyTopologyView.clone(view1);
        logger.info("testOnlyDiffersInProperties: handleNewView(view1)");
        this.mgr.handleNewView((BaseTopologyView)view1);
        logger.info("testOnlyDiffersInProperties: handleActivated()");
        this.mgr.handleActivated();
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(5000L));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view1));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view2));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view3));
        logger.info("testOnlyDiffersInProperties: handleNewView(view2)");
        this.mgr.handleNewView((BaseTopologyView)view2);
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(5000L));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view1));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view2));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view3));
        logger.info("testOnlyDiffersInProperties: handleNewView(view3)");
        this.mgr.handleNewView((BaseTopologyView)view3);
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(5000L));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view1));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view2));
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view3));
        DummyTopologyView view4 = DummyTopologyView.clone(view1Cloned);
        DummyTopologyView view5 = DummyTopologyView.clone(view1Cloned);
        DummyTopologyView view6 = DummyTopologyView.clone(view1Cloned);
        logger.info("testOnlyDiffersInProperties: handleNewView(view1cloned)");
        this.mgr.handleNewView((BaseTopologyView)view1Cloned);
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(5000L));
        DefaultInstanceDescription i4_1 = (DefaultInstanceDescription)view4.getInstance(slingId1);
        i4_1.setProperty("a", "b");
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view4)");
        Assert.assertTrue((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view4));
        DefaultInstanceDescription i5_1 = (DefaultInstanceDescription)view5.getInstance(slingId1);
        i5_1.setProperty("a", "b");
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view5)");
        Assert.assertTrue((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view5));
        DummyTopologyView view4Cloned = DummyTopologyView.clone(view4);
        this.mgr.handleNewView((BaseTopologyView)view4);
        Assert.assertEquals((long)0L, (long)this.mgr.waitForAsyncEvents(5000L));
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view4Cloned)");
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view4Cloned));
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view5)");
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view5));
        DefaultInstanceDescription i6_1 = (DefaultInstanceDescription)view6.getInstance(slingId1);
        i6_1.setProperty("a", "c");
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view6)");
        Assert.assertTrue((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view6));
        String originalId = view6.getLocalClusterSyncTokenId();
        view6.setId(UUID.randomUUID().toString());
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view6) [2]");
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view6));
        view6.setId(originalId);
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view6) [3]");
        Assert.assertTrue((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view6));
        view6.setId(null);
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view6) [4]");
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view6));
        view6.setId(originalId);
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view6) [5]");
        Assert.assertTrue((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view6));
        view4.setId(null);
        view6.setId(null);
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view6) [6]");
        Assert.assertTrue((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view6));
        view6.setId(originalId);
        logger.info("testOnlyDiffersInProperties: onlyDiffersInProperties(view6) [7]");
        Assert.assertFalse((boolean)this.mgr.onlyDiffersInProperties((BaseTopologyView)view6));
    }

    class ClusterSyncServiceWithSemaphore
    implements ClusterSyncService {
        private final Semaphore semaphore;
        private final Lock lock;

        public ClusterSyncServiceWithSemaphore(Lock lock, Semaphore semaphore) {
            this.lock = lock;
            this.semaphore = semaphore;
        }

        public void sync(BaseTopologyView view, Runnable callback) {
            try {
                this.lock.unlock();
                try {
                    logger.info("ClusterSyncServiceWithSemaphore.sync: acquiring lock ...");
                    this.semaphore.acquire();
                    logger.info("ClusterSyncServiceWithSemaphore.sync: lock acquired.");
                }
                finally {
                    this.lock.lock();
                }
                callback.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void cancelSync() {
        }
    }
}

