/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.InstanceFilter;
import org.apache.sling.discovery.commons.providers.BaseTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;

public class DummyTopologyView
extends BaseTopologyView {
    private List<InstanceDescription> instances = new LinkedList<InstanceDescription>();
    private String id;

    public DummyTopologyView() {
        this.id = UUID.randomUUID().toString();
    }

    public DummyTopologyView(String id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DummyTopologyView)) {
            return false;
        }
        DummyTopologyView other = (DummyTopologyView)((Object)obj);
        if (this == other) {
            return true;
        }
        if (this.id == null && other.id != null || other.id == null && this.id != null || this.id != null && !this.id.equals(other.id)) {
            return false;
        }
        if (this.instances.size() != other.instances.size()) {
            return false;
        }
        for (InstanceDescription instanceDescription : this.instances) {
            boolean found = false;
            for (InstanceDescription otherId : other.instances) {
                if (!instanceDescription.equals(otherId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int c = 0;
        for (InstanceDescription instanceDescription : this.instances) {
            c += instanceDescription.hashCode();
        }
        return c;
    }

    public void addInstanceDescription(InstanceDescription id) {
        this.instances.add(id);
    }

    public InstanceDescription getLocalInstance() {
        InstanceDescription result = null;
        for (InstanceDescription instanceDescription : this.instances) {
            if (!instanceDescription.isLocal()) continue;
            if (result != null) {
                throw new IllegalStateException("multiple local instances");
            }
            result = instanceDescription;
        }
        if (result == null) {
            throw new IllegalStateException("no local instance found");
        }
        return result;
    }

    public Set<InstanceDescription> getInstances() {
        return new HashSet<InstanceDescription>(this.instances);
    }

    public Set<InstanceDescription> findInstances(InstanceFilter filter) {
        HashSet<InstanceDescription> result = new HashSet<InstanceDescription>();
        for (InstanceDescription instanceDescription : this.instances) {
            if (!filter.accept(instanceDescription)) continue;
            result.add(instanceDescription);
        }
        return result;
    }

    public Set<ClusterView> getClusterViews() {
        HashSet<ClusterView> clusters = new HashSet<ClusterView>();
        for (InstanceDescription instanceDescription : this.instances) {
            clusters.add(instanceDescription.getClusterView());
        }
        return clusters;
    }

    public String getLocalClusterSyncTokenId() {
        return this.id;
    }

    public DummyTopologyView addInstance() {
        String slingId = UUID.randomUUID().toString();
        String clusterId = UUID.randomUUID().toString();
        DefaultClusterView cluster = new DefaultClusterView(clusterId);
        DefaultInstanceDescription instance = new DefaultInstanceDescription(cluster, true, true, slingId, new HashMap());
        this.instances.add((InstanceDescription)instance);
        return this;
    }

    public DummyTopologyView addInstance(String slingId, DefaultClusterView cluster, boolean isLeader, boolean isLocal) {
        DefaultInstanceDescription instance = new DefaultInstanceDescription(cluster, isLeader, isLocal, slingId, new HashMap());
        this.instances.add((InstanceDescription)instance);
        return this;
    }

    public DummyTopologyView removeInstance(String slingId) {
        Iterator<InstanceDescription> it = this.instances.iterator();
        while (it.hasNext()) {
            InstanceDescription id = it.next();
            if (!id.getSlingId().equals(slingId)) continue;
            it.remove();
            DefaultClusterView cluster = (DefaultClusterView)id.getClusterView();
            if (!cluster.removeInstanceDescription(id)) {
                throw new IllegalStateException("could not remove id: " + id);
            }
            return this;
        }
        throw new IllegalStateException("instance not found: " + slingId);
    }

    public static DummyTopologyView clone(DummyTopologyView view) {
        DummyTopologyView result = new DummyTopologyView(view.id);
        Iterator<InstanceDescription> it = view.getInstances().iterator();
        HashMap<String, DefaultClusterView> clusters = new HashMap<String, DefaultClusterView>();
        while (it.hasNext()) {
            InstanceDescription id = it.next();
            String clusterId = id.getClusterView().getId();
            DefaultClusterView cluster = (DefaultClusterView)clusters.get(clusterId);
            if (cluster == null) {
                cluster = new DefaultClusterView(clusterId);
                clusters.put(clusterId, cluster);
            }
            DefaultInstanceDescription clone = DummyTopologyView.clone(cluster, id);
            result.addInstanceDescription((InstanceDescription)clone);
        }
        if (!view.isCurrent()) {
            result.setNotCurrent();
        }
        return result;
    }

    private static DefaultInstanceDescription clone(DefaultClusterView cluster, InstanceDescription id) {
        return new DefaultInstanceDescription(cluster, id.isLeader(), id.isLocal(), id.getSlingId(), id.getProperties());
    }

    public DummyTopologyView clone() {
        return DummyTopologyView.clone(this);
    }
}

