/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.base.connectors.DummyVirtualInstanceBuilder;
import org.apache.sling.discovery.base.connectors.announcement.Announcement;
import org.apache.sling.discovery.base.its.setup.TopologyHelper;
import org.apache.sling.discovery.base.its.setup.VirtualConnector;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<VirtualInstance> instances = new LinkedList<VirtualInstance>();

    private VirtualInstanceBuilder newBuilder() {
        return new DummyVirtualInstanceBuilder();
    }

    @After
    public void tearDown() throws Exception {
        for (VirtualInstance instance : this.instances) {
            instance.stop();
        }
    }

    @Test
    public void testTwoNodes() throws Throwable {
        VirtualInstanceBuilder builder1 = this.newBuilder().newRepository("/var/discovery/impl/", true).setDebugName("instance1").setConnectorPingInterval(20).setConnectorPingTimeout(200);
        VirtualInstance instance1 = builder1.build();
        this.instances.add(instance1);
        VirtualInstanceBuilder builder2 = this.newBuilder().useRepositoryOf(builder1).setDebugName("instance2").setConnectorPingInterval(20).setConnectorPingTimeout(200);
        VirtualInstance instance2 = builder2.build();
        this.instances.add(instance2);
        instance1.getConfig().setViewCheckTimeout(8);
        instance1.getConfig().setViewCheckInterval(1);
        instance2.getConfig().setViewCheckTimeout(2);
        instance2.getConfig().setViewCheckInterval(1);
        for (int i = 0; i < 5; ++i) {
            instance1.heartbeatsAndCheckView();
            instance2.heartbeatsAndCheckView();
            Thread.sleep(500L);
        }
        Set instances1 = instance1.getDiscoveryService().getTopology().getInstances();
        Set instances2 = instance2.getDiscoveryService().getTopology().getInstances();
        Assert.assertEquals((long)1L, (long)instances1.size());
        Assert.assertEquals((long)1L, (long)instances2.size());
        Assert.assertEquals((Object)instance1.getSlingId(), (Object)((InstanceDescription)instances1.iterator().next()).getSlingId());
        Assert.assertEquals((Object)instance2.getSlingId(), (Object)((InstanceDescription)instances2.iterator().next()).getSlingId());
        new VirtualConnector(instance1, instance2);
        Collection instance1LocalAnnouncements = instance1.getAnnouncementRegistry().listLocalAnnouncements();
        Assert.assertEquals((long)1L, (long)instance1LocalAnnouncements.size());
        Announcement instance1LocalAnnouncement = (Announcement)instance1LocalAnnouncements.iterator().next();
        Assert.assertEquals((Object)instance2.getSlingId(), (Object)instance1LocalAnnouncement.getOwnerId());
        Assert.assertEquals((Object)true, (Object)instance1LocalAnnouncement.isInherited());
        Collection instance2LocalAnnouncements = instance2.getAnnouncementRegistry().listLocalAnnouncements();
        Assert.assertEquals((long)1L, (long)instance2LocalAnnouncements.size());
        Announcement instance2LocalAnnouncement = (Announcement)instance2LocalAnnouncements.iterator().next();
        Assert.assertEquals((Object)instance1.getSlingId(), (Object)instance2LocalAnnouncement.getOwnerId());
        Assert.assertEquals((Object)false, (Object)instance2LocalAnnouncement.isInherited());
        TopologyHelper.assertTopologyConsistsOf(instance1.getDiscoveryService().getTopology(), instance1.getSlingId(), instance2.getSlingId());
        TopologyHelper.assertTopologyConsistsOf(instance2.getDiscoveryService().getTopology(), instance1.getSlingId(), instance2.getSlingId());
        instance1LocalAnnouncements = instance1.getAnnouncementRegistry().listLocalAnnouncements();
        Assert.assertEquals((long)1L, (long)instance1LocalAnnouncements.size());
        instance2LocalAnnouncements = instance2.getAnnouncementRegistry().listLocalAnnouncements();
        Assert.assertEquals((long)1L, (long)instance2LocalAnnouncements.size());
        Thread.sleep(2200L);
        instance1LocalAnnouncements = instance1.getAnnouncementRegistry().listLocalAnnouncements();
        Assert.assertEquals((long)1L, (long)instance1LocalAnnouncements.size());
        instance2LocalAnnouncements = instance2.getAnnouncementRegistry().listLocalAnnouncements();
        Assert.assertEquals((long)0L, (long)instance2LocalAnnouncements.size());
        this.logger.info("testTwoNodes: instance1: " + instance1.getSlingId());
        instance1.dumpRepo();
        this.logger.info("testTwoNodes: instance2: " + instance2.getSlingId());
        instance2.dumpRepo();
        TopologyHelper.assertTopologyConsistsOf(instance1.getDiscoveryService().getTopology(), instance1.getSlingId(), instance2.getSlingId());
        TopologyHelper.assertTopologyConsistsOf(instance2.getDiscoveryService().getTopology(), instance2.getSlingId());
        Thread.sleep(6000L);
        instance1LocalAnnouncements = instance1.getAnnouncementRegistry().listLocalAnnouncements();
        Assert.assertEquals((long)0L, (long)instance1LocalAnnouncements.size());
        instance2LocalAnnouncements = instance2.getAnnouncementRegistry().listLocalAnnouncements();
        Assert.assertEquals((long)0L, (long)instance2LocalAnnouncements.size());
        TopologyHelper.assertTopologyConsistsOf(instance1.getDiscoveryService().getTopology(), instance1.getSlingId());
        TopologyHelper.assertTopologyConsistsOf(instance2.getDiscoveryService().getTopology(), instance2.getSlingId());
    }
}

