/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.ping;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.ping.TopologyRequestValidator;
import org.apache.sling.discovery.base.its.setup.mock.SimpleConnectorConfig;
import org.hamcrest.Description;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TopologyRequestValidatorTest {
    private TopologyRequestValidator topologyRequestValidator;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void before() throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        SimpleConnectorConfig config = new SimpleConnectorConfig();
        this.setPrivate(config, "sharedKey", "testKey");
        this.setPrivate(config, "hmacEnabled", true);
        this.setPrivate(config, "encryptionEnabled", true);
        this.setPrivate(config, "keyInterval", 1440000);
        this.topologyRequestValidator = new TopologyRequestValidator((BaseConfig)config);
    }

    private void setPrivate(Object o, String field, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = o.getClass().getDeclaredField(field);
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        f.set(o, value);
    }

    @Test
    public void testTrustRequest() throws IOException {
        final HttpPut method = new HttpPut("/TestUri");
        String clearMessage = "TestMessage";
        final String message = this.topologyRequestValidator.encodeMessage(clearMessage);
        Assert.assertNotNull((Object)message);
        Assert.assertNotEquals((Object)message, (Object)clearMessage);
        this.topologyRequestValidator.trustMessage((HttpUriRequest)method, message);
        Assert.assertNotNull((Object)method.getFirstHeader("X-SlingTopologyHash"));
        Assert.assertNotNull((Object)method.getFirstHeader("X-SlingTopologyHash").getValue());
        Assert.assertTrue((method.getFirstHeader("X-SlingTopologyHash").getValue().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)method.getFirstHeader("X-SlingTopologyTrust"));
        Assert.assertNotNull((Object)method.getFirstHeader("X-SlingTopologyTrust").getValue());
        Assert.assertTrue((method.getFirstHeader("X-SlingTopologyTrust").getValue().length() > 0 ? 1 : 0) != 0);
        final HttpServletRequest request = (HttpServletRequest)this.context.mock(HttpServletRequest.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.allowing(request)).getHeader((String)this.with("X-SlingTopologyHash"));
                this.will(1.returnValue((Object)method.getFirstHeader("X-SlingTopologyHash").getValue()));
                ((HttpServletRequest)this.allowing(request)).getHeader((String)this.with("X-SlingTopologyTrust"));
                this.will(1.returnValue((Object)method.getFirstHeader("X-SlingTopologyTrust").getValue()));
                ((HttpServletRequest)this.allowing(request)).getHeader((String)this.with("Content-Encoding"));
                this.will(1.returnValue((Object)""));
                ((HttpServletRequest)this.allowing(request)).getRequestURI();
                this.will(1.returnValue((Object)method.getURI().getPath()));
                ((HttpServletRequest)this.allowing(request)).getReader();
                this.will(1.returnValue((Object)new BufferedReader(new StringReader(message))));
            }
        });
        Assert.assertTrue((boolean)this.topologyRequestValidator.isTrusted(request));
        Assert.assertEquals((Object)clearMessage, (Object)this.topologyRequestValidator.decodeMessage(request));
    }

    @Test
    public void testTrustResponse() throws IOException {
        final HttpServletRequest request = (HttpServletRequest)this.context.mock(HttpServletRequest.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.allowing(request)).getRequestURI();
                this.will(2.returnValue((Object)"/Test/Uri2"));
            }
        });
        final HttpServletResponse response = (HttpServletResponse)this.context.mock(HttpServletResponse.class);
        final HashMap headers = new HashMap();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletResponse)this.allowing(response)).setHeader((String)this.with(3.any(String.class)), (String)this.with(3.any(String.class)));
                this.will(new Action(){

                    public void describeTo(Description desc) {
                        desc.appendText("Setting header ");
                    }

                    public Object invoke(Invocation invocation) throws Throwable {
                        headers.put(invocation.getParameter(0), invocation.getParameter(1));
                        return null;
                    }
                });
            }
        });
        String clearMessage = "TestMessage2";
        final String message = this.topologyRequestValidator.encodeMessage(clearMessage);
        this.topologyRequestValidator.trustMessage(response, request, message);
        final HttpEntity responseEntity = (HttpEntity)this.context.mock(HttpEntity.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpEntity)this.allowing(responseEntity)).getContent();
                this.will(4.returnValue((Object)new ByteArrayInputStream(message.getBytes())));
            }
        });
        final HttpResponse resp = (HttpResponse)this.context.mock(HttpResponse.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpResponse)this.allowing(resp)).getFirstHeader((String)this.with(5.any(String.class)));
                this.will(new Action(){

                    public void describeTo(Description desc) {
                        desc.appendText("Getting (first) header ");
                    }

                    public Object invoke(Invocation invocation) throws Throwable {
                        return new BasicHeader((String)invocation.getParameter(0), (String)headers.get(invocation.getParameter(0)));
                    }
                });
                ((HttpResponse)this.allowing(resp)).getEntity();
                this.will(5.returnValue((Object)responseEntity));
            }
        });
        this.topologyRequestValidator.isTrusted(resp);
        this.topologyRequestValidator.decodeMessage("/Test/Uri2", resp);
    }
}

