/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.ping;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import javax.json.JsonException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.base.commons.ClusterViewHelper;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.Announcement;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementFilter;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.ping.TopologyRequestValidator;
import org.apache.sling.discovery.base.connectors.ping.wl.SubnetWhitelistEntry;
import org.apache.sling.discovery.base.connectors.ping.wl.WhitelistEntry;
import org.apache.sling.discovery.base.connectors.ping.wl.WildcardWhitelistEntry;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={TopologyConnectorServlet.class})
public class TopologyConnectorServlet
extends HttpServlet {
    private static final String TOPOLOGY_CONNECTOR_PREFIX = "/libs/sling/topology";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private AnnouncementRegistry announcementRegistry;
    @Reference
    private ClusterViewService clusterViewService;
    @Reference
    private HttpService httpService;
    @Reference
    private BaseConfig config;
    private final List<WhitelistEntry> whitelist = new ArrayList<WhitelistEntry>();
    private final Set<String> plaintextWhitelist = new HashSet<String>();
    private TopologyRequestValidator requestValidator;

    @Activate
    protected void activate(ComponentContext context) {
        this.whitelist.clear();
        if (!this.config.isHmacEnabled()) {
            String[] whitelistConfig = this.config.getTopologyConnectorWhitelist();
            this.initWhitelist(whitelistConfig);
        }
        this.requestValidator = new TopologyRequestValidator(this.config);
        try {
            this.httpService.registerServlet(TOPOLOGY_CONNECTOR_PREFIX, (Servlet)this, null, null);
            this.logger.info("activate: connector servlet registered at /libs/sling/topology");
        }
        catch (ServletException e) {
            this.logger.error("activate: ServletException while registering topology connector servlet: " + (Object)((Object)e), (Throwable)e);
        }
        catch (NamespaceException e) {
            this.logger.error("activate: NamespaceException while registering topology connector servlet: " + (Object)((Object)e), (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.httpService.unregister(TOPOLOGY_CONNECTOR_PREFIX);
    }

    void initWhitelist(String[] whitelistConfig) {
        if (whitelistConfig == null) {
            return;
        }
        for (int i = 0; i < whitelistConfig.length; ++i) {
            WhitelistEntry whitelistEntry;
            String aWhitelistEntry;
            block12: {
                aWhitelistEntry = whitelistConfig[i];
                whitelistEntry = null;
                if (aWhitelistEntry.contains(".") && aWhitelistEntry.contains("/")) {
                    try {
                        whitelistEntry = new SubnetWhitelistEntry(aWhitelistEntry);
                        break block12;
                    }
                    catch (Exception e) {
                        this.logger.error("activate: wrongly formatted CIDR subnet definition. Expected eg '1.2.3.4/24'. ignoring: " + aWhitelistEntry);
                        continue;
                    }
                }
                if (aWhitelistEntry.contains(".") && aWhitelistEntry.contains(" ")) {
                    try {
                        StringTokenizer st = new StringTokenizer(aWhitelistEntry, " ");
                        String ip = st.nextToken();
                        if (!st.hasMoreTokens()) break block12;
                        String mask = st.nextToken();
                        if (st.hasMoreTokens()) {
                            this.logger.error("activate: wrongly formatted ip subnet definition. Expected '10.1.2.3 255.0.0.0'. Ignoring: " + aWhitelistEntry);
                            continue;
                        }
                        whitelistEntry = new SubnetWhitelistEntry(ip, mask);
                    }
                    catch (Exception e) {
                        this.logger.error("activate: wrongly formatted ip subnet definition. Expected '10.1.2.3 255.0.0.0'. Ignoring: " + aWhitelistEntry);
                        continue;
                    }
                }
            }
            if (whitelistEntry == null) {
                if (aWhitelistEntry.contains("*") || aWhitelistEntry.contains("?")) {
                    whitelistEntry = new WildcardWhitelistEntry(aWhitelistEntry);
                } else {
                    this.plaintextWhitelist.add(aWhitelistEntry);
                }
            }
            this.logger.info("activate: adding whitelist entry: " + aWhitelistEntry);
            if (whitelistEntry == null) continue;
            this.whitelist.add(whitelistEntry);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String extension;
        if (!this.isWhitelisted(request)) {
            response.sendError(404);
            return;
        }
        String[] pathInfo = request.getPathInfo().split("\\.");
        String string = extension = pathInfo.length == 3 ? pathInfo[2] : "";
        if (!"json".equals(extension)) {
            response.sendError(404);
            return;
        }
        String selector = pathInfo.length == 3 ? pathInfo[1] : "";
        this.announcementRegistry.unregisterAnnouncement(selector);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String extension;
        if (!this.isWhitelisted(request)) {
            response.sendError(404);
            return;
        }
        String[] pathInfo = request.getPathInfo().split("\\.");
        String string = extension = pathInfo.length == 3 ? pathInfo[2] : "";
        if (!"json".equals(extension)) {
            response.sendError(404);
            return;
        }
        String selector = pathInfo.length == 3 ? pathInfo[1] : "";
        String topologyAnnouncementJSON = this.requestValidator.decodeMessage(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("doPost: incoming topology announcement is: " + topologyAnnouncementJSON);
        }
        try {
            final Announcement incomingTopologyAnnouncement = Announcement.fromJSON(topologyAnnouncementJSON);
            if (!incomingTopologyAnnouncement.getOwnerId().equals(selector)) {
                response.sendError(400);
                return;
            }
            String slingId = this.clusterViewService.getSlingId();
            if (slingId == null) {
                response.sendError(500);
                this.logger.info("doPut: no slingId available. Service not ready as expected at the moment.");
                return;
            }
            incomingTopologyAnnouncement.removeInherited(slingId);
            Announcement replyAnnouncement = new Announcement(slingId);
            long backoffInterval = -1L;
            LocalClusterView clusterView = this.clusterViewService.getLocalClusterView();
            if (!incomingTopologyAnnouncement.isCorrectVersion()) {
                this.logger.warn("doPost: rejecting an announcement from an incompatible connector protocol version: " + incomingTopologyAnnouncement);
                response.sendError(400);
                return;
            }
            if (ClusterViewHelper.contains((ClusterView)clusterView, incomingTopologyAnnouncement.getOwnerId())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("doPost: rejecting an announcement from an instance that is part of my cluster: " + incomingTopologyAnnouncement);
                }
                replyAnnouncement.setLoop(true);
                backoffInterval = this.config.getBackoffStandbyInterval();
            } else if (ClusterViewHelper.containsAny((ClusterView)clusterView, incomingTopologyAnnouncement.listInstances())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("doPost: rejecting an announcement as it contains instance(s) that is/are part of my cluster: " + incomingTopologyAnnouncement);
                }
                replyAnnouncement.setLoop(true);
                backoffInterval = this.config.getBackoffStandbyInterval();
            } else {
                backoffInterval = this.announcementRegistry.registerAnnouncement(incomingTopologyAnnouncement);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("doPost: backoffInterval after registration: " + backoffInterval);
                }
                if (backoffInterval == -1L) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("doPost: rejecting an announcement from an instance that I already see in my topology: " + incomingTopologyAnnouncement);
                    }
                    replyAnnouncement.setLoop(true);
                    backoffInterval = this.config.getBackoffStandbyInterval();
                } else {
                    replyAnnouncement.setLocalCluster((ClusterView)clusterView);
                    this.announcementRegistry.addAllExcept(replyAnnouncement, (ClusterView)clusterView, new AnnouncementFilter(){

                        @Override
                        public boolean accept(String receivingSlingId, Announcement announcement) {
                            return !announcement.getPrimaryKey().equals(incomingTopologyAnnouncement.getPrimaryKey());
                        }
                    });
                }
            }
            if (backoffInterval > 0L) {
                replyAnnouncement.setBackoffInterval(backoffInterval);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("doPost: backoffInterval for client set to " + replyAnnouncement.getBackoffInterval());
                }
            }
            String p = this.requestValidator.encodeMessage(replyAnnouncement.asJSON());
            this.requestValidator.trustMessage(response, request, p);
            String acceptEncodingHeader = request.getHeader("Accept-Encoding");
            if (acceptEncodingHeader != null && acceptEncodingHeader.contains("gzip")) {
                response.setHeader("Content-Encoding", "gzip");
                GZIPOutputStream gzipOut = new GZIPOutputStream((OutputStream)response.getOutputStream());
                gzipOut.write(p.getBytes("UTF-8"));
                gzipOut.close();
            } else {
                PrintWriter pw = response.getWriter();
                pw.print(p);
                pw.flush();
            }
        }
        catch (JsonException e) {
            this.logger.error("doPost: Got a JSONException: " + (Object)((Object)e), (Throwable)e);
            response.sendError(500);
        }
        catch (UndefinedClusterViewException e) {
            this.logger.warn("doPost: no clusterView available at the moment - cannot handle connectors now: " + e);
            response.sendError(503);
        }
    }

    boolean isWhitelisted(HttpServletRequest request) {
        if (this.config.isHmacEnabled()) {
            boolean isTrusted = this.requestValidator.isTrusted(request);
            if (!isTrusted) {
                this.logger.info("isWhitelisted: rejecting distrusted " + request.getRemoteAddr() + ", " + request.getRemoteHost());
            }
            return isTrusted;
        }
        if (this.plaintextWhitelist.contains(request.getRemoteHost()) || this.plaintextWhitelist.contains(request.getRemoteAddr())) {
            return true;
        }
        for (WhitelistEntry whitelistEntry : this.whitelist) {
            if (!whitelistEntry.accepts((ServletRequest)request)) continue;
            return true;
        }
        this.logger.info("isWhitelisted: rejecting " + request.getRemoteAddr() + ", " + request.getRemoteHost());
        return false;
    }

    protected void bindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        this.announcementRegistry = announcementRegistry;
    }

    protected void unbindAnnouncementRegistry(AnnouncementRegistry announcementRegistry) {
        if (this.announcementRegistry == announcementRegistry) {
            this.announcementRegistry = null;
        }
    }

    protected void bindClusterViewService(ClusterViewService clusterViewService) {
        this.clusterViewService = clusterViewService;
    }

    protected void unbindClusterViewService(ClusterViewService clusterViewService) {
        if (this.clusterViewService == clusterViewService) {
            this.clusterViewService = null;
        }
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unbindHttpService(HttpService httpService) {
        if (this.httpService == httpService) {
            this.httpService = null;
        }
    }

    protected void bindConfig(BaseConfig baseConfig) {
        this.config = baseConfig;
    }

    protected void unbindConfig(BaseConfig baseConfig) {
        if (this.config == baseConfig) {
            this.config = null;
        }
    }
}

