/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.announcement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.json.JsonException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.announcement.Announcement;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementFilter;
import org.apache.sling.discovery.base.connectors.announcement.AnnouncementRegistry;
import org.apache.sling.discovery.base.connectors.announcement.CachedAnnouncement;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={AnnouncementRegistry.class})
public class AnnouncementRegistryImpl
implements AnnouncementRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingSettingsService settingsService;
    private String slingId;
    @Reference
    private BaseConfig config;
    private final Map<String, CachedAnnouncement> ownAnnouncementsCache = new HashMap<String, CachedAnnouncement>();

    public static AnnouncementRegistryImpl testConstructorAndActivate(ResourceResolverFactory resourceResolverFactory, SlingSettingsService slingSettingsService, BaseConfig config) {
        AnnouncementRegistryImpl registry = AnnouncementRegistryImpl.testConstructor(resourceResolverFactory, slingSettingsService, config);
        registry.activate();
        return registry;
    }

    public static AnnouncementRegistryImpl testConstructor(ResourceResolverFactory resourceResolverFactory, SlingSettingsService slingSettingsService, BaseConfig config) {
        AnnouncementRegistryImpl registry = new AnnouncementRegistryImpl();
        registry.resourceResolverFactory = resourceResolverFactory;
        registry.settingsService = slingSettingsService;
        registry.config = config;
        return registry;
    }

    @Activate
    protected void activate() {
        this.slingId = this.settingsService.getSlingId();
    }

    @Override
    public synchronized void unregisterAnnouncement(String ownerId) {
        if (ownerId == null || ownerId.length() == 0) {
            throw new IllegalArgumentException("ownerId must not be null or empty");
        }
        this.ownAnnouncementsCache.remove(ownerId);
        if (this.resourceResolverFactory == null) {
            this.logger.error("unregisterAnnouncement: resourceResolverFactory is null");
            return;
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            String path = this.config.getClusterInstancesPath() + "/" + this.slingId + "/announcements/" + ownerId;
            Resource announcementsResource = resourceResolver.getResource(path);
            if (announcementsResource != null) {
                resourceResolver.delete(announcementsResource);
                resourceResolver.commit();
            }
        }
        catch (LoginException e) {
            this.logger.error("unregisterAnnouncement: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("unregisterAnnouncement: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public synchronized Collection<Announcement> listLocalAnnouncements() {
        return this.fillWithCachedAnnouncements(new LinkedList<Announcement>());
    }

    @Override
    public synchronized Collection<CachedAnnouncement> listLocalIncomingAnnouncements() {
        LinkedList<CachedAnnouncement> result = new LinkedList<CachedAnnouncement>(this.ownAnnouncementsCache.values());
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CachedAnnouncement cachedAnnouncement = (CachedAnnouncement)it.next();
            if (cachedAnnouncement.getAnnouncement().isInherited()) {
                it.remove();
                continue;
            }
            if (!cachedAnnouncement.hasExpired()) continue;
            it.remove();
        }
        return result;
    }

    private final InstanceDescription getLocalInstanceDescription(ClusterView localClusterView) {
        for (InstanceDescription id : localClusterView.getInstances()) {
            if (!id.isLocal()) continue;
            return id;
        }
        return null;
    }

    @Override
    public synchronized Collection<Announcement> listAnnouncementsInSameCluster(ClusterView localClusterView) {
        this.logger.debug("listAnnouncementsInSameCluster: start. localClusterView: {}", (Object)localClusterView);
        if (localClusterView == null) {
            throw new IllegalArgumentException("clusterView must not be null");
        }
        ResourceResolver resourceResolver = null;
        LinkedList<Announcement> incomingAnnouncements = new LinkedList<Announcement>();
        InstanceDescription localInstance = this.getLocalInstanceDescription(localClusterView);
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            Resource clusterInstancesResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.config.getClusterInstancesPath());
            for (Resource aClusterInstanceResource : clusterInstancesResource.getChildren()) {
                String instanceId = aClusterInstanceResource.getName();
                this.logger.debug("listAnnouncementsInSameCluster: handling clusterInstance: {}", (Object)instanceId);
                if (localInstance != null && localInstance.getSlingId().equals(instanceId)) {
                    this.logger.debug("listAnnouncementsInSameCluster: matched localInstance, filling with cache: {}", (Object)instanceId);
                    this.fillWithCachedAnnouncements(incomingAnnouncements);
                    continue;
                }
                if (!this.contains(localClusterView, instanceId)) {
                    this.logger.debug("listAnnouncementsInSameCluster: instance is not in my view, ignoring: {}", (Object)instanceId);
                    continue;
                }
                Resource announcementsResource = aClusterInstanceResource.getChild("announcements");
                if (announcementsResource == null) {
                    this.logger.debug("listAnnouncementsInSameCluster: instance has no announcements: {}", (Object)instanceId);
                    continue;
                }
                this.logger.debug("listAnnouncementsInSameCluster: instance has announcements: {}", (Object)instanceId);
                for (Resource anAnnouncement : announcementsResource.getChildren()) {
                    Announcement topologyAnnouncement = Announcement.fromJSON((String)((ValueMap)anAnnouncement.adaptTo(ValueMap.class)).get("topologyAnnouncement", String.class));
                    this.logger.debug("listAnnouncementsInSameCluster: found announcement: {}", (Object)topologyAnnouncement);
                    incomingAnnouncements.add(topologyAnnouncement);
                }
            }
        }
        catch (LoginException e) {
            this.logger.error("listAnnouncementsInSameCluster: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("listAnnouncementsInSameCluster: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JsonException e) {
            this.logger.error("listAnnouncementsInSameCluster: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("listAnnouncementsInSameCluster: result: " + incomingAnnouncements.size());
        }
        return incomingAnnouncements;
    }

    private final Collection<Announcement> fillWithCachedAnnouncements(Collection<Announcement> incomingAnnouncements) {
        for (Map.Entry<String, CachedAnnouncement> entry : this.ownAnnouncementsCache.entrySet()) {
            if (entry.getValue().hasExpired()) continue;
            incomingAnnouncements.add(entry.getValue().getAnnouncement());
        }
        return incomingAnnouncements;
    }

    private final boolean contains(ClusterView clusterView, String instanceId) {
        for (InstanceDescription instance : clusterView.getInstances()) {
            if (!instance.getSlingId().equals(instanceId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean hasActiveAnnouncement(String ownerId) {
        if (ownerId == null || ownerId.length() == 0) {
            throw new IllegalArgumentException("ownerId must not be null or empty: " + ownerId);
        }
        CachedAnnouncement cachedAnnouncement = this.ownAnnouncementsCache.get(ownerId);
        if (cachedAnnouncement == null) {
            return false;
        }
        return !cachedAnnouncement.hasExpired();
    }

    @Override
    public synchronized long registerAnnouncement(Announcement topologyAnnouncement) {
        if (topologyAnnouncement == null) {
            throw new IllegalArgumentException("topologyAnnouncement must not be null");
        }
        if (!topologyAnnouncement.isValid()) {
            this.logger.warn("topologyAnnouncement is not valid");
            return -1L;
        }
        if (this.resourceResolverFactory == null) {
            this.logger.error("registerAnnouncement: resourceResolverFactory is null");
            return -1L;
        }
        CachedAnnouncement cachedAnnouncement = this.ownAnnouncementsCache.get(topologyAnnouncement.getOwnerId());
        if (cachedAnnouncement != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("registerAnnouncement: got existing cached announcement for ownerId=" + topologyAnnouncement.getOwnerId());
            }
            try {
                if (topologyAnnouncement.correspondsTo(cachedAnnouncement.getAnnouncement())) {
                    this.logger.debug("registerAnnouncement: nothing has changed, only updating heartbeat in-memory.");
                    return cachedAnnouncement.registerPing(topologyAnnouncement, this.config);
                }
                this.logger.debug("registerAnnouncement: incoming announcement differs from existing one!");
            }
            catch (JsonException e) {
                this.logger.error("registerAnnouncement: got JSONException while converting incoming announcement to JSON: " + (Object)((Object)e), (Throwable)e);
            }
            this.ownAnnouncementsCache.remove(topologyAnnouncement.getOwnerId());
        } else {
            this.logger.debug("registerAnnouncement: no cached announcement yet for ownerId=" + topologyAnnouncement.getOwnerId());
        }
        this.logger.debug("registerAnnouncement: getting the list of all local announcements");
        LinkedList<Announcement> announcements = new LinkedList<Announcement>();
        this.fillWithCachedAnnouncements(announcements);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("registerAnnouncement: list returned: " + (announcements == null ? "null" : Integer.valueOf(announcements.size())));
        }
        for (Announcement announcement : announcements) {
            if (announcement.getOwnerId().equals(topologyAnnouncement.getOwnerId())) continue;
            Collection<InstanceDescription> attachedInstances = announcement.listInstances();
            for (InstanceDescription instanceDescription : attachedInstances) {
                if (!topologyAnnouncement.getOwnerId().equals(instanceDescription.getSlingId())) continue;
                this.logger.info("registerAnnouncement: already have this instance attached: " + instanceDescription.getSlingId());
                return -1L;
            }
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            Resource announcementsResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)(this.config.getClusterInstancesPath() + "/" + this.slingId + "/announcements"));
            topologyAnnouncement.persistTo(announcementsResource);
            resourceResolver.commit();
            this.ownAnnouncementsCache.put(topologyAnnouncement.getOwnerId(), new CachedAnnouncement(topologyAnnouncement, this.config));
        }
        catch (LoginException e) {
            this.logger.error("registerAnnouncement: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("registerAnnouncement: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JsonException e) {
            this.logger.error("registerAnnouncement: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        return 0L;
    }

    @Override
    public synchronized void addAllExcept(Announcement target, ClusterView clusterView, AnnouncementFilter filter) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            Resource clusterInstancesResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.config.getClusterInstancesPath());
            for (Resource aClusterInstanceResource : clusterInstancesResource.getChildren()) {
                Resource announcementsResource;
                String instanceId = aClusterInstanceResource.getName();
                if (!this.contains(clusterView, instanceId) || (announcementsResource = aClusterInstanceResource.getChild("announcements")) == null) continue;
                for (Resource anAnnouncement : announcementsResource.getChildren()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("addAllExcept: anAnnouncement=" + anAnnouncement);
                    }
                    Announcement topologyAnnouncement = Announcement.fromJSON((String)((ValueMap)anAnnouncement.adaptTo(ValueMap.class)).get("topologyAnnouncement", String.class));
                    if (filter != null && !filter.accept(aClusterInstanceResource.getName(), topologyAnnouncement)) continue;
                    target.addIncomingTopologyAnnouncement(topologyAnnouncement);
                }
            }
        }
        catch (LoginException e) {
            this.logger.error("handleEvent: could not log in administratively: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Could not log in to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (PersistenceException e) {
            this.logger.error("handleEvent: got a PersistenceException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while talking to repository (" + (Object)((Object)e) + ")", e);
        }
        catch (JsonException e) {
            this.logger.error("handleEvent: got a JSONException: " + (Object)((Object)e), (Throwable)e);
            throw new RuntimeException("Exception while converting json (" + (Object)((Object)e) + ")", e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void checkExpiredAnnouncements() {
        Iterator<Map.Entry<String, CachedAnnouncement>> it = this.ownAnnouncementsCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, CachedAnnouncement> entry = it.next();
            if (!entry.getValue().hasExpired()) continue;
            it.remove();
            String instanceId = entry.getKey();
            this.logger.info("checkExpiredAnnouncements: topology connector of " + instanceId + " (to me=" + this.slingId + ", inherited=" + entry.getValue().getAnnouncement().isInherited() + ") has expired.");
            this.deleteAnnouncementsOf(instanceId);
        }
        ResourceResolver resourceResolver = null;
        boolean requiresCommit = false;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            Resource announcementsResource = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)(this.config.getClusterInstancesPath() + "/" + this.slingId + "/announcements"));
            for (Resource res : announcementsResource.getChildren()) {
                String ownerId = res.getName();
                if (this.ownAnnouncementsCache.containsKey(ownerId)) continue;
                ResourceHelper.deleteResource((ResourceResolver)resourceResolver, (String)res.getPath());
                requiresCommit = true;
            }
            if (requiresCommit) {
                resourceResolver.commit();
            }
            resourceResolver.close();
            resourceResolver = null;
        }
        catch (LoginException e) {
            this.logger.error("checkExpiredAnnouncements: could not log in administratively when checking for expired announcements of slingId=" + this.slingId + ": " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("checkExpiredAnnouncements: got PersistenceException when checking for expired announcements of slingId=" + this.slingId + ": " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.revert();
                resourceResolver.close();
                resourceResolver = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteAnnouncementsOf(String instanceId) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            ResourceHelper.deleteResource((ResourceResolver)resourceResolver, (String)(this.config.getClusterInstancesPath() + "/" + this.slingId + "/announcements/" + instanceId));
            resourceResolver.commit();
            resourceResolver.close();
            resourceResolver = null;
        }
        catch (LoginException e) {
            this.logger.error("deleteAnnouncementsOf: could not log in administratively when deleting announcements of instanceId=" + instanceId + ": " + (Object)((Object)e), (Throwable)e);
        }
        catch (PersistenceException e) {
            this.logger.error("deleteAnnouncementsOf: got PersistenceException when deleting announcements of instanceId=" + instanceId + ": " + (Object)((Object)e), (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.revert();
                resourceResolver.close();
                resourceResolver = null;
            }
        }
    }

    @Override
    public synchronized Collection<InstanceDescription> listInstances(ClusterView localClusterView) {
        this.logger.debug("listInstances: start. localClusterView: {}", (Object)localClusterView);
        LinkedList<InstanceDescription> instances = new LinkedList<InstanceDescription>();
        Collection<Announcement> announcements = this.listAnnouncementsInSameCluster(localClusterView);
        if (announcements == null) {
            this.logger.debug("listInstances: no announcement found. end. instances: {}", instances);
            return instances;
        }
        for (Announcement announcement : announcements) {
            this.logger.debug("listInstances: adding announcement: {}", (Object)announcement);
            instances.addAll(announcement.listInstances());
        }
        this.logger.debug("listInstances: announcements added. end. instances: {}", instances);
        return instances;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindConfig(BaseConfig baseConfig) {
        this.config = baseConfig;
    }

    protected void unbindConfig(BaseConfig baseConfig) {
        if (this.config == baseConfig) {
            this.config = null;
        }
    }
}

