/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.ping;

import javax.servlet.http.HttpServletRequest;
import junitx.util.PrivateAccessor;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.ping.TopologyConnectorServlet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TopologyConnectorServletTest {
    private TopologyConnectorServlet servlet;

    private HttpServletRequest getRequest(String host, String addr) {
        HttpServletRequest result = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)result.getRemoteAddr()).thenReturn((Object)addr);
        Mockito.when((Object)result.getRemoteHost()).thenReturn((Object)host);
        return result;
    }

    @Before
    public void setUp() throws Exception {
        this.servlet = new TopologyConnectorServlet();
        BaseConfig config = (BaseConfig)Mockito.mock(BaseConfig.class);
        PrivateAccessor.setField((Object)this.servlet, (String)"config", (Object)config);
    }

    @Test
    public void testNull() throws Exception {
        this.servlet.initWhitelist(null);
        this.servlet.initWhitelist(new String[0]);
    }

    @Test
    public void testPlaintextWhitelist_enabled() throws Exception {
        this.servlet.initWhitelist(new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "x")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("bar", "x")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("y", "foo")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("y", "bar")));
    }

    @Test
    public void testPlaintextWhitelist_disabled() throws Exception {
        this.servlet.initWhitelist(new String[0]);
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "x")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("bar", "x")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("y", "foo")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("y", "bar")));
    }

    @Test
    public void testWildcardWhitelist() throws Exception {
        this.servlet.initWhitelist(new String[]{"foo*", "b?r", "test"});
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "x")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("fooo", "x")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("foooo", "x")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("x", "foo")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("x", "fooo")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("x", "foooo")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("bur", "x")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("x", "bur")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("x", "test")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("fo", "x")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("x", "testy")));
    }

    @Test
    public void testSubnetMaskWhitelist() throws Exception {
        this.servlet.initWhitelist(new String[]{"1.2.3.4/24", "2.3.4.1/30", "3.4.5.6/31"});
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "1.2.3.4")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("1.2.3.4", "1.2.4.3")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "1.2.3.1")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "1.2.3.254")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "1.2.4.5")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "2.3.4.1")));
        Assert.assertTrue((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "2.3.4.2")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "2.3.4.3")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "2.3.4.4")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "3.4.5.1")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "3.4.5.2")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "3.4.5.3")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "3.4.5.4")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "3.4.5.5")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "3.4.5.6")));
        Assert.assertFalse((boolean)this.servlet.isWhitelisted(this.getRequest("foo", "3.4.5.7")));
    }
}

