/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.util.concurrent.ThreadPoolExecutor;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.sling.commons.threads.impl.DefaultThreadPoolManager;
import org.apache.sling.commons.threads.jmx.ThreadPoolMBean;

class ThreadPoolMBeanImpl
extends StandardMBean
implements ThreadPoolMBean {
    private final DefaultThreadPoolManager.Entry entry;

    ThreadPoolMBeanImpl(DefaultThreadPoolManager.Entry entry) throws NotCompliantMBeanException {
        super(ThreadPoolMBean.class);
        this.entry = entry;
    }

    @Override
    public String getBlockPolicy() {
        return this.entry.getConfig().getBlockPolicy().name();
    }

    @Override
    public int getExecutorActiveCount() {
        ThreadPoolExecutor tpe = this.entry.getExecutor();
        if (tpe != null) {
            return tpe.getActiveCount();
        }
        return -1;
    }

    @Override
    public long getExecutorCompletedTaskCount() {
        ThreadPoolExecutor tpe = this.entry.getExecutor();
        if (tpe != null) {
            return tpe.getCompletedTaskCount();
        }
        return -1L;
    }

    @Override
    public int getExecutorCorePoolSize() {
        ThreadPoolExecutor tpe = this.entry.getExecutor();
        if (tpe != null) {
            return tpe.getCorePoolSize();
        }
        return -1;
    }

    @Override
    public int getExecutorLargestPoolSize() {
        ThreadPoolExecutor tpe = this.entry.getExecutor();
        if (tpe != null) {
            return tpe.getLargestPoolSize();
        }
        return -1;
    }

    @Override
    public int getExecutorMaximumPoolSize() {
        ThreadPoolExecutor tpe = this.entry.getExecutor();
        if (tpe != null) {
            return tpe.getMaximumPoolSize();
        }
        return -1;
    }

    @Override
    public int getExecutorPoolSize() {
        ThreadPoolExecutor tpe = this.entry.getExecutor();
        if (tpe != null) {
            return tpe.getPoolSize();
        }
        return -1;
    }

    @Override
    public long getExecutorTaskCount() {
        ThreadPoolExecutor tpe = this.entry.getExecutor();
        if (tpe != null) {
            return tpe.getTaskCount();
        }
        return -1L;
    }

    @Override
    @Deprecated
    public long getMaxThreadAge() {
        return this.entry.getConfig().getMaxThreadAge();
    }

    @Override
    public long getKeepAliveTime() {
        return this.entry.getConfig().getKeepAliveTime();
    }

    @Override
    public int getMaxPoolSize() {
        return this.entry.getConfig().getMaxPoolSize();
    }

    @Override
    public int getMinPoolSize() {
        return this.entry.getConfig().getMinPoolSize();
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public String getPid() {
        return this.entry.getPid();
    }

    @Override
    public String getPriority() {
        return this.entry.getConfig().getPriority().name();
    }

    @Override
    public int getQueueSize() {
        return this.entry.getConfig().getQueueSize();
    }

    @Override
    public int getShutdownWaitTimeMs() {
        return this.entry.getConfig().getShutdownWaitTimeMs();
    }

    @Override
    public boolean isDaemon() {
        return this.entry.getConfig().isDaemon();
    }

    @Override
    public boolean isShutdownGraceful() {
        return this.entry.getConfig().isShutdownGraceful();
    }

    @Override
    public boolean isUsed() {
        return this.entry.isUsed();
    }
}

