/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.integration;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.sling.commons.testing.integration.HttpAnyMethod;
import org.apache.sling.commons.testing.integration.HttpStatusCodeException;
import org.apache.sling.commons.testing.integration.HttpTestNode;
import org.apache.sling.commons.testing.integration.SlingIntegrationTestClient;
import org.apache.sling.commons.testing.integration.TestInfoPassingClient;
import org.apache.sling.commons.testing.util.JavascriptEngine;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class HttpTestBase
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PROPERTY_SKIP_STARTUP_CHECK = "launchpad.skip.startupcheck";
    public static final String HTTP_URL = HttpTestBase.removeEndingSlash(System.getProperty("launchpad.http.server.url", "http://localhost:8080"));
    public static final String HTTP_BASE_URL = HttpTestBase.removePath(HTTP_URL);
    public static final String WEBDAV_BASE_URL = HttpTestBase.removeEndingSlash(System.getProperty("launchpad.webdav.server.url", HTTP_BASE_URL));
    public static final String SERVLET_CONTEXT = HttpTestBase.removeEndingSlash(System.getProperty("launchpad.servlet.context", HttpTestBase.getPath(HTTP_URL)));
    public static final String READINESS_MEDIA_TYPE_PROP = "launchpad.readiness.mediatype";
    public static final String DEFAULT_READINESS_MEDIA_TYPE = ".txt:text/plain";
    public static final String READY_URL_PROP_PREFIX = "launchpad.ready.";
    public static final int MAX_READY_URL_INDEX = 50;
    public static final String TEST_PATH = "/launchpad-integration-tests";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String CONTENT_TYPE_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_JS = "application/javascript";
    public static final String CONTENT_TYPE_CSS = "text/css";
    public static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    public static final String SLING_POST_SERVLET_CREATE_SUFFIX = "/";
    public static final String DEFAULT_EXT = ".txt";
    private String readinessCheckExtension;
    private String readinessCheckContentTypePrefix;
    public static final String EXECUTE_RESOURCE_TYPE = "SlingTesting" + HttpTestBase.class.getSimpleName();
    private static int executeCounter;
    public static final int READY_TIMEOUT_SECONDS;
    protected SlingIntegrationTestClient testClient;
    protected HttpClient httpClient;
    private static Boolean slingStartupOk;
    public static final String CONTENT_TYPE_DONTCARE = "*";
    private static final Object startupCheckLock;
    protected final List<String> urlsToDelete = new LinkedList<String>();
    private final JavascriptEngine javascriptEngine = new JavascriptEngine();

    public HttpTestBase() {
        super("");
        String rmt = System.getProperty(READINESS_MEDIA_TYPE_PROP, DEFAULT_READINESS_MEDIA_TYPE);
        String[] s = rmt.split(":");
        if (s.length != 2) {
            throw new IllegalStateException("Invalid launchpad.readiness.mediatype: " + rmt);
        }
        this.setReadinessContentType(s[0].trim(), s[1].trim());
    }

    public static String removeEndingSlash(String str) {
        if (str != null && str.endsWith(SLING_POST_SERVLET_CREATE_SUFFIX)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static String removePath(String str) {
        int pos = str.indexOf(":/");
        int slashPos = str.indexOf(47, pos + 3);
        if (slashPos != -1) {
            return str.substring(0, slashPos);
        }
        return str;
    }

    private static String getPath(String str) {
        int pos = str.indexOf(":/");
        int slashPos = str.indexOf(47, pos + 3);
        if (slashPos != -1) {
            return str.substring(slashPos);
        }
        return "";
    }

    protected void setUp() throws Exception {
        super.setUp();
        MDC.put((String)"testclass", (String)((Object)((Object)this)).getClass().getName());
        MDC.put((String)"testcase", (String)this.getName());
        URL url = null;
        try {
            url = new URL(HTTP_BASE_URL);
        }
        catch (MalformedURLException mfe) {
            throw new IOException("MalformedURLException: " + HTTP_BASE_URL);
        }
        this.httpClient = new TestInfoPassingClient();
        this.httpClient.getParams().setAuthenticationPreemptive(true);
        Credentials defaultcreds = this.getDefaultCredentials();
        this.httpClient.getState().setCredentials(new AuthScope(url.getHost(), url.getPort(), AuthScope.ANY_REALM), defaultcreds);
        this.testClient = new SlingIntegrationTestClient(this.httpClient);
        this.testClient.setFolderExistsTestExtension(this.readinessCheckExtension);
        this.waitForSlingStartup();
    }

    public Credentials getDefaultCredentials() {
        return new UsernamePasswordCredentials("admin", "admin");
    }

    protected void tearDown() throws Exception {
        MDC.remove((String)"testcase");
        MDC.remove((String)"testclass");
        super.tearDown();
        for (String url : this.urlsToDelete) {
            this.testClient.delete(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForSlingStartup() throws Exception {
        Object object = startupCheckLock;
        synchronized (object) {
            if (slingStartupOk != null) {
                if (slingStartupOk.booleanValue()) {
                    return;
                }
                HttpTestBase.fail((String)"Sling services not available. Already checked in earlier tests.");
            }
            if (System.getProperty(PROPERTY_SKIP_STARTUP_CHECK) != null) {
                slingStartupOk = true;
                return;
            }
            slingStartupOk = false;
        }
        System.err.println("Checking if the required Sling services are started (timeout " + READY_TIMEOUT_SECONDS + " seconds)...");
        System.err.println("(base URLs=" + HTTP_BASE_URL + " and " + WEBDAV_BASE_URL + "; servlet context=" + SERVLET_CONTEXT + "; readiness type=" + this.readinessCheckExtension + " : " + this.readinessCheckContentTypePrefix);
        LinkedList<String> exceptionMessages = new LinkedList<String>();
        long maxMsecToWait = (long)READY_TIMEOUT_SECONDS * 1000L;
        long startupTime = System.currentTimeMillis();
        String lastException = "";
        int nTimesOk = 0;
        int MIN_TIMES_OK = 4;
        while (!slingStartupOk.booleanValue() && System.currentTimeMillis() < startupTime + maxMsecToWait) {
            try {
                if (this.slingServerReady()) {
                    if (++nTimesOk >= 4) {
                        slingStartupOk = true;
                        break;
                    }
                } else {
                    nTimesOk = 0;
                }
            }
            catch (Exception e) {
                nTimesOk = 0;
                String newX = e.toString();
                if (!lastException.equals(newX)) {
                    exceptionMessages.add(newX);
                }
                lastException = newX;
            }
            Thread.sleep(500L);
        }
        if (slingStartupOk.booleanValue()) {
            this.log.info("Sling server found ready after {} msec", (Object)(System.currentTimeMillis() - startupTime));
        } else {
            StringBuffer msg = new StringBuffer("Server does not seem to be ready, after ");
            msg.append(maxMsecToWait).append(" msec, got the following ").append(exceptionMessages.size()).append(" Exceptions:");
            for (String e : exceptionMessages) {
                msg.append(e).append("\n");
            }
            System.err.println(msg);
            HttpTestBase.fail((String)msg.toString());
        }
        System.err.println("Sling services seem to be started, continuing with integration tests.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean slingServerReady() throws Exception {
        String time = String.valueOf(System.currentTimeMillis());
        String url = HTTP_BASE_URL + "/WaitForSlingStartup/" + time;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("time", time);
        String urlOfNewNode = null;
        try {
            String contentType;
            urlOfNewNode = this.testClient.createNode(url, props, null, true);
            GetMethod get = new GetMethod(urlOfNewNode + this.readinessCheckExtension);
            int status = this.httpClient.executeMethod((HttpMethod)get);
            if (status != 200) {
                throw new HttpStatusCodeException(200, status, HTTP_METHOD_GET, urlOfNewNode);
            }
            Header h = get.getResponseHeader("Content-Type");
            String string = contentType = h == null ? "" : h.getValue();
            if (!contentType.startsWith(this.readinessCheckContentTypePrefix)) {
                throw new IOException("Expected Content-Type=" + this.readinessCheckContentTypePrefix + " but got '" + contentType + "' for URL=" + urlOfNewNode);
            }
            String content = get.getResponseBodyAsString();
            if (!content.contains(time)) {
                throw new IOException("Content does not contain '" + time + "' (" + content + ") at URL=" + urlOfNewNode);
            }
        }
        finally {
            if (urlOfNewNode != null) {
                try {
                    this.testClient.delete(urlOfNewNode);
                }
                catch (Exception get) {}
            }
        }
        String webDavUrl = WEBDAV_BASE_URL + SLING_POST_SERVLET_CREATE_SUFFIX;
        HttpAnyMethod options = new HttpAnyMethod("OPTIONS", webDavUrl);
        int status = this.httpClient.executeMethod((HttpMethod)options);
        if (status != 200) {
            throw new HttpStatusCodeException(200, status, "OPTIONS", webDavUrl);
        }
        Header h = options.getResponseHeader("Allow");
        if (h == null) {
            throw new IOException("Response does not contain Allow header, at URL=" + webDavUrl);
        }
        if (h.getValue() == null) {
            throw new IOException("Allow header has null value at URL=" + webDavUrl);
        }
        if (!h.getValue().contains("PROPFIND")) {
            throw new IOException("Allow header (" + h.getValue() + " does not contain PROPFIND, at URL=" + webDavUrl);
        }
        for (int i = 0; i <= 50; ++i) {
            int status2;
            String propName = READY_URL_PROP_PREFIX + i;
            String readyDef = System.getProperty(propName, "");
            String[] parts = readyDef.split(":");
            if (parts.length != 4) continue;
            String info = propName + "=" + readyDef;
            HttpAnyMethod m = new HttpAnyMethod(parts[0], HTTP_BASE_URL + parts[1]);
            int expectedStatus = Integer.valueOf(parts[2]);
            if (expectedStatus != (status2 = this.httpClient.executeMethod((HttpMethod)m))) {
                throw new IOException("Status " + status2 + " does not match expected value: " + info);
            }
            String content = m.getResponseBodyAsString();
            Pattern p = Pattern.compile("(?s).*" + parts[3] + ".*");
            if (p.matcher(content).matches()) continue;
            throw new IOException("Content does not match expected regexp:" + info + ", content=" + content);
        }
        return true;
    }

    public HttpMethod assertHttpStatus(String urlString, int expectedStatusCode, String assertMessage) throws IOException {
        GetMethod get = new GetMethod(urlString);
        int status = this.httpClient.executeMethod((HttpMethod)get);
        if (assertMessage == null) {
            HttpTestBase.assertEquals((String)urlString, (int)expectedStatusCode, (int)status);
        } else {
            HttpTestBase.assertEquals((String)assertMessage, (int)expectedStatusCode, (int)status);
        }
        return get;
    }

    public HttpMethod assertHttpStatus(String urlString, int expectedStatusCode) throws IOException {
        return this.assertHttpStatus(urlString, expectedStatusCode, null);
    }

    public HttpMethod assertPostStatus(String url, int expectedStatusCode, List<NameValuePair> postParams, String assertMessage) throws IOException {
        PostMethod post = new PostMethod(url);
        post.setFollowRedirects(false);
        if (postParams != null) {
            NameValuePair[] nvp = new NameValuePair[]{};
            post.setRequestBody(postParams.toArray(nvp));
        }
        int status = this.httpClient.executeMethod((HttpMethod)post);
        if (assertMessage == null) {
            HttpTestBase.assertEquals((int)expectedStatusCode, (int)status);
        } else {
            HttpTestBase.assertEquals((String)assertMessage, (int)expectedStatusCode, (int)status);
        }
        return post;
    }

    public String getContent(String url, String expectedContentType) throws IOException {
        return this.getContent(url, expectedContentType, null);
    }

    public String getContent(String url, String expectedContentType, List<NameValuePair> params) throws IOException {
        return this.getContent(url, expectedContentType, params, 200);
    }

    public String getContent(String url, String expectedContentType, List<NameValuePair> params, int expectedStatusCode) throws IOException {
        return this.getContent(url, expectedContentType, params, expectedStatusCode, HTTP_METHOD_GET);
    }

    public String getContent(String url, String expectedContentType, List<NameValuePair> params, int expectedStatusCode, String httpMethod) throws IOException {
        GetMethod method = null;
        if (HTTP_METHOD_GET.equals(httpMethod)) {
            method = new GetMethod(url);
        } else if (HTTP_METHOD_POST.equals(httpMethod)) {
            method = new PostMethod(url);
        } else {
            HttpTestBase.fail((String)("Http Method not supported in this test suite, method: " + httpMethod));
        }
        if (params != null) {
            NameValuePair[] nvp = new NameValuePair[]{};
            method.setQueryString(params.toArray(nvp));
        }
        int status = this.httpClient.executeMethod((HttpMethod)method);
        String content = HttpTestBase.getResponseBodyAsStream((HttpMethodBase)method, 0);
        HttpTestBase.assertEquals((String)("Expected status " + expectedStatusCode + " for " + url + " (content=" + content + ")"), (int)expectedStatusCode, (int)status);
        Header h = method.getResponseHeader("Content-Type");
        if (expectedContentType == null) {
            if (h != null) {
                HttpTestBase.fail((String)("Expected null Content-Type, got " + h.getValue()));
            }
        } else if (!CONTENT_TYPE_DONTCARE.equals(expectedContentType)) {
            if (h == null) {
                HttpTestBase.fail((String)("Expected Content-Type that starts with '" + expectedContentType + " but got no Content-Type header at " + url));
            } else {
                HttpTestBase.assertTrue((String)("Expected Content-Type that starts with '" + expectedContentType + "' for " + url + ", got '" + h.getValue() + "'"), (boolean)h.getValue().startsWith(expectedContentType));
            }
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadTestScript(String scriptPath, String localFilename, String filenameOnServer) throws IOException {
        String url = WEBDAV_BASE_URL + scriptPath + SLING_POST_SERVLET_CREATE_SUFFIX + filenameOnServer;
        String testFile = "/integration-test/" + localFilename;
        InputStream data = ((Object)((Object)this)).getClass().getResourceAsStream(testFile);
        if (data == null) {
            HttpTestBase.fail((String)("Test file not found:" + testFile));
        }
        try {
            this.testClient.upload(url, data);
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
        return url;
    }

    public String executeScript(String localFilename) throws Exception {
        return this.executeScript(localFilename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeScript(String localFilename, List<NameValuePair> params) throws Exception {
        int counter = 0;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            counter = ++executeCounter;
        }
        String resourceType = EXECUTE_RESOURCE_TYPE + counter;
        String scriptPath = "/apps/" + resourceType;
        this.testClient.mkdirs(WEBDAV_BASE_URL, scriptPath);
        int pos = localFilename.lastIndexOf(".");
        if (pos < 1) {
            throw new IllegalArgumentException("localFilename must have extension (" + localFilename + ")");
        }
        String ext = localFilename.substring(pos + 1);
        LinkedList<String> toDelete = new LinkedList<String>();
        try {
            toDelete.add(this.uploadTestScript(scriptPath, localFilename, "txt." + ext));
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(SLING_RESOURCE_TYPE, resourceType);
            String nodePath = scriptPath + "/node" + counter;
            String nodeUrl = this.testClient.createNode(HTTP_BASE_URL + nodePath, props);
            toDelete.add(nodeUrl);
            String string = this.getContent(nodeUrl + DEFAULT_EXT, CONTENT_TYPE_DONTCARE, params);
            return string;
        }
        finally {
            for (String url : toDelete) {
                this.testClient.delete(url);
            }
        }
    }

    public void assertJavascript(String expectedOutput, String jsonData, String code) throws IOException {
        this.assertJavascript(expectedOutput, jsonData, code, null);
    }

    public void assertJavascript(String expectedOutput, String jsonData, String code, String testInfo) throws IOException {
        String result = this.javascriptEngine.execute(code, jsonData);
        if (!result.equals(expectedOutput)) {
            HttpTestBase.fail((String)("Expected '" + expectedOutput + "' but got '" + result + "' for script='" + code + "'' and data='" + jsonData + "'" + (testInfo == null ? "" : ", test info=" + testInfo)));
        }
    }

    public static String getResponseBodyAsStream(HttpMethodBase m, int maxLength) throws IOException {
        InputStream is = m.getResponseBodyAsStream();
        StringBuilder content = new StringBuilder();
        String charset = m.getResponseCharSet();
        byte[] buffer = new byte[16384];
        int n = 0;
        while ((n = is.read(buffer, 0, buffer.length)) > 0) {
            content.append(new String(buffer, 0, n, charset));
            if (maxLength == 0 || content.length() <= maxLength) continue;
            throw new IllegalArgumentException("Response body size is over maxLength (" + maxLength + ")");
        }
        return content.toString();
    }

    public final void setReadinessContentType(String extension, String contentTypePrefix) {
        this.readinessCheckExtension = extension;
        this.readinessCheckContentTypePrefix = contentTypePrefix;
    }

    public boolean isBundleVersionAtLeast(String bundleSymbolicName, String version) throws IOException {
        GetMethod method = new GetMethod(HTTP_BASE_URL + "/system/console/bundles/" + bundleSymbolicName + ".json");
        int result = this.httpClient.executeMethod((HttpMethod)method);
        if (result != 200) {
            return false;
        }
        try (JsonReader jsonReader = Json.createReader((InputStream)method.getResponseBodyAsStream());){
            JsonObject bundleInfo = jsonReader.readObject();
            String bundleVersion = bundleInfo.getJsonArray("data").getJsonObject(0).getString("version");
            Version bundleVer = new Version(bundleVersion);
            if (bundleVer.compareTo(new Version(version)) < 0) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    static {
        READY_TIMEOUT_SECONDS = Integer.getInteger("HttpTestBase.readyTimeoutSeconds", 60);
        startupCheckLock = new Object();
    }

    protected class TestNode
    extends HttpTestNode {
        public TestNode(String parentPath, Map<String, String> properties) throws IOException {
            super(HttpTestBase.this.testClient, parentPath, properties);
        }
    }
}

