/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.rrd4j.impl;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RRD4JReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RRD4JReporter.class);
    private static final String PROPERTIES_SUFFIX = ".properties";
    static final int DEFAULT_STEP = 5;
    static final String DEFAULT_PATH = "metrics/metrics.rrd";
    private final Map<String, Integer> dictionary = new HashMap<String, Integer>();
    private final RrdDb rrdDB;
    private final Clock clock;
    private long lastSampleTime;

    static Builder forRegistry(MetricRegistry metricRegistry) {
        return new Builder(metricRegistry);
    }

    RRD4JReporter(MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Map<String, Integer> dictionary, RrdDef rrdDef, Clock clock) throws IOException {
        super(registry, name, filter, rateUnit, durationUnit);
        this.dictionary.putAll(dictionary);
        this.rrdDB = RRD4JReporter.createDB(rrdDef);
        this.clock = clock;
        this.storeDictionary(rrdDef.getPath() + PROPERTIES_SUFFIX);
        this.writeUnknownSample();
    }

    public void close() {
        super.close();
        try {
            if (!this.rrdDB.isClosed()) {
                this.writeUnknownSample();
            }
            this.rrdDB.close();
        }
        catch (IOException e) {
            LOGGER.warn("Closing RRD failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long sampleTime = this.clock.getTime() / 1000L;
        if (sampleTime <= this.lastSampleTime) {
            return;
        }
        long time = System.nanoTime();
        int total = gauges.size() + counters.size() + histograms.size() + meters.size() + timers.size();
        int reported = 0;
        try {
            Sample sample = this.rrdDB.createSample(sampleTime);
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                reported += this.update(sample, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                reported += this.update(sample, entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                reported += this.update(sample, entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                reported += this.update(sample, entry.getKey(), (Meter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                reported += this.update(sample, entry.getKey(), (Timer)entry.getValue());
            }
            sample.update();
            this.lastSampleTime = sampleTime;
        }
        catch (IOException e) {
            try {
                LOGGER.warn("Unable to write sample to RRD", (Throwable)e);
                this.lastSampleTime = sampleTime;
            }
            catch (Throwable throwable) {
                this.lastSampleTime = sampleTime;
                time = System.nanoTime() - time;
                LOGGER.debug("{} out of {} metrics reported in {} \u03bcs", new Object[]{reported, total, TimeUnit.NANOSECONDS.toMicros(time)});
                throw throwable;
            }
            time = System.nanoTime() - time;
            LOGGER.debug("{} out of {} metrics reported in {} \u03bcs", new Object[]{reported, total, TimeUnit.NANOSECONDS.toMicros(time)});
        }
        time = System.nanoTime() - time;
        LOGGER.debug("{} out of {} metrics reported in {} \u03bcs", new Object[]{reported, total, TimeUnit.NANOSECONDS.toMicros(time)});
    }

    private int indexForName(String name) {
        Integer idx = this.dictionary.get(RRD4JReporter.normalize(name));
        return idx != null ? idx : -1;
    }

    private static String normalize(String name) {
        return name.replaceAll(":", "_");
    }

    private static void log(String key, String type, Number value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sample: {} ({}) = {}", new Object[]{key, type, value});
        }
    }

    private int update(Sample sample, String key, Gauge g) {
        int nameIdx = this.indexForName(key);
        if (nameIdx < 0) {
            return 0;
        }
        Object value = g.getValue();
        if (value instanceof Number) {
            double val = ((Number)value).doubleValue();
            sample.setValue(nameIdx, val);
            RRD4JReporter.log(key, "gauge", val);
            return 1;
        }
        return 0;
    }

    private int update(Sample sample, String key, Counter c) {
        int nameIdx = this.indexForName(key);
        if (nameIdx < 0) {
            return 0;
        }
        long val = c.getCount();
        sample.setValue(nameIdx, (double)val);
        RRD4JReporter.log(key, "counter", val);
        return 1;
    }

    private int update(Sample sample, String key, Histogram h) {
        int nameIdx = this.indexForName(key);
        if (nameIdx < 0) {
            return 0;
        }
        long val = h.getCount();
        sample.setValue(nameIdx, (double)val);
        RRD4JReporter.log(key, "histogram", val);
        return 1;
    }

    private int update(Sample sample, String key, Timer t) {
        int nameIdx = this.indexForName(key);
        if (nameIdx < 0) {
            return 0;
        }
        long val = t.getCount();
        sample.setValue(nameIdx, (double)val);
        RRD4JReporter.log(key, "timer", val);
        return 1;
    }

    private int update(Sample sample, String key, Meter m) {
        int nameIdx = this.indexForName(key);
        if (nameIdx < 0) {
            return 0;
        }
        long val = m.getCount();
        sample.setValue(nameIdx, (double)val);
        RRD4JReporter.log(key, "meter", val);
        return 1;
    }

    private void storeDictionary(String path) throws IOException {
        File dictFile = new File(path);
        if (dictFile.exists() && !dictFile.delete()) {
            throw new IOException("Unable to delete dictionary file: " + dictFile.getPath());
        }
        Properties dict = new Properties();
        for (Map.Entry<String, Integer> entry : this.dictionary.entrySet()) {
            dict.put(String.valueOf(entry.getValue()), entry.getKey());
        }
        try (FileOutputStream out = new FileOutputStream(dictFile);){
            dict.store(out, "RRD4JReporter dictionary");
        }
    }

    private void writeUnknownSample() throws IOException {
        long updateTime = this.rrdDB.getLastUpdateTime() + 1L;
        this.rrdDB.createSample(updateTime).update();
        this.lastSampleTime = updateTime;
    }

    private static RrdDb createDB(RrdDef definition) throws IOException {
        File dbFile = new File(definition.getPath());
        if (!dbFile.getParentFile().exists() && !dbFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create directory for RRD file: " + dbFile.getParent());
        }
        RrdDb db = null;
        if (dbFile.exists() && !(db = new RrdDb(definition.getPath())).getRrdDef().equals(definition)) {
            db.close();
            File renamed = RRD4JReporter.renameDB(dbFile);
            LOGGER.info("Configuration changed, renamed existing RRD file to: {}", (Object)renamed.getPath());
            db = null;
        }
        if (db == null) {
            db = new RrdDb(definition);
        }
        return db;
    }

    private static File renameDB(File dbFile) throws IOException {
        int idx = 0;
        while (new File(dbFile.getPath() + RRD4JReporter.suffix(idx)).exists()) {
            ++idx;
        }
        RRD4JReporter.rename(dbFile.toPath(), dbFile.getName() + RRD4JReporter.suffix(idx));
        RRD4JReporter.rename(dbFile.toPath().resolveSibling(dbFile.getName() + PROPERTIES_SUFFIX), dbFile.getName() + RRD4JReporter.suffix(idx) + PROPERTIES_SUFFIX);
        return new File(dbFile.getParentFile(), dbFile.getName() + RRD4JReporter.suffix(idx));
    }

    private static String suffix(int idx) {
        return "." + idx;
    }

    private static void rename(Path path, String newName) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Path target = path.resolveSibling(newName);
        Files.move(path, target, StandardCopyOption.REPLACE_EXISTING);
    }

    long getStep() {
        try {
            return this.rrdDB.getHeader().getStep();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    String getPath() {
        try {
            return this.rrdDB.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    Set<String> getDatasources() {
        return this.dictionary.keySet();
    }

    Set<String> getArchives() {
        HashSet<String> archives = new HashSet<String>();
        for (int i = 0; i < this.rrdDB.getArcCount(); ++i) {
            Archive ar = this.rrdDB.getArchive(i);
            archives.add(ar.toString());
        }
        return archives;
    }

    public String toString() {
        return "RRD4JReporter [path=" + this.getPath() + ", datasources=" + this.getDatasources() + ", archives=" + this.getArchives() + ", step=" + this.getStep() + ", dictionary=" + this.dictionary + "]";
    }

    static class Builder {
        private MetricRegistry metricRegistry;
        private Clock clock = Clock.defaultClock();
        private TimeUnit ratesUnit = TimeUnit.SECONDS;
        private TimeUnit durationUnit = TimeUnit.MICROSECONDS;
        private File path = new File(".");
        private final List<String> indexedDS = new ArrayList<String>();
        private final Map<String, Integer> dictionary = new HashMap<String, Integer>();
        private final List<String> archives = new ArrayList<String>();
        private int step = 5;

        Builder(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
        }

        Builder withPath(File path) {
            if (path == null) {
                LOGGER.warn("Illegal path value, will use default({}).", (Object)RRD4JReporter.DEFAULT_PATH);
                path = new File(RRD4JReporter.DEFAULT_PATH);
            }
            this.path = path;
            return this;
        }

        Builder withDatasources(String[] datasources) {
            if (datasources == null) {
                datasources = new String[]{};
            }
            this.indexedDS.clear();
            this.dictionary.clear();
            int i = 0;
            for (String ds : datasources) {
                CharSequence[] tokens = ds.split(":");
                if (tokens.length == 6) {
                    String key = RRD4JReporter.normalize(tokens[1]);
                    tokens[1] = String.valueOf(i);
                    try {
                        this.indexedDS.add(this.checkDataSource(String.join((CharSequence)":", tokens)));
                        this.dictionary.put(key, i);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("Ignoring malformed datasource {}.", (Object)ds);
                    }
                } else {
                    LOGGER.warn("Ignoring malformed datasource {}.", (Object)ds);
                }
                ++i;
            }
            return this;
        }

        Builder withArchives(String[] archives) {
            if (archives == null) {
                archives = new String[]{};
            }
            this.archives.clear();
            for (String archive : archives) {
                try {
                    this.archives.add(this.checkArchive(archive));
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Ignoring malformed archive {}.", (Object)archive);
                }
            }
            return this;
        }

        Builder withStep(int step) {
            if (step <= 0) {
                LOGGER.warn("Illegal step value, will use default({}).", (Object)5);
                step = 5;
            }
            this.step = step;
            return this;
        }

        Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        Builder convertRatesTo(TimeUnit ratesUnit) {
            this.ratesUnit = ratesUnit;
            return this;
        }

        Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        RRD4JReporter build() throws IOException {
            if (this.indexedDS.isEmpty() || this.archives.isEmpty()) {
                return null;
            }
            return new RRD4JReporter(this.metricRegistry, "RRD4JReporter", MetricFilter.ALL, this.ratesUnit, this.durationUnit, this.dictionary, this.createDef(), this.clock);
        }

        private String checkDataSource(String ds) throws IllegalArgumentException {
            new RrdDef("path").addDatasource(ds);
            return ds;
        }

        private String checkArchive(String arch) throws IllegalArgumentException {
            new RrdDef("path").addArchive(arch);
            return arch;
        }

        private RrdDef createDef() {
            RrdDef def = new RrdDef(this.path.getPath(), (long)this.step);
            for (String ds : this.indexedDS) {
                def.addDatasource(ds);
            }
            for (String rra : this.archives) {
                def.addArchive(rra);
            }
            return def;
        }
    }
}

