/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ObjectNameFactory;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.sling.commons.metrics.internal.JmxUtil;
import org.apache.sling.commons.metrics.internal.MetricsServiceImpl;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleMetricsMapper
implements ObjectNameFactory {
    public static final String HEADER_DOMAIN_NAME = "Sling-Metrics-Domain";
    public static final String DEFAULT_DOMAIN_NAME = "org.apache.sling";
    static final String JMX_TYPE_METRICS = "Metrics";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, Bundle> metricToBundleMapping = new ConcurrentHashMap<String, Bundle>();
    private final MetricsServiceImpl metricsService;
    private final MetricRegistry registry;

    BundleMetricsMapper(MetricsServiceImpl metricsService, MetricRegistry registry) {
        this.metricsService = metricsService;
        this.registry = registry;
    }

    public void addMapping(String name, Bundle bundle) {
        this.metricToBundleMapping.putIfAbsent(name, bundle);
    }

    public void unregister(Set<String> registeredNames) {
        for (String name : registeredNames) {
            this.registry.remove(name);
            this.metricToBundleMapping.remove(name);
            this.metricsService.remove(name);
        }
        this.log.debug("Removed metrics for {}", registeredNames);
    }

    public ObjectName createName(String type, String domain, String name) {
        String mappedDomainName = JmxUtil.safeDomainName(this.getDomainName(name));
        if (mappedDomainName == null) {
            mappedDomainName = domain;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("type", JMX_TYPE_METRICS);
        table.put("name", JmxUtil.quoteValueIfRequired(name));
        try {
            return new ObjectName(mappedDomainName, table);
        }
        catch (MalformedObjectNameException e) {
            this.log.warn("Unable to register {} {}", new Object[]{type, name, e});
            throw new RuntimeException(e);
        }
    }

    private String getDomainName(String name) {
        Bundle bundle = (Bundle)this.metricToBundleMapping.get(name);
        return this.getDomainName(bundle);
    }

    private String getDomainName(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        String domainNameHeader = (String)bundle.getHeaders().get(HEADER_DOMAIN_NAME);
        if (domainNameHeader != null) {
            return domainNameHeader;
        }
        return bundle.getSymbolicName();
    }
}

