/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sling.commons.log.logback.internal.config.ConfigurationException;
import org.apache.sling.commons.log.logback.internal.config.LogConfigurator;
import org.osgi.service.cm.ManagedServiceFactory;

class LoggerManagedServiceFactory
extends LogConfigurator
implements ManagedServiceFactory {
    public static final String LOG_FILE_DEFAULT = "logs/error.log";

    LoggerManagedServiceFactory() {
    }

    public String getName() {
        return "Logger configurator";
    }

    public void updated(String pid, Dictionary configuration) throws org.osgi.service.cm.ConfigurationException {
        try {
            Hashtable conf = configuration;
            if (((Dictionary)configuration).get("org.apache.sling.commons.log.file") == null) {
                ArrayList keys = Collections.list(((Dictionary)configuration).keys());
                Map confCopy = keys.stream().collect(Collectors.toMap(Function.identity(), configuration::get));
                confCopy.put("org.apache.sling.commons.log.file", LOG_FILE_DEFAULT);
                conf = new Hashtable(confCopy);
            }
            this.getLogConfigManager().updateLoggerConfiguration(pid, conf, true);
        }
        catch (ConfigurationException ce) {
            throw new org.osgi.service.cm.ConfigurationException(ce.getProperty(), ce.getReason(), (Throwable)ce);
        }
    }

    public void deleted(String pid) {
        try {
            this.getLogConfigManager().updateLoggerConfiguration(pid, null, true);
        }
        catch (ConfigurationException ce) {
            this.getLogConfigManager().internalFailure("Unexpected Configuration Problem", ce);
        }
    }
}

