/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.EnsureExceptionHandling;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;

public class MaskingMessageUtil
extends MessageConverter {
    public static void setMessageConverter(PatternLayout pl) {
        pl.getInstanceConverterMap().put("m", MaskingMessageConverter.class.getName());
        pl.getInstanceConverterMap().put("msg", MaskingMessageConverter.class.getName());
        pl.getInstanceConverterMap().put("message", MaskingMessageConverter.class.getName());
        pl.getInstanceConverterMap().put("ex", MaskingThrowableProxyConverter.class.getName());
        pl.getInstanceConverterMap().put("exception", MaskingThrowableProxyConverter.class.getName());
        pl.getInstanceConverterMap().put("rEx", MaskingRootCauseFirstThrowableProxyConverter.class.getName());
        pl.getInstanceConverterMap().put("rootException", MaskingRootCauseFirstThrowableProxyConverter.class.getName());
        pl.getInstanceConverterMap().put("throwable", MaskingThrowableProxyConverter.class.getName());
        pl.getInstanceConverterMap().put("xEx", MaskingExtendedThrowableProxyConverter.class.getName());
        pl.getInstanceConverterMap().put("xException", MaskingExtendedThrowableProxyConverter.class.getName());
        pl.getInstanceConverterMap().put("xThrowable", MaskingExtendedThrowableProxyConverter.class.getName());
        pl.setPostCompileProcessor(new MaskingEnsureExceptionHandling());
    }

    public static Encoder<ILoggingEvent> getDefaultEncoder(Context loggerContext) {
        MaskingPatternLayoutEncoder encoder = new MaskingPatternLayoutEncoder();
        encoder.setPattern("%d{dd.MM.yyyy HH:mm:ss.SSS} *%level* [%thread] %logger %msg%n");
        encoder.setContext(loggerContext);
        ((LayoutWrappingEncoder)encoder).start();
        return encoder;
    }

    static String mask(String msg) {
        if (msg == null) {
            return null;
        }
        return msg.replace('\n', '_').replace('\r', '_');
    }

    static final class MaskingPatternLayoutEncoder
    extends PatternLayoutEncoderBase<ILoggingEvent> {
        MaskingPatternLayoutEncoder() {
        }

        @Override
        public void start() {
            PatternLayout patternLayout = new PatternLayout();
            patternLayout.setContext(this.context);
            patternLayout.setPattern(this.getPattern());
            patternLayout.setOutputPatternAsHeader(this.outputPatternAsHeader);
            MaskingMessageUtil.setMessageConverter(patternLayout);
            patternLayout.start();
            this.layout = patternLayout;
            super.start();
        }
    }

    static final class MaskingEnsureExceptionHandling
    extends EnsureExceptionHandling {
        MaskingEnsureExceptionHandling() {
        }

        @Override
        public void process(Context context, Converter<ILoggingEvent> head) {
            if (head == null) {
                throw new IllegalArgumentException("cannot process empty chain");
            }
            if (!this.chainHandlesThrowable(head)) {
                Converter<ILoggingEvent> tail = ConverterUtil.findTail(head);
                ThrowableProxyConverter exConverter = null;
                LoggerContext loggerContext = (LoggerContext)context;
                exConverter = loggerContext.isPackagingDataEnabled() ? new MaskingExtendedThrowableProxyConverter() : new MaskingThrowableProxyConverter();
                tail.setNext(exConverter);
            }
        }
    }

    public static final class MaskingThrowableProxy
    implements IThrowableProxy {
        private final IThrowableProxy proxied;

        public MaskingThrowableProxy(IThrowableProxy proxied) {
            this.proxied = proxied;
        }

        @Override
        public String getMessage() {
            return MaskingMessageUtil.mask(this.proxied.getMessage());
        }

        private IThrowableProxy getProxy(IThrowableProxy p) {
            if (p == null) {
                return null;
            }
            if (p == this.proxied || p == this) {
                return this;
            }
            return new MaskingThrowableProxy(p);
        }

        @Override
        public IThrowableProxy getCause() {
            return this.getProxy(this.proxied.getCause());
        }

        @Override
        public String getClassName() {
            return this.proxied.getClassName();
        }

        @Override
        public StackTraceElementProxy[] getStackTraceElementProxyArray() {
            return this.proxied.getStackTraceElementProxyArray();
        }

        @Override
        public int getCommonFrames() {
            return this.proxied.getCommonFrames();
        }

        @Override
        public IThrowableProxy[] getSuppressed() {
            IThrowableProxy[] result = this.proxied.getSuppressed();
            if (result == null || result.length == 0) {
                return result;
            }
            IThrowableProxy[] proxies = new IThrowableProxy[result.length];
            for (int i = 0; i < proxies.length; ++i) {
                proxies[i] = this.getProxy(result[i]);
            }
            return proxies;
        }
    }

    public static class MaskingExtendedThrowableProxyConverter
    extends ExtendedThrowableProxyConverter {
        @Override
        protected String throwableProxyToString(IThrowableProxy tp) {
            return super.throwableProxyToString(new MaskingThrowableProxy(tp));
        }
    }

    public static final class MaskingRootCauseFirstThrowableProxyConverter
    extends RootCauseFirstThrowableProxyConverter {
        @Override
        protected String throwableProxyToString(IThrowableProxy tp) {
            return super.throwableProxyToString(new MaskingThrowableProxy(tp));
        }
    }

    public static final class MaskingThrowableProxyConverter
    extends ThrowableProxyConverter {
        @Override
        protected String throwableProxyToString(IThrowableProxy tp) {
            return super.throwableProxyToString(new MaskingThrowableProxy(tp));
        }
    }

    public static final class MaskingMessageConverter
    extends MessageConverter {
        @Override
        public String convert(ILoggingEvent event) {
            return MaskingMessageUtil.mask(super.convert(event));
        }
    }
}

