/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.PrintStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingStatusPrinter {
    public static void printInCaseOfErrorsOrWarnings(Context context, long threshold, long msgSince, boolean initSuccess) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        PrintStream ps = System.out;
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusUtil statusUtil = new StatusUtil(context);
            if (statusUtil.getHighestLevel(threshold) >= 1) {
                List filteredList = StatusUtil.filterStatusListByTimeThreshold((List)sm.getCopyOfStatusList(), (long)msgSince);
                SlingStatusPrinter.print(filteredList, initSuccess);
            }
        }
    }

    private static void print(List<Status> statusList, boolean initSuccess) {
        if (statusList == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (initSuccess) {
            sb.append("While (re)configuring Logback transient issues were observed. More details are provided below.");
            sb.append(CoreConstants.LINE_SEPARATOR);
        }
        String prefix = "";
        if (initSuccess) {
            prefix = "*Logback Status* ";
        }
        for (Status s : statusList) {
            StatusPrinter.buildStr((StringBuilder)sb, (String)prefix, (Status)s);
        }
        if (!initSuccess) {
            System.out.println(sb.toString());
        } else {
            Logger logger = LoggerFactory.getLogger(SlingStatusPrinter.class);
            logger.info(sb.toString());
        }
    }
}

