/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.stacktrace;

import ch.qos.logback.classic.pattern.EnsureExceptionHandling;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import org.apache.sling.commons.log.logback.internal.stacktrace.PackageInfoCollector;

public class OSGiAwareExceptionHandling
extends EnsureExceptionHandling {
    private final PackageInfoCollector collector;

    public OSGiAwareExceptionHandling(PackageInfoCollector collector) {
        this.collector = collector;
    }

    public void process(Context context, Converter<ILoggingEvent> head) {
        if (head == null) {
            throw new IllegalArgumentException("cannot process empty chain");
        }
        if (!this.chainHandlesThrowable(head)) {
            Converter tail = ConverterUtil.findTail(head);
            OSGiAwareConverter exConverter = new OSGiAwareConverter();
            tail.setNext((Converter)exConverter);
        }
    }

    private class OSGiAwareConverter
    extends ExtendedThrowableProxyConverter {
        private OSGiAwareConverter() {
        }

        protected void extraData(StringBuilder builder, StackTraceElementProxy step) {
            String bundleInfo;
            if (step != null && (bundleInfo = OSGiAwareExceptionHandling.this.collector.getBundleInfo(step.getStackTraceElement().getClassName())) != null) {
                builder.append(" [").append(bundleInfo).append(']');
            }
        }
    }
}

