/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.ContextUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.logback.internal.LogbackManager;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class FilterTracker
extends ServiceTracker
implements LogbackResetListener {
    private static final String ALL_APPENDERS = "*";
    private static final String PROP_APPENDER = "appenders";
    private final LoggerContext loggerContext;
    private final ContextUtil contextUtil;
    private final LogbackManager logbackManager;
    private Map<ServiceReference, FilterInfo> filters = new ConcurrentHashMap<ServiceReference, FilterInfo>();

    public FilterTracker(BundleContext context, LogbackManager logbackManager) throws InvalidSyntaxException {
        super(context, FilterTracker.createFilter(), null);
        this.logbackManager = logbackManager;
        this.loggerContext = logbackManager.getLoggerContext();
        this.contextUtil = new ContextUtil((Context)this.loggerContext);
    }

    public Object addingService(ServiceReference reference) {
        ch.qos.logback.core.filter.Filter f = (ch.qos.logback.core.filter.Filter)super.addingService(reference);
        f.setContext((Context)this.loggerContext);
        f.start();
        FilterInfo fi = new FilterInfo(reference, (ch.qos.logback.core.filter.Filter<ILoggingEvent>)f);
        this.filters.put(reference, fi);
        this.attachFilter(fi, this.getAppenderMap());
        return f;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        FilterInfo fi = this.filters.remove(reference);
        this.detachFilter(fi, this.getAppenderMap());
        this.filters.put(reference, new FilterInfo(reference, (ch.qos.logback.core.filter.Filter<ILoggingEvent>)((ch.qos.logback.core.filter.Filter)service)));
        this.attachFilter(fi, this.getAppenderMap());
    }

    public void removedService(ServiceReference reference, Object service) {
        FilterInfo fi = this.filters.remove(reference);
        fi.stop();
        this.detachFilter(fi, this.getAppenderMap());
        super.removedService(reference, service);
    }

    public synchronized void close() {
        super.close();
        this.filters.clear();
    }

    @Override
    public void onResetStart(LoggerContext context) {
    }

    @Override
    public void onResetComplete(LoggerContext context) {
        Map<String, Appender<ILoggingEvent>> appenderMap = this.getAppenderMap();
        for (FilterInfo fi : this.filters.values()) {
            this.attachFilter(fi, appenderMap);
        }
    }

    private void attachFilter(FilterInfo fi, Map<String, Appender<ILoggingEvent>> appenderMap) {
        if (fi.registerAgainstAllAppenders) {
            for (Appender<ILoggingEvent> appender : appenderMap.values()) {
                this.attachFilter(appender, fi);
            }
            return;
        }
        for (String appenderName : fi.appenderNames) {
            Appender<ILoggingEvent> appender = appenderMap.get(appenderName);
            if (appender != null) {
                this.attachFilter(appender, fi);
                continue;
            }
            this.contextUtil.addWarn("No appender with name [" + appenderName + "] found to which " + fi.filter + " can be attached");
        }
    }

    private void detachFilter(FilterInfo fi, Map<String, Appender<ILoggingEvent>> appenderMap) {
        if (fi.registerAgainstAllAppenders) {
            for (Appender<ILoggingEvent> appender : appenderMap.values()) {
                this.detachFilter(appender, fi);
            }
            return;
        }
        for (String appenderName : fi.appenderNames) {
            Appender<ILoggingEvent> appender = appenderMap.get(appenderName);
            if (appender == null) continue;
            this.detachFilter(appender, fi);
        }
    }

    private void attachFilter(Appender<ILoggingEvent> appender, FilterInfo fi) {
        if (!appender.getCopyOfAttachedFiltersList().contains(fi.filter)) {
            appender.addFilter(fi.filter);
        }
    }

    private void detachFilter(Appender<ILoggingEvent> appender, FilterInfo fi) {
        if (appender.getCopyOfAttachedFiltersList().contains(fi.filter)) {
            List filters = appender.getCopyOfAttachedFiltersList();
            appender.clearAllFilters();
            for (ch.qos.logback.core.filter.Filter filter : filters) {
                if (fi.filter.equals((Object)filter)) continue;
                appender.addFilter(filter);
            }
        }
    }

    private Map<String, Appender<ILoggingEvent>> getAppenderMap() {
        return this.logbackManager.determineLoggerState().getAppenderMap();
    }

    private static Filter createFilter() throws InvalidSyntaxException {
        String filter = String.format("(&(objectClass=%s)(%s=*))", ch.qos.logback.core.filter.Filter.class.getName(), PROP_APPENDER);
        return FrameworkUtil.createFilter((String)filter);
    }

    public static class FilterInfo {
        final ServiceReference reference;
        final ch.qos.logback.core.filter.Filter<ILoggingEvent> filter;
        final Set<String> appenderNames;
        final boolean registerAgainstAllAppenders;

        FilterInfo(ServiceReference reference, ch.qos.logback.core.filter.Filter<ILoggingEvent> filter) {
            this.reference = reference;
            this.filter = filter;
            this.appenderNames = Collections.unmodifiableSet(new HashSet<String>(Util.toList(reference.getProperty(FilterTracker.PROP_APPENDER))));
            this.registerAgainstAllAppenders = this.appenderNames.contains(FilterTracker.ALL_APPENDERS);
        }

        public void stop() {
            if (this.filter.isStarted()) {
                this.filter.stop();
            }
        }
    }
}

