/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sling.commons.log.logback.internal.LogbackManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private LogbackManager logManager;
    private BundleContext context;
    private Timer timer;
    private long startTime;
    private static final AtomicInteger counter = new AtomicInteger();
    public static final long INIT_TASK_PERIOD_MSEC = 1L;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.startTime = System.currentTimeMillis();
        this.timer = new Timer(this.getClass().getSimpleName() + "#" + counter.incrementAndGet());
        if (Activator.isSlf4jInitialized()) {
            this.initializeLogbackManager(true);
        } else {
            System.out.println("Slf4j is not initialized yet. Delaying Logback support initialization");
            this.timer.schedule((TimerTask)new LogbackInitializerTask(), 0L, 1L);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.logManager != null) {
            this.logManager.shutdown();
            this.logManager = null;
        }
    }

    private void initializeLogbackManager(boolean immediateInit) throws InvalidSyntaxException {
        this.logManager = new LogbackManager(this.context);
        Logger log = LoggerFactory.getLogger(this.getClass());
        if (immediateInit) {
            log.info("LogbackManager initialized at bundle startup");
        } else {
            log.info("LogbackManager initialized after waiting for Slf4j, {} msec after startup", (Object)(System.currentTimeMillis() - this.startTime));
        }
    }

    private static boolean isSlf4jInitialized() {
        return LoggerFactory.getILoggerFactory() instanceof LoggerContext;
    }

    private class LogbackInitializerTask
    extends TimerTask {
        @Override
        public void run() {
            if (!Activator.isSlf4jInitialized()) {
                return;
            }
            try {
                Activator.this.initializeLogbackManager(false);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                StatusPrinter.buildStr((StringBuilder)sb, (String)"", (Status)new ErrorStatus("Error occurred while starting Logback integration", (Object)this, (Throwable)e));
                System.err.print(sb.toString());
            }
            this.cancel();
            Activator.this.timer.cancel();
        }
    }
}

