/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html.impl.tag;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sling.commons.html.AttrValue;
import org.apache.sling.commons.html.HtmlElement;
import org.apache.sling.commons.html.HtmlElementType;

public class StartTag
implements HtmlElement {
    private String value;
    private Map<String, AttrValue> attributes = Collections.emptyMap();
    private boolean selfClosing;
    private static List<String> voidTags = Arrays.asList("area", "base", "br", "col", "embed", "hr", "img", "input", "link", "meta", "param", "source", "track", "wbr");

    public StartTag(String value, Map<String, AttrValue> attrList) {
        this(value, attrList, voidTags.contains(value));
    }

    public StartTag(String value, Map<String, AttrValue> attrList, boolean selfClosing) {
        this.value = value;
        this.selfClosing = selfClosing;
        this.attributes = attrList;
    }

    @Override
    public HtmlElementType getType() {
        return HtmlElementType.START_TAG;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean supportsAttributes() {
        return true;
    }

    @Override
    public boolean getVoidTag() {
        return this.selfClosing;
    }

    @Override
    public Map<String, AttrValue> getAttributes() {
        return this.attributes;
    }
}

