/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.classloader.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.sling.commons.classloader.DynamicClassLoader;
import org.apache.sling.commons.classloader.impl.DynamicClassLoaderManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderFacade
extends ClassLoader
implements DynamicClassLoader {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final DynamicClassLoaderManagerImpl manager;
    private final List<URL> EMPTY_LIST = Collections.emptyList();

    public ClassLoaderFacade(DynamicClassLoaderManagerImpl manager) {
        this.manager = manager;
    }

    private boolean checkManagerActive() {
        if (!this.manager.isActive()) {
            String msg = "Dynamic class loader has already been deactivated.";
            StackTraceProbe p = new StackTraceProbe("Dynamic class loader has already been deactivated.");
            this.logger.error("Dynamic class loader has already been deactivated.", (Throwable)p);
            return false;
        }
        return true;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader[] loaders;
        if (!this.checkManagerActive()) {
            return null;
        }
        for (ClassLoader cl : loaders = this.manager.getDynamicClassLoaders()) {
            if (cl == null) continue;
            try {
                URL u = cl.getResource(name);
                if (u == null) continue;
                return u;
            }
            catch (Throwable t) {
                this.logger.error("Exception while querying class loader " + cl + " for resource " + name, t);
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (!this.checkManagerActive()) {
            return Collections.enumeration(this.EMPTY_LIST);
        }
        ClassLoader[] loaders = this.manager.getDynamicClassLoaders();
        ArrayList<URL> resources = new ArrayList<URL>();
        for (ClassLoader cl : loaders) {
            if (cl == null) continue;
            try {
                Enumeration<URL> e = cl.getResources(name);
                if (e == null || !e.hasMoreElements()) continue;
                resources.addAll(Collections.list(e));
            }
            catch (Throwable t) {
                this.logger.error("Exception while querying class loader " + cl + " for resources " + name, t);
            }
        }
        return Collections.enumeration(resources);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader[] loaders;
        if (!this.checkManagerActive()) {
            throw new ClassNotFoundException(name);
        }
        for (ClassLoader cl : loaders = this.manager.getDynamicClassLoaders()) {
            if (cl == null) continue;
            try {
                Class<?> c = cl.loadClass(name);
                return c;
            }
            catch (ClassNotFoundException c) {
            }
            catch (Throwable t) {
                this.logger.error("Exception while trying to load class " + name + " from class loader " + cl, t);
            }
        }
        if (name.startsWith("sun.reflect.") || name.startsWith("jdk.internal.reflect.")) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable t) {
                this.logger.error("Exception while trying to load class " + name + " from class loader " + ClassLoader.getSystemClassLoader(), t);
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public boolean isLive() {
        return this.manager.isActive();
    }

    static class StackTraceProbe
    extends Exception {
        StackTraceProbe(String reason) {
            super(reason);
        }
    }
}

