/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class})
public class CreateUserAction
implements FormAction {
    private static final Logger log = LoggerFactory.getLogger(CreateUserAction.class);
    public static final String RESOURCE_TYPE = "reference/components/forms/actions/createuser";
    public static final String PROFILE_PROPERTIES = "profileProperties";
    public static final String GROUPS = "groups";
    public static final String PN_USERNAME = "username";
    public static final String PN_INTERMEDIATE_PATH = "intermediatePath";
    private final ResourceResolverFactory factory;

    @Activate
    public CreateUserAction(@Reference ResourceResolverFactory factory) {
        this.factory = factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        StringSubstitutor sub = new StringSubstitutor((Map)request.getFormData());
        ValueMap properties = actionResource.getValueMap();
        String username = (String)request.getFormData().get(PN_USERNAME, String.class);
        String password = (String)request.getFormData().get("password", String.class);
        String intermediatePath = (String)properties.get(PN_INTERMEDIATE_PATH, String.class);
        if (StringUtils.isEmpty((CharSequence)username)) return FormActionResult.failure("Empty username / password");
        if (StringUtils.isEmpty((CharSequence)password)) {
            return FormActionResult.failure("Empty username / password");
        }
        try {
            String[] groups;
            UserManager userManager;
            ResourceResolver adminResolver;
            block16: {
                adminResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "slingcms-reference-usermanager"));
                JackrabbitSession session = (JackrabbitSession)adminResolver.adaptTo(Session.class);
                userManager = session.getUserManager();
                if (userManager.getAuthorizable(username) != null) {
                    log.error("Failed to create user, {} already exists", (Object)username);
                    FormActionResult formActionResult = FormActionResult.failure("User " + username + " already exists");
                    return formActionResult;
                }
                break block16;
                finally {
                    if (adminResolver != null) {
                        adminResolver.close();
                    }
                }
            }
            log.debug("Creating user {}", (Object)username);
            User user = userManager.createUser(username, password, (Principal)new PrincipalImpl(username), intermediatePath);
            String[] stringArray = groups = (String[])properties.get(GROUPS, (Object)new String[0]);
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    log.debug("Updating profile for {}", (Object)username);
                    this.updateProfile(adminResolver, user, (String[])properties.get(PROFILE_PROPERTIES, (Object)new String[0]), request.getFormData());
                    log.debug("Saving changes!");
                    adminResolver.commit();
                    FormActionResult formActionResult = FormActionResult.success("User " + username + " created successfully");
                    return formActionResult;
                }
                String g = stringArray[n2];
                String groupName = sub.replace(g);
                Authorizable group = userManager.getAuthorizable(groupName);
                if (group == null || !group.isGroup()) {
                    log.error("Could not find group {}", (Object)groupName);
                    FormActionResult formActionResult = FormActionResult.failure("Could not find group: " + groupName);
                    return formActionResult;
                }
                ((Group)group).addMember((Authorizable)user);
                ++n2;
            }
        }
        catch (LoginException le) {
            log.error("Failed to get user manager service user", (Throwable)le);
            return FormActionResult.failure("Failed to get service user");
        }
        catch (RepositoryException | PersistenceException e) {
            log.error("Failed to create user " + username, e);
            return FormActionResult.failure("Failed to create user " + username);
        }
    }

    private void updateProfile(ResourceResolver adminResolver, User user, String @NotNull [] toset, ValueMap formData) throws PersistenceException, RepositoryException {
        if (toset.length > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            Arrays.stream(toset).filter(k -> formData.keySet().contains(k)).forEach(k -> properties.put((String)k, (String)formData.get(k)));
            properties.put("jcr:primaryType", "nt:unstructured");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)(user.getPath() + "/profile"), properties, (String)"nt:unstructured", (boolean)false);
        }
    }

    @Override
    public boolean handles(Resource actionResource) {
        return RESOURCE_TYPE.equals(actionResource.getResourceType());
    }
}

