/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.reference.SearchService;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class Search {
    private static final Logger log = LoggerFactory.getLogger(Search.class);
    public static final String TERM_PARAMETER = "q";
    private final int count;
    private final int end;
    private final int page;
    private final Integer[] pages;
    private final SlingHttpServletRequest request;
    private final List<Resource> results;
    private final int start;
    private final ResourceResolver resolver;

    @Inject
    public Search(@Self SlingHttpServletRequest request, @ValueMapValue @Named(value="limit") int limit, @OSGiService SearchService searchService, @ValueMapValue @Named(value="basePath") String basePath) {
        this.request = request;
        HashSet<String> distinct = new HashSet<String>();
        String term = Text.escapeIllegalXpathSearchChars((String)request.getParameter(TERM_PARAMETER)).replace("'", "''");
        ArrayList<Resource> queryResults = new ArrayList<Resource>();
        this.resolver = searchService.getResourceResolver(request);
        String query = "SELECT * FROM [sling:Page] AS p WHERE ([jcr:content/published]=true OR [jcr:content/sling:published]=true) AND (p.[jcr:content/hideInSitemap] IS NULL OR p.[jcr:content/hideInSitemap] <> true) AND ISDESCENDANTNODE(p, '" + basePath + "') AND CONTAINS(p.*, '" + term + "') ORDER BY [jcr:score]";
        log.debug("Searching for pages with {} under {} with query: {}", new Object[]{term, basePath, query});
        Iterator res = this.resolver.findResources(query, "JCR-SQL2");
        while (res.hasNext()) {
            Resource result = (Resource)res.next();
            if (distinct.contains(result.getPath())) continue;
            queryResults.add(result);
            distinct.add(result.getPath());
        }
        this.count = queryResults.size();
        log.debug("Found {} results", (Object)this.count);
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("page")) && request.getParameter("page").matches("\\d+")) {
            this.page = Integer.parseInt(request.getParameter("page"), 10) - 1;
            log.debug("Using page {}", (Object)this.page);
        } else {
            this.page = 0;
            log.debug("Page not specified or not valid");
        }
        this.start = this.page * limit >= this.count ? this.count : this.page * limit;
        log.debug("Using start {}", (Object)this.start);
        this.end = this.page * limit + limit >= this.count ? this.count : this.page * limit + limit;
        log.debug("Using end {}", (Object)this.end);
        this.results = queryResults.subList(this.start, this.end);
        ArrayList<Integer> pgs = new ArrayList<Integer>();
        int max = (int)Math.ceil((double)this.count / (double)limit) + 1;
        for (int i = 1; i < max; ++i) {
            pgs.add(i);
        }
        this.pages = pgs.toArray(new Integer[pgs.size()]);
        if (log.isDebugEnabled()) {
            log.debug("Loaded pages {}", (Object)Arrays.toString((Object[])this.pages));
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getCurrentPage() {
        return this.page + 1;
    }

    public int getEnd() {
        return this.end;
    }

    public Integer[] getPages() {
        return this.pages;
    }

    public List<Resource> getResults() {
        return this.results;
    }

    public int getStart() {
        return this.start;
    }

    public String getTerm() {
        return this.request.getParameter(TERM_PARAMETER);
    }

    public boolean isFirst() {
        return this.page == 0;
    }

    public boolean isLast() {
        if (this.pages.length > 0) {
            return this.page + 1 == this.pages[this.pages.length - 1];
        }
        return true;
    }
}

