/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.readability.impl;

import java.util.List;
import java.util.Locale;
import org.apache.sling.cms.readability.ReadabilityService;
import org.apache.sling.cms.readability.ReadabilityServiceFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ReadabilityServiceFactory.class})
public class ReadabilityServiceFactoryImpl
implements ReadabilityServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(ReadabilityServiceFactoryImpl.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private List<ReadabilityService> services;

    public ReadabilityService getReadabilityService(Locale locale) {
        log.debug("Locating readability service for {}", (Object)locale);
        return this.services.stream().filter(svc -> locale.equals(svc.getLocale())).findFirst().orElse(this.services.stream().filter(svc -> locale.getLanguage().equals(svc.getLocale().getLanguage())).findFirst().orElse(null));
    }
}

