/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal;

import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.IndexDefinitionBuilder;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={RepositoryInitializer.class})
public class IndexCreator
implements RepositoryInitializer {
    private static final String VAL_NODE_NAME = ":nodeName";
    private static final String PN_NODE_NAME = "nodeName";
    private static final String PN_JCR_TITLE = "jcrTitle";
    private static final String[] CONTENT_PATHS = new String[]{"/content", "/static"};
    private static final String JCR_CONTENT_PROPERTIES = "jcr:content/*";
    private static final String SLINGCMS = "slingcms";

    public void initialize(@NotNull NodeBuilder builder) {
        NodeBuilder indexRoot = builder.child("oak:index");
        this.ensureFolderIndex(indexRoot);
        this.ensurentHierarchyNodeIndex(indexRoot);
        this.ensureSlingComponentIndex(indexRoot);
        this.ensureSlingEventJobIndex(indexRoot);
        this.ensureSlingFileIndex(indexRoot);
        this.ensureSlingPageIndex(indexRoot);
        this.ensureSlingTaxonomyIndex(indexRoot);
    }

    private void ensureFolderIndex(NodeBuilder indexRoot) {
        NodeBuilder index = this.ensureNode(indexRoot, "ntFolder", "oak:QueryIndexDefinition");
        IndexDefinitionBuilder builder = new IndexDefinitionBuilder(index, true);
        builder.aggregateRule("nt:folder", new String[]{JCR_CONTENT_PROPERTIES});
        builder.async(new String[]{"async", "nrt"});
        builder.tags(new String[]{SLINGCMS, "slingcms-ntFolder"});
        IndexDefinitionBuilder.IndexRule indexRule = builder.indexRule("nt:folder");
        this.ensureCommonSlingProperties(indexRule);
    }

    private void ensurentHierarchyNodeIndex(NodeBuilder indexRoot) {
        NodeBuilder index = this.ensureNode(indexRoot, "ntHierarchyNode", "oak:QueryIndexDefinition");
        IndexDefinitionBuilder builder = new IndexDefinitionBuilder(index, true);
        builder.aggregateRule("sling:Page", new String[]{JCR_CONTENT_PROPERTIES});
        builder.async(new String[]{"async", "nrt"});
        builder.evaluatePathRestrictions();
        builder.includedPaths(CONTENT_PATHS);
        builder.tags(new String[]{SLINGCMS, "slingcms-ntHierarchyNode"});
        IndexDefinitionBuilder.IndexRule indexRule = builder.indexRule("nt:hierarchyNode");
        this.ensureCommonSlingProperties(indexRule);
    }

    private void ensureSlingComponentIndex(NodeBuilder indexRoot) {
        NodeBuilder index = this.ensureNode(indexRoot, "slingComponent", "oak:QueryIndexDefinition");
        IndexDefinitionBuilder builder = new IndexDefinitionBuilder(index, true);
        builder.async(new String[]{"async", "nrt"});
        builder.evaluatePathRestrictions();
        builder.includedPaths(new String[]{"/apps", "/libs"});
        builder.tags(new String[]{SLINGCMS, "slingcms-slingComponent"});
        IndexDefinitionBuilder.IndexRule indexRule = builder.indexRule("sling:Component");
        indexRule.property("componentType", "componentType", false).propertyIndex().notNullCheckEnabled();
        indexRule.property(PN_JCR_TITLE, "jcr:title", false).analyzed().propertyIndex().ordered();
        indexRule.property(PN_NODE_NAME, VAL_NODE_NAME, false).analyzed().propertyIndex().ordered();
        indexRule.property("jcrLastModifiedBy", "jcr:content/jcr:lastModifiedBy", false).propertyIndex();
    }

    private void ensureSlingEventJobIndex(NodeBuilder indexRoot) {
        NodeBuilder index = this.ensureNode(indexRoot, "slingeventJob", "oak:QueryIndexDefinition");
        IndexDefinitionBuilder builder = new IndexDefinitionBuilder(index, true);
        builder.async(new String[]{"async", "nrt"});
        builder.evaluatePathRestrictions();
        builder.includedPaths(new String[]{"/var/eventing"});
        builder.tags(new String[]{SLINGCMS, "slingcms-slingeventJob"});
        IndexDefinitionBuilder.IndexRule indexRule = builder.indexRule("slingevent:Job");
        indexRule.property("eventJobTopic", "event.job.topic", false).propertyIndex().analyzed();
        indexRule.property("slingeventCreated", "slingevent:created", false).propertyIndex().ordered().type("Date");
        indexRule.property("slingeventId", "slingevent:eventId", false).propertyIndex();
        indexRule.property("slingeventFinishedState", "slingevent:finishedState", false).nullCheckEnabled().propertyIndex();
        indexRule.property("finishedDate", "slingevent:finishedDate", false).propertyIndex().ordered().type("Date");
    }

    private void ensureSlingFileIndex(NodeBuilder indexRoot) {
        NodeBuilder index = this.ensureNode(indexRoot, "slingFile", "oak:QueryIndexDefinition");
        IndexDefinitionBuilder builder = new IndexDefinitionBuilder(index, true);
        builder.aggregateRule("sling:File", new String[]{JCR_CONTENT_PROPERTIES, "jcr:content/metadata/*"});
        builder.async(new String[]{"async", "nrt"});
        builder.evaluatePathRestrictions();
        builder.includedPaths(CONTENT_PATHS);
        builder.supersedes(new String[]{"/oak:index/slingFileLucene"});
        builder.tags(new String[]{SLINGCMS, "slingcms-slingFile"});
        IndexDefinitionBuilder.IndexRule indexRule = builder.indexRule("sling:File");
        this.ensureCommonSlingProperties(indexRule);
        indexRule.property("metadata", "jcr:content/metadata/.*", true).propertyIndex().analyzed();
    }

    private void ensureSlingPageIndex(NodeBuilder indexRoot) {
        NodeBuilder index = this.ensureNode(indexRoot, "slingPage", "oak:QueryIndexDefinition");
        IndexDefinitionBuilder builder = new IndexDefinitionBuilder(index, true);
        builder.aggregateRule("sling:Page", new String[]{JCR_CONTENT_PROPERTIES, "jcr:content/*/*", "jcr:content/*/*/*", "jcr:content/*/*/*/*"});
        builder.async(new String[]{"async", "nrt"});
        builder.evaluatePathRestrictions();
        builder.includedPaths(CONTENT_PATHS);
        builder.supersedes(new String[]{"/oak:index/slingPageLucene"});
        builder.tags(new String[]{SLINGCMS, "slingcms-slingPage"});
        IndexDefinitionBuilder.IndexRule indexRule = builder.indexRule("sling:Page");
        this.ensureCommonSlingProperties(indexRule);
        indexRule.property("slingTemplate", "jcr:content/sling:template", false).propertyIndex();
    }

    private void ensureSlingTaxonomyIndex(NodeBuilder indexRoot) {
        NodeBuilder index = this.ensureNode(indexRoot, "slingTaxonomy", "oak:QueryIndexDefinition");
        IndexDefinitionBuilder builder = new IndexDefinitionBuilder(index, true);
        builder.async(new String[]{"async", "nrt"});
        builder.evaluatePathRestrictions();
        builder.includedPaths(new String[]{"/etc/taxonomy"});
        builder.tags(new String[]{SLINGCMS, "slingcms-slingTaxonomy"});
        IndexDefinitionBuilder.IndexRule indexRule = builder.indexRule("sling:Taxonomy");
        indexRule.property(PN_JCR_TITLE, "jcr:title", false).analyzed().propertyIndex().ordered();
        indexRule.property(PN_NODE_NAME, VAL_NODE_NAME, false).analyzed().propertyIndex().ordered();
    }

    private void ensureCommonSlingProperties(IndexDefinitionBuilder.IndexRule indexRule) {
        indexRule.property(PN_JCR_TITLE, "jcr:content/jcr:title", false).analyzed().propertyIndex().boost(2.0f).ordered();
        indexRule.property(PN_NODE_NAME, VAL_NODE_NAME, false).analyzed().propertyIndex().ordered();
        indexRule.property("jcrDescription", "jcr:content/jcr:description", false).analyzed().propertyIndex();
        indexRule.property("jcrLastModified", "jcr:content/jcr:lastModified", false).propertyIndex().ordered().type("Date");
        indexRule.property("jcrLastModifiedBy", "jcr:content/jcr:lastModifiedBy", false).propertyIndex();
        indexRule.property("slingPublished", "jcr:content/sling:published", false).propertyIndex().type("Boolean");
        indexRule.property("slingTaxonomy", "jcr:content/sling:taxonomy", false).propertyIndex().analyzed();
        indexRule.property("allProperties", "jcr:content/.*", true).propertyIndex().analyzed();
    }

    private NodeBuilder ensureNode(NodeBuilder parent, String childName, String type) {
        NodeBuilder child = parent.child(childName);
        this.ensureProperty(child, "jcr:primaryType", type, Type.NAME);
        return child;
    }

    private <T> void ensureProperty(NodeBuilder node, String propertyName, T value, Type<T> type) {
        node.setProperty(propertyName, value, type);
    }
}

