/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal;

import java.util.Optional;
import javax.script.Bindings;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.ComponentConfiguration;
import org.apache.sling.cms.Page;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={BindingsValuesProvider.class}, property={"service.ranking=100"})
public class DefaultScriptBindingsValueProvider
implements BindingsValuesProvider {
    public static final String PN_CURRENT_PAGE = "currentPage";

    public void addBindings(Bindings bindings) {
        Resource resource = (Resource)bindings.get("resource");
        bindings.put("properties", (Object)resource.getValueMap());
        Optional.ofNullable((ComponentConfiguration)resource.adaptTo(ComponentConfiguration.class)).map(ComponentConfiguration::getProperties).ifPresent(p -> bindings.put("componentConfiguration", p));
        Resource publishableParent = CMSUtils.findPublishableParent((Resource)resource);
        if (publishableParent != null && "sling:Page".equals(publishableParent.getResourceType())) {
            Optional.of((Page)publishableParent.adaptTo(Page.class)).ifPresent(p -> {
                bindings.put("page", p);
                ServletRequest request = (ServletRequest)bindings.get("request");
                if (request.getAttribute(PN_CURRENT_PAGE) == null) {
                    request.setAttribute(PN_CURRENT_PAGE, p);
                    bindings.put(PN_CURRENT_PAGE, p);
                } else {
                    bindings.put(PN_CURRENT_PAGE, request.getAttribute(PN_CURRENT_PAGE));
                }
            });
        }
    }
}

