/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.File;
import org.apache.sling.cms.FileMetadataExtractor;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Component(service={FileMetadataExtractor.class})
public class FileMetadataExtractorImpl
implements FileMetadataExtractor {
    private static final Logger log = LoggerFactory.getLogger(FileMetadataExtractorImpl.class);

    public Map<String, Object> extractMetadata(File file) throws IOException {
        try {
            return this.extractMetadata(file.getResource());
        }
        catch (TikaException | SAXException e) {
            throw new IOException("Failed to parse metadata", e);
        }
    }

    public void updateMetadata(File file) throws IOException {
        this.updateMetadata(file, true);
    }

    public void updateMetadata(File file, boolean persist) throws IOException {
        log.trace("Updating metadata for {}, persist {}", (Object)file, (Object)persist);
        try {
            Resource resource = file.getResource();
            Resource content = resource.getChild("jcr:content");
            if (content == null) {
                log.warn("Content resource is null");
                return;
            }
            Map<String, Object> properties = null;
            Resource metadata = content.getChild("metadata");
            if (metadata != null) {
                properties = (Map)metadata.adaptTo(ModifiableValueMap.class);
            } else {
                properties = new HashMap();
                properties.put("jcr:primaryType", "nt:unstructured");
            }
            if (properties != null) {
                properties.putAll(this.extractMetadata(file.getResource()));
                if (metadata == null) {
                    resource.getResourceResolver().create(content, "metadata", properties);
                }
                if (persist) {
                    resource.getResourceResolver().commit();
                }
            } else {
                throw new IOException("Unable to update metadata for " + resource.getPath());
            }
            log.info("Metadata extracted from {}", (Object)resource.getPath());
        }
        catch (TikaException | SAXException e) {
            throw new IOException("Failed to parse metadata", e);
        }
    }

    public Map<String, Object> extractMetadata(Resource resource) throws IOException, SAXException, TikaException {
        log.info("Extracting metadata from {}", (Object)resource.getPath());
        InputStream is = (InputStream)resource.adaptTo(InputStream.class);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        AutoDetectParser parser = new AutoDetectParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata md = new Metadata();
        ParseContext context = new ParseContext();
        parser.parse(is, (ContentHandler)handler, md, context);
        for (String name : md.names()) {
            this.putMetadata(properties, name, md);
        }
        return properties;
    }

    private void putMetadata(Map<String, Object> properties, String name, Metadata metadata) {
        log.trace("Updating property: {}", (Object)name);
        String filtered = Text.escapeIllegalJcrChars((String)name);
        Property property = Property.get((String)name);
        if (property != null) {
            if (metadata.isMultiValued(property)) {
                properties.put(filtered, metadata.getValues(property));
            } else if (metadata.getDate(property) != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(metadata.getDate(property));
                properties.put(filtered, cal);
            } else if (metadata.getInt(property) != null) {
                properties.put(filtered, metadata.getInt(property));
            } else {
                properties.put(filtered, metadata.get(property));
            }
        } else {
            properties.put(filtered, metadata.get(name));
        }
    }
}

