/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.caconfig.management.ConfigurationCollectionData;
import org.apache.sling.caconfig.management.ConfigurationData;
import org.apache.sling.caconfig.management.ConfigurationManagementSettings;
import org.apache.sling.caconfig.management.impl.PropertiesFilterUtil;
import org.jetbrains.annotations.NotNull;

final class ConfigurationCollectionDataImpl
implements ConfigurationCollectionData {
    private final String configName;
    private final Collection<ConfigurationData> items;
    private final String resourcePath;
    private final Map<String, Object> properties;
    private final ConfigurationManagementSettings configurationManagementSettings;
    private Map<String, Object> filteredPropertiesCache;

    public ConfigurationCollectionDataImpl(String configName, Collection<ConfigurationData> items, String resourcePath, Map<String, Object> properties, ConfigurationManagementSettings configurationManagementSettings) {
        this.configName = configName;
        this.items = items;
        this.resourcePath = resourcePath;
        this.properties = properties;
        this.configurationManagementSettings = configurationManagementSettings;
    }

    @Override
    @NotNull
    public String getConfigName() {
        return this.configName;
    }

    @Override
    @NotNull
    public Collection<ConfigurationData> getItems() {
        return this.items;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    @NotNull
    public Map<String, Object> getProperties() {
        if (this.filteredPropertiesCache == null) {
            this.filteredPropertiesCache = new HashMap<String, Object>();
            if (this.properties != null) {
                this.filteredPropertiesCache.putAll(this.properties);
                PropertiesFilterUtil.removeIgnoredProperties(this.filteredPropertiesCache, this.configurationManagementSettings);
            } else {
                this.filteredPropertiesCache.put("sling:configCollectionInherit", true);
            }
        }
        return this.filteredPropertiesCache;
    }
}

