/*
 * Decompiled with CFR 0.152.
 */
package caconfigimpl.org.apache.sling.commons.osgi;

import aQute.bnd.annotation.ConsumerType;
import aQute.bnd.annotation.ProviderType;
import caconfigimpl.org.apache.sling.commons.osgi.Order;
import caconfigimpl.org.apache.sling.commons.osgi.ServiceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@ProviderType
public final class RankedServices<T>
implements Iterable<T> {
    private final ChangeListener changeListener;
    private final SortedMap<Comparable<Object>, T> serviceMap = new TreeMap<Comparable<Object>, T>();
    private volatile List<T> sortedServices = Collections.emptyList();
    private final Order order;

    @Deprecated
    public RankedServices() {
        this(Order.ASCENDING, null);
    }

    @Deprecated
    public RankedServices(ChangeListener changeListener) {
        this(Order.ASCENDING, changeListener);
    }

    public RankedServices(Order order) {
        this(order, null);
    }

    public RankedServices(Order order, ChangeListener changeListener) {
        this.order = order;
        this.changeListener = changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(T service, Map<String, Object> props) {
        SortedMap<Comparable<Object>, T> sortedMap = this.serviceMap;
        synchronized (sortedMap) {
            this.serviceMap.put(ServiceUtil.getComparableForServiceRanking(props, this.order), service);
            this.updateSortedServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(T service, Map<String, Object> props) {
        SortedMap<Comparable<Object>, T> sortedMap = this.serviceMap;
        synchronized (sortedMap) {
            this.serviceMap.remove(ServiceUtil.getComparableForServiceRanking(props, this.order));
            this.updateSortedServices();
        }
    }

    private void updateSortedServices() {
        ArrayList<T> copiedList = new ArrayList<T>(this.serviceMap.values());
        this.sortedServices = Collections.unmodifiableList(copiedList);
        if (this.changeListener != null) {
            this.changeListener.changed();
        }
    }

    public Collection<T> get() {
        return this.sortedServices;
    }

    public List<T> getList() {
        return this.sortedServices;
    }

    @Override
    public Iterator<T> iterator() {
        return this.sortedServices.iterator();
    }

    @ConsumerType
    public static interface ChangeListener {
        public void changed();
    }
}

