/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.override;

import caconfigimpl.org.apache.sling.commons.osgi.Order;
import caconfigimpl.org.apache.sling.commons.osgi.RankedServices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.caconfig.impl.ConfigurationResourceWrapper;
import org.apache.sling.caconfig.impl.override.OverrideItem;
import org.apache.sling.caconfig.impl.override.OverrideStringParser;
import org.apache.sling.caconfig.management.multiplexer.ConfigurationOverrideMultiplexer;
import org.apache.sling.caconfig.resource.impl.util.MapUtil;
import org.apache.sling.caconfig.spi.ConfigurationOverrideProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ConfigurationOverrideMultiplexer.class}, reference={@Reference(name="configurationOverrideProvider", service=ConfigurationOverrideProvider.class, bind="bindConfigurationOverrideProvider", unbind="unbindConfigurationOverrideProvider", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)})
public class ConfigurationOverrideMultiplexerImpl
implements ConfigurationOverrideMultiplexer,
RankedServices.ChangeListener {
    private RankedServices<ConfigurationOverrideProvider> items = new RankedServices(Order.DESCENDING, this);
    private volatile Collection<OverrideItem> allOverrides = Collections.emptyList();
    private static final Logger log = LoggerFactory.getLogger(ConfigurationOverrideMultiplexerImpl.class);

    protected void bindConfigurationOverrideProvider(ConfigurationOverrideProvider item, Map<String, Object> props) {
        this.items.bind(item, props);
    }

    protected void unbindConfigurationOverrideProvider(ConfigurationOverrideProvider item, Map<String, Object> props) {
        this.items.unbind(item, props);
    }

    @Override
    public boolean isAllOverridden(@NotNull String contextPath, @NotNull String configName) {
        for (OverrideItem override : this.allOverrides) {
            if (!StringUtils.equals((CharSequence)configName, (CharSequence)override.getConfigName()) || !override.matchesPath(contextPath) || !override.isAllProperties()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> overrideProperties(@NotNull String contextPath, @NotNull String configName, @NotNull Map<String, Object> properties) {
        if (this.allOverrides.size() == 0) {
            return null;
        }
        boolean anyMatch = false;
        HashMap<String, Object> overrideProperties = new HashMap<String, Object>(properties);
        for (OverrideItem override : this.allOverrides) {
            if (!StringUtils.equals((CharSequence)configName, (CharSequence)override.getConfigName()) || !override.matchesPath(contextPath)) continue;
            if (override.isAllProperties()) {
                overrideProperties.clear();
            }
            overrideProperties.putAll(override.getProperties());
            anyMatch = true;
        }
        if (anyMatch) {
            return overrideProperties;
        }
        return null;
    }

    @Override
    public Resource overrideProperties(@NotNull String contextPath, @NotNull String configName, @Nullable Resource configResource) {
        if (configResource == null) {
            return null;
        }
        return this.overrideProperties(contextPath, configName, configResource, configResource.getResourceResolver());
    }

    @Override
    public Resource overrideProperties(@NotNull String contextPath, @NotNull String configName, @Nullable Resource configResource, @NotNull ResourceResolver resourceResolver) {
        Map<String, Object> overrideProperties = this.overrideProperties(contextPath, configName, (Map<String, Object>)(configResource != null ? configResource.getValueMap() : ValueMap.EMPTY));
        if (overrideProperties == null) {
            return configResource;
        }
        Resource configResourceToUse = configResource;
        if (configResourceToUse == null) {
            configResourceToUse = new SyntheticResource(resourceResolver, (String)null, (String)null);
        }
        if (log.isTraceEnabled()) {
            log.trace("! Override properties for context path " + contextPath + ", name '" + configName + "', " + (configResource != null ? "config path " + configResource.getPath() : "no config path") + ": " + (configResource != null ? MapUtil.traceOutput((Map<String, Object>)configResource.getValueMap()) : "empty") + " -> " + MapUtil.traceOutput(overrideProperties));
        }
        return new ConfigurationResourceWrapper(configResourceToUse, (ValueMap)new ValueMapDecorator(overrideProperties));
    }

    @Override
    public void changed() {
        ArrayList<OverrideItem> overrides = new ArrayList<OverrideItem>();
        for (ConfigurationOverrideProvider item : this.items) {
            Collection<OverrideItem> itemOverrides = OverrideStringParser.parse(item.getOverrideStrings());
            if (log.isDebugEnabled() && !itemOverrides.isEmpty()) {
                log.debug("Override items from " + item.getClass().getName() + ":\n" + StringUtils.join(itemOverrides, (String)"\n"));
            }
            overrides.addAll(itemOverrides);
        }
        this.allOverrides = overrides;
    }
}

