/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.support;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.OAuthTokenAccess;
import org.apache.sling.auth.oauth_client.OAuthTokenResponse;
import org.apache.sling.auth.oauth_client.impl.OAuthToken;
import org.apache.sling.auth.oauth_client.impl.TokenState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OAuthEnabledSlingServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ClientConnection connection;
    private final OAuthTokenAccess tokenAccess;

    protected OAuthEnabledSlingServlet(ClientConnection connection, OAuthTokenAccess tokenAccess) {
        this.connection = Objects.requireNonNull(connection, "connection may not null");
        this.tokenAccess = Objects.requireNonNull(tokenAccess, "tokenAccess may not null");
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleRequestWithToken(request, response, "GET");
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleRequestWithToken(request, response, "POST");
    }

    protected void doDelete(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleRequestWithToken(request, response, "DELETE");
    }

    protected void doPut(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleRequestWithToken(request, response, "PUT");
    }

    protected void doGeneric(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        this.handleRequestWithToken(request, response, request.getMethod());
    }

    private void handleRequestWithToken(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, String method) throws ServletException, IOException {
        OAuthTokenResponse tokenResponse;
        if (request.getRemoteUser() == null) {
            response.sendError(401, "User is not authenticated");
            return;
        }
        String redirectPath = Objects.requireNonNull(this.getRedirectPath(request), "getRedirectPath() may not return null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configured with connection (name={}) and redirectPath={}", (Object)this.connection.name(), (Object)redirectPath);
        }
        if ((tokenResponse = this.tokenAccess.getAccessToken(this.connection, request, redirectPath)).hasValidToken()) {
            OAuthToken token = new OAuthToken(TokenState.VALID, tokenResponse.getTokenValue());
            try {
                switch (method) {
                    case "GET": {
                        this.doGetWithToken(request, response, token.getValue());
                        break;
                    }
                    case "POST": {
                        this.doPostWithToken(request, response, token.getValue());
                        break;
                    }
                    case "PUT": {
                        this.doPutWithToken(request, response, token.getValue());
                        break;
                    }
                    case "DELETE": {
                        this.doDeleteWithToken(request, response, token.getValue());
                        break;
                    }
                    default: {
                        this.doGenericWithToken(request, response, token.getValue());
                        break;
                    }
                }
            }
            catch (IOException | ServletException e) {
                if (this.isInvalidAccessTokenException((Exception)e)) {
                    this.logger.warn("Invalid access token, clearing exiting token and restarting OAuth flow", e);
                    OAuthTokenResponse newTokenResponse = this.tokenAccess.clearAccessToken(this.connection, request, redirectPath);
                    response.sendRedirect(newTokenResponse.getRedirectUri().toString());
                }
                throw e;
            }
        } else {
            response.sendRedirect(tokenResponse.getRedirectUri().toString());
        }
    }

    @NotNull
    protected String getRedirectPath(@NotNull SlingHttpServletRequest request) {
        return request.getRequestURI();
    }

    protected void doGetWithToken(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, String accessToken) throws IOException, ServletException {
        this.handleMethodNotImplemented(request, response);
    }

    protected void doPostWithToken(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, String accessToken) throws IOException, ServletException {
        this.handleMethodNotImplemented(request, response);
    }

    protected void doPutWithToken(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, String accessToken) throws IOException, ServletException {
        this.handleMethodNotImplemented(request, response);
    }

    protected void doDeleteWithToken(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, String accessToken) throws IOException, ServletException {
        this.handleMethodNotImplemented(request, response);
    }

    protected void doGenericWithToken(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, String accessToken) throws IOException, ServletException {
        this.handleMethodNotImplemented(request, response);
    }

    protected boolean isInvalidAccessTokenException(Exception e) {
        return false;
    }
}

