/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.Converter;
import org.apache.sling.auth.oauth_client.impl.OAuthCallbackException;
import org.apache.sling.auth.oauth_client.impl.OAuthState;
import org.apache.sling.auth.oauth_client.impl.OAuthStateManager;
import org.apache.sling.auth.oauth_client.impl.OAuthTokenStore;
import org.apache.sling.auth.oauth_client.impl.OAuthTokens;
import org.apache.sling.auth.oauth_client.impl.ResolvedOAuthConnection;
import org.apache.sling.servlets.annotations.SlingServletPaths;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.auth.requirements=/system/sling/oauth/callback"})
@SlingServletPaths(value={"/system/sling/oauth/callback"})
public class OAuthCallbackServlet
extends SlingAllMethodsServlet {
    static final String PATH = "/system/sling/oauth/callback";
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<String, ClientConnection> connections;
    private final OAuthTokenStore tokenStore;
    private final OAuthStateManager stateManager;

    static String getCallbackUri(HttpServletRequest request) {
        boolean isNonDefaultHttpsPort;
        Object portFragment = "";
        boolean isNonDefaultHttpPort = request.getScheme().equals("http") && request.getServerPort() != 80;
        boolean bl = isNonDefaultHttpsPort = request.getScheme().equals("https") && request.getServerPort() != 443;
        if (isNonDefaultHttpPort || isNonDefaultHttpsPort) {
            portFragment = ":" + request.getServerPort();
        }
        return request.getScheme() + "://" + request.getServerName() + (String)portFragment + PATH;
    }

    private static String toErrorMessage(String context, ErrorResponse error) {
        ErrorObject errorObject = error.getErrorObject();
        StringBuilder message = new StringBuilder();
        message.append(context).append(": ").append(errorObject.getCode());
        message.append(". Status code: ").append(errorObject.getHTTPStatusCode());
        String description = errorObject.getDescription();
        if (description != null) {
            message.append(". ").append(description);
        }
        return message.toString();
    }

    @Activate
    public OAuthCallbackServlet(@Reference(policyOption=ReferencePolicyOption.GREEDY) List<ClientConnection> connections, @Reference OAuthTokenStore tokenStore, @Reference OAuthStateManager stateManager) {
        this.connections = connections.stream().collect(Collectors.toMap(ClientConnection::name, Function.identity()));
        this.tokenStore = tokenStore;
        this.stateManager = stateManager;
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Cookie stateCookie;
        Optional<OAuthState> clientState;
        AuthorizationResponse authResponse;
        StringBuffer requestURL = request.getRequestURL();
        if (request.getQueryString() != null) {
            requestURL.append('?').append(request.getQueryString());
        }
        try {
            authResponse = AuthorizationResponse.parse((URI)new URI(requestURL.toString()));
            clientState = this.stateManager.toOAuthState(authResponse.getState());
            if (!clientState.isPresent()) {
                this.logger.debug("Failed state check: no state found in authorization response");
                response.setStatus(400);
                return;
            }
            stateCookie = request.getCookie("sling.oauth-request-key");
            if (stateCookie == null) {
                this.logger.debug("Failed state check: No request cookie named '{}' found", (Object)"sling.oauth-request-key");
                response.setStatus(400);
                return;
            }
        }
        catch (ParseException | URISyntaxException e) {
            this.logger.debug("Failed to parse authorization response", e);
            response.setStatus(400);
            return;
        }
        try {
            String stateFromAuthServer = clientState.get().perRequestKey();
            String stateFromClient = stateCookie.getValue();
            if (!stateFromAuthServer.equals(stateFromClient)) {
                throw new IllegalStateException("Failed state check: request keys from client and server are not the same");
            }
            if (!authResponse.indicatesSuccess()) {
                AuthorizationErrorResponse errorResponse = authResponse.toErrorResponse();
                throw new OAuthCallbackException("Authentication failed", new RuntimeException(OAuthCallbackServlet.toErrorMessage("Error in authentication response", (ErrorResponse)errorResponse)));
            }
            Optional<String> redirect = Optional.ofNullable(clientState.get().redirect());
            String authCode = authResponse.toSuccessResponse().getAuthorizationCode().getValue();
            String desiredConnectionName = clientState.get().connectionName();
            if (desiredConnectionName == null || desiredConnectionName.isEmpty()) {
                throw new IllegalArgumentException("No connection found in clientState");
            }
            ClientConnection connection = this.connections.get(desiredConnectionName);
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Requested unknown connection '%s'", desiredConnectionName));
            }
            ResolvedOAuthConnection conn = ResolvedOAuthConnection.resolve(connection);
            ClientID clientId = new ClientID(conn.clientId());
            Secret clientSecret = new Secret(conn.clientSecret());
            ClientSecretBasic clientCredentials = new ClientSecretBasic(clientId, clientSecret);
            AuthorizationCode code = new AuthorizationCode(authCode);
            URI tokenEndpoint = new URI(conn.tokenEndpoint());
            TokenRequest tokenRequest = new TokenRequest.Builder(tokenEndpoint, (ClientAuthentication)clientCredentials, (AuthorizationGrant)new AuthorizationCodeGrant(code, new URI(OAuthCallbackServlet.getCallbackUri((HttpServletRequest)request)))).build();
            HTTPRequest httpRequest = tokenRequest.toHTTPRequest();
            httpRequest.setAccept("application/json");
            HTTPResponse httpResponse = httpRequest.send();
            TokenResponse tokenResponse = TokenResponse.parse((HTTPResponse)httpResponse);
            if (!tokenResponse.indicatesSuccess()) {
                throw new OAuthCallbackException("Token exchange error", new RuntimeException(OAuthCallbackServlet.toErrorMessage("Error in token response", (ErrorResponse)tokenResponse.toErrorResponse())));
            }
            OAuthTokens tokens = Converter.toSlingOAuthTokens(tokenResponse.toSuccessResponse().getTokens());
            this.tokenStore.persistTokens(connection, request.getResourceResolver(), tokens);
            if (redirect.isEmpty()) {
                response.setStatus(204);
            } else {
                response.sendRedirect(URLDecoder.decode(redirect.get(), StandardCharsets.UTF_8));
            }
        }
        catch (IllegalStateException e) {
            throw new OAuthCallbackException("State check failed", e);
        }
        catch (IllegalArgumentException e) {
            throw new OAuthCallbackException("Internal error", e);
        }
        catch (ParseException e) {
            throw new OAuthCallbackException("Invalid invocation", e);
        }
        catch (OAuthCallbackException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAuthCallbackException("Unknown error", e);
        }
    }
}

