/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client;

import java.net.URI;
import java.util.Optional;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.auth.oauth_client.ClientConnection;
import org.apache.sling.auth.oauth_client.impl.OAuthUris;
import org.jetbrains.annotations.NotNull;

@NotNull
public class OAuthTokenResponse {
    private final Optional<String> token;
    private final ClientConnection connection;
    private final SlingHttpServletRequest request;
    private String redirectPath;

    public OAuthTokenResponse(Optional<String> token, ClientConnection connection, SlingHttpServletRequest request, String redirectPath) {
        this.token = token;
        this.connection = connection;
        this.request = request;
        this.redirectPath = redirectPath;
    }

    public boolean hasValidToken() {
        return this.token.isPresent();
    }

    public String getTokenValue() {
        return this.token.orElseThrow(() -> new IllegalStateException("No access token present."));
    }

    public URI getRedirectUri() {
        if (this.token.isPresent()) {
            throw new IllegalStateException("Access token is present, will not generate a new redirect URI.");
        }
        return OAuthUris.getOAuthEntryPointUri(this.connection, this.request, this.redirectPath);
    }
}

