/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl.engine;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.auth.core.impl.AbstractAuthenticationHandlerHolder;
import org.apache.sling.auth.core.spi.AuthenticationFeedbackHandler;
import org.apache.sling.engine.auth.AuthenticationHandler;
import org.apache.sling.engine.auth.AuthenticationInfo;
import org.osgi.framework.ServiceReference;

public final class EngineAuthenticationHandlerHolder
extends AbstractAuthenticationHandlerHolder {
    private final AuthenticationHandler handler;

    public EngineAuthenticationHandlerHolder(String fullPath, AuthenticationHandler handler, ServiceReference<?> serviceReference) {
        super(fullPath, serviceReference);
        this.handler = handler;
    }

    @Override
    protected AuthenticationFeedbackHandler getFeedbackHandler() {
        if (this.handler instanceof AuthenticationFeedbackHandler) {
            return (AuthenticationFeedbackHandler)((Object)this.handler);
        }
        return null;
    }

    @Override
    public org.apache.sling.auth.core.spi.AuthenticationInfo doExtractCredentials(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationInfo engineAuthInfo = this.handler.authenticate(request, response);
        if (engineAuthInfo == null) {
            return null;
        }
        if (engineAuthInfo == AuthenticationInfo.DOING_AUTH) {
            return org.apache.sling.auth.core.spi.AuthenticationInfo.DOING_AUTH;
        }
        org.apache.sling.auth.core.spi.AuthenticationInfo info = new org.apache.sling.auth.core.spi.AuthenticationInfo(engineAuthInfo.getAuthType());
        info.put("user.jcr.credentials", (Object)engineAuthInfo.getCredentials());
        info.put("user.jcr.workspace", (Object)engineAuthInfo.getWorkspaceName());
        return info;
    }

    @Override
    public boolean doRequestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.handler.requestAuthentication(request, response);
    }

    @Override
    public void doDropCredentials(HttpServletRequest request, HttpServletResponse response) {
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.handler);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EngineAuthenticationHandlerHolder other = (EngineAuthenticationHandlerHolder)obj;
        return Objects.equals(this.handler, other.handler);
    }

    public String toString() {
        return this.handler.toString() + " (Legacy API Handler)";
    }
}

