/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import org.apache.sling.commons.metrics.Meter;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.commons.metrics.Timer;
import org.jetbrains.annotations.NotNull;

class SlingAuthenticationMetrics {
    static final String AUTHENTICATE_TIMER_NAME = "sling.auth.core.authenticate.timer";
    static final String AUTHENTICATE_SUCCESS_METER_NAME = "sling.auth.core.authenticate.success";
    static final String AUTHENTICATE_FAILED_METER_NAME = "sling.auth.core.authenticate.failed";
    private final Timer authenticateTimer;
    private final Meter authenticateSuccess;
    private final Meter authenticateFailed;

    SlingAuthenticationMetrics(@NotNull MetricsService metricsService) {
        this.authenticateTimer = metricsService.timer(AUTHENTICATE_TIMER_NAME);
        this.authenticateSuccess = metricsService.meter(AUTHENTICATE_SUCCESS_METER_NAME);
        this.authenticateFailed = metricsService.meter(AUTHENTICATE_FAILED_METER_NAME);
    }

    @NotNull
    Timer.Context authenticationTimerContext() {
        return this.authenticateTimer.time();
    }

    void authenticateCompleted(boolean success) {
        if (success) {
            this.authenticateSuccess.mark();
        } else {
            this.authenticateFailed.mark();
        }
    }
}

