/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.header;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public class MediaRangeList
extends TreeSet<MediaRange> {
    public static final String HEADER_ACCEPT = "Accept";
    public static final String PARAM_ACCEPT = ":http-equiv-accept";
    public static final String WILDCARD = "*";
    boolean matchesAll = false;
    private static final Logger log = LoggerFactory.getLogger(MediaRangeList.class);

    public MediaRangeList(HttpServletRequest request) {
        String queryParam = request.getParameter(PARAM_ACCEPT);
        if (queryParam != null && queryParam.trim().length() != 0) {
            this.init(queryParam);
        } else {
            this.init(request.getHeader(HEADER_ACCEPT));
        }
    }

    public MediaRangeList(String listStr) {
        try {
            this.init(listStr);
        }
        catch (Throwable t) {
            log.error("Error building MediaRangeList from '" + listStr + "' - will assume client accepts all media types", t);
            this.init(null);
        }
    }

    private void init(String headerValue) {
        if (headerValue == null || headerValue.trim().length() == 0) {
            this.matchesAll = true;
            this.add(new MediaRange("*/*"));
        } else {
            String[] mediaTypes;
            for (String type : mediaTypes = headerValue.split(",")) {
                try {
                    MediaRange range = new MediaRange(type);
                    this.add(range);
                    if (!range.matchesAll()) continue;
                    this.matchesAll = true;
                }
                catch (Throwable throwable) {
                    log.warn("Error registering media type " + type, throwable);
                }
            }
        }
    }

    public boolean contains(String mediaType) {
        MediaRange comp = new MediaRange(mediaType);
        return this.matchesAll || this.contains(comp);
    }

    public MediaRange prefer(Set<MediaRange> mediaRanges) {
        for (MediaRange range : this) {
            for (MediaRange mediaType : mediaRanges) {
                if (!range.equals(mediaType)) continue;
                return mediaType;
            }
        }
        return null;
    }

    public String prefer(String ... mediaRanges) {
        HashSet<MediaRange> ranges = new HashSet<MediaRange>();
        for (String mediaRange : mediaRanges) {
            ranges.add(new MediaRange(mediaRange));
        }
        MediaRange preferred = this.prefer(ranges);
        return preferred == null ? null : preferred.toString();
    }

    public class MediaRange
    implements Comparable<MediaRange> {
        private String supertype;
        private double q = 1.0;
        private Map<String, String> parameters;
        private String subtype;

        public MediaRange(String exp) {
            String[] parts = exp.split(";");
            this.setType(parts[0].trim());
            if (parts.length > 1) {
                this.parameters = new HashMap<String, String>(parts.length - 1);
            }
            int partsLength = parts.length;
            for (int i = 1; i < partsLength; ++i) {
                String parameter = parts[i];
                String[] keyValue = parameter.split("=");
                if (keyValue[0].equals("q")) {
                    this.q = Double.parseDouble(keyValue[1]);
                    if (this.q < 0.0 || this.q > 1.0) {
                        throw new IllegalArgumentException("Quality factor out of bounds: " + exp);
                    }
                }
                this.parameters.put(keyValue[0], keyValue[1]);
            }
        }

        MediaRange(String supertype, String subtype) {
            this.setType(supertype, subtype);
        }

        public boolean matchesAll() {
            return this.supertype.equals(MediaRangeList.WILDCARD) && this.subtype.equals(MediaRangeList.WILDCARD);
        }

        private void setType(String supertype, String subtype) {
            this.supertype = supertype == null ? MediaRangeList.WILDCARD : supertype;
            String string = this.subtype = subtype == null ? MediaRangeList.WILDCARD : subtype;
            if (this.supertype.equals(MediaRangeList.WILDCARD) && !this.subtype.equals(MediaRangeList.WILDCARD)) {
                throw new IllegalArgumentException("Supertype cannot be wildcard if subtype is not");
            }
        }

        private void setType(String typeDef) {
            String[] parts = typeDef.split("/");
            String superType = parts[0];
            String subType = MediaRangeList.WILDCARD;
            if (parts.length > 1) {
                subType = parts[1];
            }
            this.setType(superType, subType);
        }

        MediaRange(String supertype, String subtype, double q) {
            this(supertype, subtype);
            this.q = q;
        }

        public String getParameter(String key) {
            if (this.parameters != null) {
                return this.parameters.get(key);
            }
            return null;
        }

        public String getSupertype() {
            return this.supertype;
        }

        public String getSubtype() {
            return this.subtype;
        }

        public double getQ() {
            return this.q;
        }

        public Map<String, String> getParameters() {
            return this.parameters != null ? this.parameters : new HashMap(0);
        }

        @Override
        public int compareTo(MediaRange o) {
            double diff = this.q - o.getQ();
            if (diff == 0.0) {
                int paramDiff = o.getParameters().size() - this.getParameters().size();
                if (paramDiff != 0) {
                    return paramDiff;
                }
                if (this.supertype.equals(MediaRangeList.WILDCARD) && !o.getSupertype().equals(MediaRangeList.WILDCARD)) {
                    return 1;
                }
                if (!this.supertype.equals(MediaRangeList.WILDCARD) && o.getSupertype().equals(MediaRangeList.WILDCARD)) {
                    return -1;
                }
                if (this.subtype.equals(MediaRangeList.WILDCARD) && !o.getSubtype().equals(MediaRangeList.WILDCARD)) {
                    return 1;
                }
                if (!this.subtype.equals(MediaRangeList.WILDCARD) && o.getSubtype().equals(MediaRangeList.WILDCARD)) {
                    return -1;
                }
                return this.toString().compareTo(o.toString());
            }
            return diff > 0.0 ? -1 : 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MediaRange) {
                MediaRange mr = (MediaRange)obj;
                return mr.getSupertype().equals(this.supertype) && mr.getSubtype().equals(this.subtype);
            }
            return super.equals(obj);
        }

        public boolean equals(String s) {
            return (this.supertype + "/" + this.subtype).equals(s);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.supertype);
            buf.append('/');
            buf.append(this.subtype);
            if (this.parameters != null) {
                String delimiter = ";";
                for (String key : this.parameters.keySet()) {
                    buf.append(delimiter);
                    buf.append(key).append("=").append(this.parameters.get(key));
                }
            }
            return buf.toString();
        }
    }
}

