/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder;

import java.nio.charset.Charset;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.builder.SlingHttpServletRequestBuilder;
import org.apache.sling.api.request.builder.SlingHttpServletResponseBuilder;
import org.apache.sling.api.request.builder.impl.RequestParameterImpl;
import org.apache.sling.api.request.builder.impl.RequestProgressTrackerImpl;
import org.apache.sling.api.request.builder.impl.SlingHttpServletRequestImpl;
import org.apache.sling.api.request.builder.impl.SlingHttpServletResponseImpl;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

public final class Builders {
    private Builders() {
    }

    @NotNull
    public static SlingHttpServletRequestBuilder newRequestBuilder(@NotNull Resource resource) {
        return new SlingHttpServletRequestImpl(resource);
    }

    @NotNull
    public static SlingHttpServletResponseBuilder newResponseBuilder() {
        return new SlingHttpServletResponseImpl();
    }

    @NotNull
    public static RequestProgressTracker newRequestProgressTracker() {
        return new RequestProgressTrackerImpl();
    }

    @NotNull
    public static RequestParameter newRequestParameter(String name, String value) {
        return new RequestParameterImpl(name, value);
    }

    @NotNull
    public static RequestParameter newRequestParameter(String name, String value, Charset encoding) {
        return new RequestParameterImpl(name, value, encoding);
    }
}

