/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.sling.api.request.RequestParameter;

public class RequestParameterImpl
implements RequestParameter {
    private static final String CONTENT_TYPE = "text/plain";
    private final String name;
    private final String value;
    private final Charset encoding;

    public RequestParameterImpl(String name, String value) {
        this(name, value, StandardCharsets.UTF_8);
    }

    public RequestParameterImpl(String name, String value, Charset encoding) {
        this.name = name;
        this.value = value;
        this.encoding = encoding;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] get() {
        return this.value.getBytes(this.encoding);
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.get());
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public long getSize() {
        return this.get().length;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    @Override
    public boolean isFormField() {
        return true;
    }

    public String toString() {
        return this.getString();
    }
}

