/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.request.builder.SlingHttpServletRequestBuilder;
import org.apache.sling.api.request.builder.impl.HeaderSupport;
import org.apache.sling.api.request.builder.impl.HttpSessionImpl;
import org.apache.sling.api.request.builder.impl.RequestParameterMapImpl;
import org.apache.sling.api.request.builder.impl.ServletContextImpl;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.uri.SlingUriBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlingHttpServletRequestImpl
extends SlingAdaptable
implements SlingHttpServletRequest,
SlingHttpServletRequestBuilder {
    private static final String DEFAULT_METHOD = "GET";
    private static final String SECURE_PROTOCOL = "https";
    private static final String HTTP_PROTOCOL = "http";
    static final String CHARSET_SEPARATOR = ";charset=";
    private static final ResourceBundle EMPTY_RESOURCE_BUNDLE = new ListResourceBundle(){

        @Override
        protected Object[][] getContents() {
            return new Object[0][0];
        }
    };
    private static final String REQUEST = "request";
    private final Resource resource;
    private String[] selectors;
    private String extension;
    private String suffix;
    private String requestMethod = "GET";
    private String contentType;
    private String characterEncoding;
    private String body;
    private boolean locked = false;
    private final Map<String, String[]> parameters = new LinkedHashMap<String, String[]>();
    private RequestPathInfo requestPathInfo;
    private String queryString;
    private String pathInfo;
    private final Map<String, Object> attributeMap = new HashMap<String, Object>();
    private HttpSession session;
    private RequestParameterMap requestParameterMap;
    private final HeaderSupport headerSupport = new HeaderSupport();
    private final Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
    private RequestProgressTracker progressTracker;
    private HttpServletRequest sessionProvider;
    private HttpServletRequest attributesProvider;
    private ServletContext servletContext;
    private SlingHttpServletRequest requestDispatcherProvider;
    private boolean getInputStreamCalled;
    private boolean getReaderCalled;
    private final Locale locale = Locale.US;
    private final String contextPath = "";
    private final String scheme = "http";
    private final String serverName = "localhost";
    private final int serverPort = 80;
    private String authType;
    private String remoteUser;
    private String remoteAddr;
    private String remoteHost;
    private int remotePort;
    private String servletPath = "";
    private String responseContentType;

    public SlingHttpServletRequestImpl(@NotNull Resource resource) {
        this.checkNotNull("resource", resource);
        this.resource = resource;
    }

    private void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("The builder can't be reused. Create a new builder instead.");
        }
    }

    private void checkNotNull(String info, Object candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(info.concat(" is null"));
        }
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withRequestMethod(@NotNull String method) {
        this.checkLocked();
        this.checkNotNull("method", method);
        this.requestMethod = method.toUpperCase();
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withContentType(@Nullable String type) {
        int pos;
        this.checkLocked();
        int n = pos = type == null ? -1 : type.indexOf(CHARSET_SEPARATOR);
        if (pos != -1) {
            this.contentType = type.substring(0, pos);
            this.characterEncoding = type.substring(pos + CHARSET_SEPARATOR.length());
        } else {
            this.contentType = type;
        }
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withBody(@Nullable String content) {
        this.checkLocked();
        this.body = content;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withSelectors(String ... selectors) {
        this.checkLocked();
        this.selectors = selectors;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withExtension(String extension) {
        this.checkLocked();
        this.extension = extension;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withSuffix(String suffix) {
        this.checkLocked();
        this.suffix = suffix;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withParameter(@NotNull String key, @NotNull String value) {
        this.checkLocked();
        this.checkNotNull("key", key);
        this.checkNotNull("value", value);
        this.parameters.put(key, new String[]{value});
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withParameter(@NotNull String key, @NotNull String[] values) {
        this.checkLocked();
        this.checkNotNull("key", key);
        this.checkNotNull("values", values);
        this.parameters.put(key, values);
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withParameters(@Nullable Map<String, String[]> parameters) {
        this.checkLocked();
        if (parameters != null) {
            this.parameters.putAll(parameters);
        }
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useAttributesFrom(@NotNull HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.attributesProvider = request;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useServletContextFrom(@NotNull HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.servletContext = request.getServletContext();
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useSessionFrom(@NotNull HttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.sessionProvider = request;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder useRequestDispatcherFrom(@NotNull SlingHttpServletRequest request) {
        this.checkLocked();
        this.checkNotNull(REQUEST, request);
        this.requestDispatcherProvider = request;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequestBuilder withRequestProgressTracker(@NotNull RequestProgressTracker tracker) {
        this.progressTracker = tracker;
        return this;
    }

    @Override
    @NotNull
    public SlingHttpServletRequest build() {
        this.checkLocked();
        this.locked = true;
        this.requestPathInfo = SlingUriBuilder.createFrom(this.resource).setExtension(this.extension).setSuffix(this.suffix).setSelectors(this.selectors).build();
        this.queryString = this.formatQueryString();
        this.pathInfo = this.buildPathInfo();
        if (this.servletContext == null) {
            this.servletContext = new ServletContextImpl();
        }
        if (this.body == null) {
            this.body = "";
        }
        if (this.progressTracker == null) {
            Object attrTracker = this.getAttribute(RequestProgressTracker.class.getName());
            this.progressTracker = attrTracker instanceof RequestProgressTracker ? (RequestProgressTracker)attrTracker : Builders.newRequestProgressTracker();
        }
        return this;
    }

    private String buildPathInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.requestPathInfo.getResourcePath());
        if (this.requestPathInfo.getSelectorString() != null) {
            builder.append('.');
            builder.append(this.requestPathInfo.getSelectorString());
        }
        if (this.requestPathInfo.getExtension() != null) {
            builder.append('.');
            builder.append(this.requestPathInfo.getExtension());
        }
        if (this.requestPathInfo.getSuffix() != null) {
            builder.append(this.requestPathInfo.getSuffix());
        }
        return builder.toString();
    }

    private String formatQueryString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.getParameterMap().entrySet()) {
            if (entry.getValue() == null) continue;
            SlingHttpServletRequestImpl.formatQueryStringParameter(builder, entry);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    private static String encode(String v) {
        try {
            return URLEncoder.encode(v, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException uee) {
            return v;
        }
    }

    private static void formatQueryStringParameter(StringBuilder builder, Map.Entry<String, String[]> entry) {
        for (String value : entry.getValue()) {
            if (builder.length() != 0) {
                builder.append('&');
            }
            builder.append(SlingHttpServletRequestImpl.encode(entry.getKey()));
            builder.append('=');
            if (value == null) continue;
            builder.append(SlingHttpServletRequestImpl.encode(value));
        }
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.getResource().getResourceResolver();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = this.sessionProvider != null ? this.sessionProvider.getSession(create) : new HttpSessionImpl(this.servletContext);
        }
        return this.session;
    }

    @Override
    public RequestPathInfo getRequestPathInfo() {
        return this.requestPathInfo;
    }

    public Object getAttribute(String name) {
        if (this.attributesProvider != null) {
            return this.attributesProvider.getAttribute(name);
        }
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.attributesProvider != null) {
            return this.attributesProvider.getAttributeNames();
        }
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public void removeAttribute(String name) {
        if (this.attributesProvider != null) {
            this.attributesProvider.removeAttribute(name);
        } else {
            this.attributeMap.remove(name);
        }
    }

    public void setAttribute(String name, Object object) {
        if (this.attributesProvider != null) {
            this.attributesProvider.setAttribute(name, object);
        } else {
            this.attributeMap.put(name, object);
        }
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public RequestParameter getRequestParameter(String name) {
        return this.getRequestParameterMap().getValue(name);
    }

    @Override
    public RequestParameterMap getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new RequestParameterMapImpl(this.parameters);
        }
        return this.requestParameterMap;
    }

    @Override
    public RequestParameter[] getRequestParameters(String name) {
        return (RequestParameter[])this.getRequestParameterMap().get(name);
    }

    @Override
    public List<RequestParameter> getRequestParameterList() {
        ArrayList<RequestParameter> params = new ArrayList<RequestParameter>();
        for (RequestParameter[] requestParameters : this.getRequestParameterMap().values()) {
            params.addAll(Arrays.asList(requestParameters));
        }
        return params;
    }

    public Collection<Part> getParts() {
        return Collections.emptyList();
    }

    public Part getPart(String name) {
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Collections.singleton(this.getLocale()));
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isSecure() {
        return SECURE_PROTOCOL.equals(this.scheme);
    }

    public String getMethod() {
        return this.requestMethod;
    }

    public long getDateHeader(String name) {
        return this.headerSupport.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.headerSupport.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerSupport.getHeaderNames());
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration(this.headerSupport.getHeaders(name));
    }

    public int getIntHeader(String name) {
        return this.headerSupport.getIntHeader(name);
    }

    @Override
    public Cookie getCookie(String name) {
        return this.cookies.get(name);
    }

    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        return this.cookies.values().toArray(new Cookie[this.cookies.size()]);
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    @Override
    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return EMPTY_RESOURCE_BUNDLE;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.characterEncoding = encoding;
    }

    public String getContentType() {
        if (this.contentType == null) {
            return null;
        }
        if (this.characterEncoding == null) {
            return this.contentType;
        }
        return this.contentType.concat(CHARSET_SEPARATOR).concat(this.characterEncoding);
    }

    public ServletInputStream getInputStream() {
        if (this.getReaderCalled) {
            throw new IllegalStateException();
        }
        this.getInputStreamCalled = true;
        return new ServletInputStream(){
            private final InputStream is;
            {
                this.is = new ByteArrayInputStream(SlingHttpServletRequestImpl.this.body.getBytes(StandardCharsets.UTF_8));
            }

            public int read() throws IOException {
                return this.is.read();
            }

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                throw new UnsupportedOperationException();
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public BufferedReader getReader() {
        if (this.getInputStreamCalled) {
            throw new IllegalStateException();
        }
        this.getReaderCalled = true;
        return new BufferedReader(new StringReader(this.body));
    }

    public int getContentLength() {
        return this.body.length();
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.requestDispatcherProvider != null) {
            return this.requestDispatcherProvider.getRequestDispatcher(path);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path, RequestDispatcherOptions options) {
        if (this.requestDispatcherProvider != null) {
            return this.requestDispatcherProvider.getRequestDispatcher(path, options);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(Resource resource) {
        if (this.requestDispatcherProvider != null) {
            return this.requestDispatcherProvider.getRequestDispatcher(resource);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
        if (this.requestDispatcherProvider != null) {
            return this.requestDispatcherProvider.getRequestDispatcher(resource, options);
        }
        throw new UnsupportedOperationException();
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getRequestURI() {
        StringBuilder requestUri = new StringBuilder();
        requestUri.append(this.contextPath);
        requestUri.append(this.servletPath);
        requestUri.append(this.pathInfo);
        return requestUri.toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer requestUrl = new StringBuffer();
        requestUrl.append(this.scheme);
        requestUrl.append("://");
        requestUrl.append(this.serverName);
        boolean includePort = true;
        if (HTTP_PROTOCOL.equals(this.scheme) && this.serverPort == 80 || SECURE_PROTOCOL.equals(this.scheme) && this.serverPort == 443) {
            includePort = false;
        }
        if (includePort) {
            requestUrl.append(':');
            requestUrl.append(this.serverPort);
        }
        requestUrl.append(this.getRequestURI());
        return requestUrl;
    }

    public String getAuthType() {
        return this.authType;
    }

    @Override
    public String getResponseContentType() {
        return this.responseContentType;
    }

    @Override
    public Enumeration<String> getResponseContentTypes() {
        return Collections.enumeration(Collections.singleton(this.responseContentType));
    }

    @Override
    public RequestProgressTracker getRequestProgressTracker() {
        return this.progressTracker;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public void login(String pUsername, String password) {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }
}

