/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.api.wrappers;

import java.util.Map;

import org.apache.sling.api.resource.ModifiableValueMap;

/**
 * <code>ModifiableValueMapDecorator</code> decorates another {@link Map}
 * to provide a basic implementation for the additional methods
 * of a {@link ModifiableValueMap}.
 * 
 * @since 2.2 (Sling API Bundle 2.7.0)
 */
public class ModifiableValueMapDecorator
extends ValueMapDecorator
implements ModifiableValueMap {

    /**
     * Creates a new wrapper around a given map.
     * @param base wrapped object
     */
    public ModifiableValueMapDecorator(final Map<String, Object> base) {
        super(base);
    }
}