/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.uri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.uri.SlingUri;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class SlingUriBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SlingUriBuilder.class);
    private static final String HTTPS_SCHEME = "https";
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String HTTP_SCHEME = "http";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final String FILE_SCHEME = "file";
    static final String CHAR_HASH = "#";
    static final String CHAR_QM = "?";
    static final char CHAR_AMP = '&';
    static final char CHAR_AT = '@';
    static final char CHAR_SEMICOLON = ';';
    static final char CHAR_EQUALS = '=';
    static final char CHAR_SINGLEQUOTE = '\'';
    static final String CHAR_COLON = ":";
    static final String CHAR_DOT = ".";
    static final String CHAR_SLASH = "/";
    static final String SELECTOR_DOT_REGEX = "\\.(?!\\.?/)";
    static final String PATH_PARAMETERS_REGEX = ";([a-zA-z0-9]+)=(?:\\'([^']*)\\'|([^/]+))";
    static final String BEST_EFFORT_INVALID_URI_MATCHER = "^(?:([^:#@]+):)?(?://(?:([^@#]+)@)?([^/#:]+)(?::([0-9]+))?)?(?:([^?#]+))?(?:\\?([^#]*))?(?:#(.*))?$";
    private String scheme = null;
    private String userInfo = null;
    private String host = null;
    private int port = -1;
    private String resourcePath = null;
    private final List<String> selectors = new LinkedList<String>();
    private String extension = null;
    private final Map<String, String> pathParameters = new LinkedHashMap<String, String>();
    private String suffix = null;
    private String schemeSpecificPart = null;
    private String query = null;
    private String fragment = null;
    private ResourceResolver resourceResolver = null;
    private boolean isBuilt = false;

    @NotNull
    public static SlingUriBuilder create() {
        return new SlingUriBuilder();
    }

    @NotNull
    public static SlingUriBuilder createFrom(@NotNull SlingUri slingUri) {
        return SlingUriBuilder.create().setScheme(slingUri.getScheme()).setUserInfo(slingUri.getUserInfo()).setHost(slingUri.getHost()).setPort(slingUri.getPort()).setResourcePath(slingUri.getResourcePath()).setPathParameters(slingUri.getPathParameters()).setSelectors(slingUri.getSelectors()).setExtension(slingUri.getExtension()).setSuffix(slingUri.getSuffix()).setQuery(slingUri.getQuery()).setFragment(slingUri.getFragment()).setSchemeSpecificPart(slingUri.isOpaque() ? slingUri.getSchemeSpecificPart() : null).setResourceResolver(slingUri instanceof ImmutableSlingUri ? ((ImmutableSlingUri)((ImmutableSlingUri)slingUri)).getData().resourceResolver : null);
    }

    @NotNull
    public static SlingUriBuilder createFrom(@NotNull Resource resource) {
        return SlingUriBuilder.create().setResourcePath(resource.getPath()).setResourceResolver(resource.getResourceResolver());
    }

    @NotNull
    public static SlingUriBuilder createFrom(@NotNull RequestPathInfo requestPathInfo) {
        Resource suffixResource = requestPathInfo.getSuffixResource();
        return SlingUriBuilder.create().setResourceResolver(suffixResource != null ? suffixResource.getResourceResolver() : null).setResourcePath(requestPathInfo.getResourcePath()).setSelectors(requestPathInfo.getSelectors()).setExtension(requestPathInfo.getExtension()).setSuffix(requestPathInfo.getSuffix());
    }

    @NotNull
    public static SlingUriBuilder createFrom(@NotNull SlingHttpServletRequest request) {
        return SlingUriBuilder.createFrom(request.getRequestPathInfo()).setResourceResolver(request.getResourceResolver()).setScheme(request.getScheme()).setHost(request.getServerName()).setPort(request.getServerPort()).setQuery(request.getQueryString());
    }

    @NotNull
    public static SlingUriBuilder createFrom(@NotNull URI uri, @Nullable ResourceResolver resourceResolver) {
        String path = uri.getRawPath();
        boolean pathExists = SlingUriBuilder.isNotBlank(path);
        String uriQuery = uri.getRawQuery();
        boolean schemeSpecificRelevant = !pathExists && uriQuery == null;
        String uriHost = uri.getHost();
        if (FILE_SCHEME.equals(uri.getScheme()) && uriHost == null) {
            uriHost = "";
        }
        return SlingUriBuilder.create().setResourceResolver(resourceResolver).setScheme(uri.getScheme()).setUserInfo(uri.getRawUserInfo()).setHost(uriHost).setPort(uri.getPort()).setPath(pathExists ? path : null).setQuery(uriQuery).setFragment(uri.getRawFragment()).setSchemeSpecificPart(schemeSpecificRelevant ? uri.getRawSchemeSpecificPart() : null);
    }

    @NotNull
    public static SlingUriBuilder parse(@NotNull String uriStr, @Nullable ResourceResolver resourceResolver) {
        try {
            URI uri = new URI(uriStr);
            return SlingUriBuilder.createFrom(uri, resourceResolver);
        }
        catch (URISyntaxException e) {
            LOG.debug("Invalid URI {}: {}", new Object[]{uriStr, e.getMessage(), e});
            return SlingUriBuilder.parseBestEffort(uriStr, resourceResolver);
        }
    }

    private static SlingUriBuilder parseBestEffort(String uriStr, ResourceResolver resourceResolver) {
        String fragment;
        Matcher matcher = Pattern.compile(BEST_EFFORT_INVALID_URI_MATCHER).matcher(uriStr);
        matcher.find();
        String scheme = matcher.group(1);
        String userInfo = matcher.group(2);
        String host = matcher.group(3);
        String port = matcher.groupCount() >= 4 ? matcher.group(4) : null;
        String path = matcher.groupCount() >= 5 ? matcher.group(5) : null;
        String query = matcher.groupCount() >= 6 ? matcher.group(6) : null;
        String string = fragment = matcher.groupCount() >= 7 ? matcher.group(7) : null;
        if (!SlingUriBuilder.isBlank(scheme) && SlingUriBuilder.isBlank(host)) {
            return SlingUriBuilder.create().setResourceResolver(resourceResolver).setScheme(scheme).setSchemeSpecificPart(path).setFragment(fragment);
        }
        if (!SlingUriBuilder.isBlank(host) || !SlingUriBuilder.isBlank(path)) {
            return SlingUriBuilder.create().setResourceResolver(resourceResolver).setScheme(scheme).setUserInfo(userInfo).setHost(host).setPort(port != null ? Integer.parseInt(port) : -1).setPath(path).setQuery(query).setFragment(fragment);
        }
        return SlingUriBuilder.create().setResourceResolver(resourceResolver).setSchemeSpecificPart(uriStr);
    }

    private static boolean isBlank(CharSequence cs) {
        return cs == null || cs.chars().allMatch(Character::isWhitespace);
    }

    private static boolean isNotBlank(CharSequence cs) {
        return !SlingUriBuilder.isBlank(cs);
    }

    private SlingUriBuilder() {
    }

    @NotNull
    public SlingUriBuilder setUserInfo(@Nullable String userInfo) {
        if (this.schemeSpecificPart != null) {
            return this;
        }
        this.userInfo = userInfo;
        return this;
    }

    @NotNull
    public SlingUriBuilder setHost(@Nullable String host) {
        if (this.schemeSpecificPart != null) {
            return this;
        }
        this.host = host;
        return this;
    }

    @NotNull
    public SlingUriBuilder setPort(int port) {
        if (this.schemeSpecificPart != null) {
            return this;
        }
        this.port = port;
        return this;
    }

    @NotNull
    public SlingUriBuilder setPath(@Nullable String path) {
        Matcher dotMatcher;
        if (this.schemeSpecificPart != null) {
            return this;
        }
        if ((path = this.extractPathParameters(path)) != null && path.startsWith(CHAR_SLASH) && this.resourceResolver != null) {
            this.setResourcePath(path);
            this.rebaseResourcePath();
        } else if (path != null && (dotMatcher = Pattern.compile(SELECTOR_DOT_REGEX).matcher(path)).find()) {
            int firstDotPosition = dotMatcher.start();
            this.setPathWithDefinedResourcePosition(path, firstDotPosition);
        } else {
            this.setSelectors(new String[0]);
            this.setSuffix(null);
            this.setExtension(null);
            this.setResourcePath(path);
        }
        return this;
    }

    @NotNull
    public SlingUriBuilder rebaseResourcePath() {
        if (this.schemeSpecificPart != null || this.resourcePath == null) {
            return this;
        }
        if (this.resourceResolver == null) {
            throw new IllegalStateException("setResourceResolver() needs to be called before balanceResourcePath()");
        }
        String path = this.assemblePath(false);
        if (path == null) {
            return this;
        }
        ResourcePathIterator it = new ResourcePathIterator(path);
        String availableResourcePath = null;
        while (it.hasNext() && this.resourceResolver.getResource(availableResourcePath = it.next()) == null) {
        }
        if (availableResourcePath == null) {
            return this;
        }
        this.selectors.clear();
        this.extension = null;
        this.suffix = null;
        if (availableResourcePath.length() == path.length()) {
            this.resourcePath = availableResourcePath;
        } else {
            this.setPathWithDefinedResourcePosition(path, availableResourcePath.length());
        }
        return this;
    }

    @NotNull
    public SlingUriBuilder setResourcePath(@Nullable String resourcePath) {
        if (this.schemeSpecificPart != null) {
            return this;
        }
        this.resourcePath = resourcePath;
        return this;
    }

    @NotNull
    public SlingUriBuilder setSelectors(@Nullable String[] selectors) {
        if (this.schemeSpecificPart != null || this.resourcePath == null) {
            return this;
        }
        this.selectors.clear();
        if (selectors != null) {
            Arrays.stream(selectors).forEach(this.selectors::add);
        }
        return this;
    }

    @NotNull
    public SlingUriBuilder addSelector(@NotNull String selector) {
        if (this.schemeSpecificPart != null || this.resourcePath == null) {
            return this;
        }
        this.selectors.add(selector);
        return this;
    }

    @NotNull
    public SlingUriBuilder setExtension(@Nullable String extension) {
        if (this.schemeSpecificPart != null || this.resourcePath == null) {
            return this;
        }
        this.extension = extension;
        return this;
    }

    @NotNull
    public SlingUriBuilder setPathParameter(@NotNull String key, @NotNull String value) {
        if (this.schemeSpecificPart != null || this.resourcePath == null) {
            return this;
        }
        this.pathParameters.put(key, value);
        return this;
    }

    @NotNull
    public SlingUriBuilder setPathParameters(@NotNull Map<String, String> pathParameters) {
        this.pathParameters.clear();
        this.pathParameters.putAll(pathParameters);
        return this;
    }

    @NotNull
    public SlingUriBuilder setSuffix(@Nullable String suffix) {
        if (this.schemeSpecificPart != null || this.resourcePath == null) {
            return this;
        }
        if (suffix != null && !suffix.startsWith(CHAR_SLASH)) {
            throw new IllegalArgumentException("Suffix needs to start with slash");
        }
        this.suffix = suffix;
        return this;
    }

    @NotNull
    public SlingUriBuilder setQuery(@Nullable String query) {
        if (this.schemeSpecificPart != null) {
            return this;
        }
        this.query = query;
        return this;
    }

    @NotNull
    public SlingUriBuilder addQueryParameter(@NotNull String parameterName, @NotNull String value) {
        if (this.schemeSpecificPart != null) {
            return this;
        }
        try {
            this.query = (this.query == null ? "" : this.query + '&') + URLEncoder.encode(parameterName, StandardCharsets.UTF_8.name()) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding not supported: " + StandardCharsets.UTF_8, e);
        }
        return this;
    }

    @NotNull
    public SlingUriBuilder setQueryParameters(@NotNull Map<String, String> queryParameters) {
        if (this.schemeSpecificPart != null) {
            return this;
        }
        this.setQuery(null);
        for (Map.Entry<String, String> parameter : queryParameters.entrySet()) {
            this.addQueryParameter(parameter.getKey(), parameter.getValue());
        }
        return this;
    }

    @NotNull
    public SlingUriBuilder setFragment(@Nullable String fragment) {
        this.fragment = fragment;
        return this;
    }

    @NotNull
    public SlingUriBuilder setScheme(@Nullable String scheme) {
        this.scheme = scheme;
        return this;
    }

    @NotNull
    public SlingUriBuilder setSchemeSpecificPart(@Nullable String schemeSpecificPart) {
        this.schemeSpecificPart = schemeSpecificPart;
        return this;
    }

    @NotNull
    public SlingUriBuilder removeSchemeAndAuthority() {
        this.setScheme(null);
        this.setUserInfo(null);
        this.setHost(null);
        this.setPort(-1);
        return this;
    }

    @NotNull
    public SlingUriBuilder useSchemeAndAuthority(@NotNull SlingUri slingUri) {
        this.setScheme(slingUri.getScheme());
        this.setUserInfo(slingUri.getUserInfo());
        this.setHost(slingUri.getHost());
        this.setPort(slingUri.getPort());
        return this;
    }

    @Nullable
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Nullable
    public String getSelectorString() {
        return !this.selectors.isEmpty() ? String.join((CharSequence)CHAR_DOT, this.selectors) : null;
    }

    @NotNull
    public String[] getSelectors() {
        return this.selectors.toArray(new String[this.selectors.size()]);
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    @Nullable
    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    @Nullable
    public String getSuffix() {
        return this.suffix;
    }

    @Nullable
    public Resource getSuffixResource() {
        if (SlingUriBuilder.isNotBlank(this.suffix) && this.resourceResolver != null) {
            return this.resourceResolver.getResource(this.suffix);
        }
        return null;
    }

    @Nullable
    public String getPath() {
        return this.assemblePath(true);
    }

    @Nullable
    public String getSchemeSpecificPart() {
        if (this.isOpaque()) {
            return this.schemeSpecificPart;
        }
        return this.toStringInternal(false, false);
    }

    @Nullable
    public String getQuery() {
        return this.query;
    }

    @Nullable
    public String getFragment() {
        return this.fragment;
    }

    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getUserInfo() {
        return this.userInfo;
    }

    @NotNull
    public SlingUriBuilder useSchemeAndAuthority(@NotNull URI uri) {
        this.useSchemeAndAuthority(SlingUriBuilder.createFrom(uri, this.resourceResolver).build());
        return this;
    }

    @NotNull
    public SlingUriBuilder setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    @NotNull
    public SlingUri build() {
        if (this.isBuilt) {
            throw new IllegalStateException("SlingUriBuilder.build() may only be called once per builder instance");
        }
        this.isBuilt = true;
        return new ImmutableSlingUri();
    }

    public String toString() {
        return this.toStringInternal(true, true);
    }

    public boolean isPath() {
        return SlingUriBuilder.isBlank(this.scheme) && SlingUriBuilder.isBlank(this.host) && SlingUriBuilder.isNotBlank(this.resourcePath);
    }

    public boolean isAbsolutePath() {
        return this.isPath() && this.resourcePath.startsWith(CHAR_SLASH);
    }

    public boolean isRelativePath() {
        return this.isPath() && !this.resourcePath.startsWith(CHAR_SLASH);
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.scheme != null && this.schemeSpecificPart != null;
    }

    private String toStringInternal(boolean includeScheme, boolean includeFragment) {
        StringBuilder requestUri = new StringBuilder();
        if (includeScheme && this.isAbsolute()) {
            requestUri.append(this.scheme + CHAR_COLON);
        }
        if (this.host != null) {
            requestUri.append("//");
            if (SlingUriBuilder.isNotBlank(this.userInfo)) {
                requestUri.append(this.userInfo + '@');
            }
            requestUri.append(this.host);
            if (!(this.port <= 0 || HTTP_SCHEME.equals(this.scheme) && this.port == 80 || HTTPS_SCHEME.equals(this.scheme) && this.port == 443)) {
                requestUri.append(CHAR_COLON);
                requestUri.append(this.port);
            }
        }
        if (this.schemeSpecificPart != null) {
            requestUri.append(this.schemeSpecificPart);
        }
        if (this.resourcePath != null) {
            requestUri.append(this.assemblePath(true));
        }
        if (this.query != null) {
            requestUri.append(CHAR_QM + this.query);
        }
        if (includeFragment && this.fragment != null) {
            requestUri.append(CHAR_HASH + this.fragment);
        }
        return requestUri.toString();
    }

    private void setPathWithDefinedResourcePosition(String path, int firstDotPositionAfterResourcePath) {
        this.setResourcePath(path.substring(0, firstDotPositionAfterResourcePath));
        int firstSlashAfterFirstDotPosition = path.indexOf(CHAR_SLASH, firstDotPositionAfterResourcePath);
        String pathWithoutSuffix = firstSlashAfterFirstDotPosition > -1 ? path.substring(firstDotPositionAfterResourcePath + 1, firstSlashAfterFirstDotPosition) : path.substring(firstDotPositionAfterResourcePath + 1);
        String[] pathBits = pathWithoutSuffix.split(SELECTOR_DOT_REGEX);
        if (pathBits.length > 1) {
            this.setSelectors(Arrays.copyOfRange(pathBits, 0, pathBits.length - 1));
        }
        this.setExtension(pathBits.length > 0 && pathBits[pathBits.length - 1].length() > 0 ? pathBits[pathBits.length - 1] : null);
        this.setSuffix(firstSlashAfterFirstDotPosition > -1 ? path.substring(firstSlashAfterFirstDotPosition) : null);
    }

    private String extractPathParameters(String path) {
        this.pathParameters.clear();
        if (path != null) {
            Pattern pathParameterRegex = Pattern.compile(PATH_PARAMETERS_REGEX);
            StringBuffer resultString = null;
            Matcher regexMatcher = pathParameterRegex.matcher(path);
            while (regexMatcher.find()) {
                if (resultString == null) {
                    resultString = new StringBuffer();
                }
                regexMatcher.appendReplacement(resultString, "");
                String key = regexMatcher.group(1);
                String value = SlingUriBuilder.isNotBlank(regexMatcher.group(2)) ? regexMatcher.group(2) : regexMatcher.group(3);
                this.pathParameters.put(key, value);
            }
            if (resultString != null) {
                regexMatcher.appendTail(resultString);
                path = resultString.toString();
            }
        }
        return path;
    }

    private String assemblePath(boolean includePathParamters) {
        if (this.resourcePath == null) {
            return null;
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(this.resourcePath);
        if (includePathParamters && !this.pathParameters.isEmpty()) {
            for (Map.Entry<String, String> pathParameter : this.pathParameters.entrySet()) {
                pathBuilder.append(';' + pathParameter.getKey() + '=' + '\'' + pathParameter.getValue() + '\'');
            }
        }
        boolean dotAdded = false;
        if (!this.selectors.isEmpty()) {
            pathBuilder.append(CHAR_DOT + String.join((CharSequence)CHAR_DOT, this.selectors));
            dotAdded = true;
        }
        if (SlingUriBuilder.isNotBlank(this.extension)) {
            pathBuilder.append(CHAR_DOT + this.extension);
            dotAdded = true;
        }
        if (SlingUriBuilder.isNotBlank(this.suffix)) {
            if (!dotAdded) {
                pathBuilder.append(CHAR_DOT);
            }
            pathBuilder.append(this.suffix);
        }
        return pathBuilder.toString();
    }

    private class ResourcePathIterator
    implements Iterator<String> {
        private String nextPath;

        private ResourcePathIterator(String path) {
            if (path == null || path.length() == 0) {
                this.nextPath = null;
            } else {
                int i;
                for (i = path.length() - 1; i >= 0 && path.charAt(i) == '/'; --i) {
                }
                this.nextPath = i < 0 ? SlingUriBuilder.CHAR_SLASH : (i < path.length() - 1 ? path.substring(0, i + 1) : path);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextPath != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String result = this.nextPath;
            int lastDot = this.nextPath.lastIndexOf(46);
            this.nextPath = lastDot > 0 ? this.nextPath.substring(0, lastDot) : null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private class ImmutableSlingUri
    implements SlingUri {
        private ImmutableSlingUri() {
        }

        @Override
        public String getResourcePath() {
            return this.getData().getResourcePath();
        }

        @Override
        public String getSelectorString() {
            return this.getData().getSelectorString();
        }

        @Override
        public String[] getSelectors() {
            return this.getData().getSelectors();
        }

        @Override
        public String getExtension() {
            return this.getData().getExtension();
        }

        @Override
        public Map<String, String> getPathParameters() {
            return Collections.unmodifiableMap(this.getData().getPathParameters());
        }

        @Override
        public String getSuffix() {
            return this.getData().getSuffix();
        }

        @Override
        public String getPath() {
            return this.getData().getPath();
        }

        @Override
        public String getSchemeSpecificPart() {
            return this.getData().getSchemeSpecificPart();
        }

        @Override
        public String getQuery() {
            return this.getData().getQuery();
        }

        @Override
        public String getFragment() {
            return this.getData().getFragment();
        }

        @Override
        public String getScheme() {
            return this.getData().getScheme();
        }

        @Override
        public String getHost() {
            return this.getData().getHost();
        }

        @Override
        public int getPort() {
            return this.getData().getPort();
        }

        @Override
        public Resource getSuffixResource() {
            return this.getData().getSuffixResource();
        }

        @Override
        public String getUserInfo() {
            return this.getData().getUserInfo();
        }

        @Override
        public boolean isOpaque() {
            return this.getData().isOpaque();
        }

        @Override
        public boolean isPath() {
            return this.getData().isPath();
        }

        @Override
        public boolean isAbsolutePath() {
            return this.getData().isAbsolutePath();
        }

        @Override
        public boolean isRelativePath() {
            return this.getData().isRelativePath();
        }

        @Override
        public boolean isAbsolute() {
            return this.getData().isAbsolute();
        }

        @Override
        public String toString() {
            return this.getData().toString();
        }

        @Override
        public URI toUri() {
            String uriString = this.toString();
            try {
                return new URI(uriString);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Invalid Sling URI: " + uriString, e);
            }
        }

        private SlingUriBuilder getData() {
            return SlingUriBuilder.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (SlingUriBuilder.this.extension == null ? 0 : SlingUriBuilder.this.extension.hashCode());
            result = 31 * result + (SlingUriBuilder.this.fragment == null ? 0 : SlingUriBuilder.this.fragment.hashCode());
            result = 31 * result + (SlingUriBuilder.this.host == null ? 0 : SlingUriBuilder.this.host.hashCode());
            result = 31 * result + SlingUriBuilder.this.pathParameters.hashCode();
            result = 31 * result + SlingUriBuilder.this.port;
            result = 31 * result + (SlingUriBuilder.this.query == null ? 0 : SlingUriBuilder.this.query.hashCode());
            result = 31 * result + (SlingUriBuilder.this.resourcePath == null ? 0 : SlingUriBuilder.this.resourcePath.hashCode());
            result = 31 * result + (SlingUriBuilder.this.scheme == null ? 0 : SlingUriBuilder.this.scheme.hashCode());
            result = 31 * result + (SlingUriBuilder.this.schemeSpecificPart == null ? 0 : SlingUriBuilder.this.schemeSpecificPart.hashCode());
            result = 31 * result + SlingUriBuilder.this.selectors.hashCode();
            result = 31 * result + (SlingUriBuilder.this.suffix == null ? 0 : SlingUriBuilder.this.suffix.hashCode());
            result = 31 * result + (SlingUriBuilder.this.userInfo == null ? 0 : SlingUriBuilder.this.userInfo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImmutableSlingUri other = (ImmutableSlingUri)obj;
            if (SlingUriBuilder.this.extension == null ? other.getData().extension != null : !SlingUriBuilder.this.extension.equals(other.getData().extension)) {
                return false;
            }
            if (SlingUriBuilder.this.fragment == null ? other.getData().fragment != null : !SlingUriBuilder.this.fragment.equals(other.getData().fragment)) {
                return false;
            }
            if (SlingUriBuilder.this.host == null ? other.getData().host != null : !SlingUriBuilder.this.host.equals(other.getData().host)) {
                return false;
            }
            if (SlingUriBuilder.this.pathParameters == null ? other.getData().pathParameters != null : !SlingUriBuilder.this.pathParameters.equals(other.getData().pathParameters)) {
                return false;
            }
            if (SlingUriBuilder.this.port != other.getData().port) {
                return false;
            }
            if (SlingUriBuilder.this.query == null ? other.getData().query != null : !SlingUriBuilder.this.query.equals(other.getData().query)) {
                return false;
            }
            if (SlingUriBuilder.this.resourcePath == null ? other.getData().resourcePath != null : !SlingUriBuilder.this.resourcePath.equals(other.getData().resourcePath)) {
                return false;
            }
            if (SlingUriBuilder.this.scheme == null ? other.getData().scheme != null : !SlingUriBuilder.this.scheme.equals(other.getData().scheme)) {
                return false;
            }
            if (SlingUriBuilder.this.schemeSpecificPart == null ? other.getData().schemeSpecificPart != null : !SlingUriBuilder.this.schemeSpecificPart.equals(other.getData().schemeSpecificPart)) {
                return false;
            }
            if (SlingUriBuilder.this.selectors == null ? other.getData().selectors != null : !SlingUriBuilder.this.selectors.equals(other.getData().selectors)) {
                return false;
            }
            if (SlingUriBuilder.this.suffix == null ? other.getData().suffix != null : !SlingUriBuilder.this.suffix.equals(other.getData().suffix)) {
                return false;
            }
            return !(SlingUriBuilder.this.userInfo == null ? other.getData().userInfo != null : !SlingUriBuilder.this.userInfo.equals(other.getData().userInfo));
        }
    }
}

