/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.scripting;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.script.Bindings;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class LazyBindings
extends HashMap<String, Object>
implements Bindings {
    private final Map<String, Supplier> suppliers;

    public LazyBindings() {
        this(new HashMap<String, Supplier>(), Collections.emptyMap());
    }

    public LazyBindings(Map<String, Supplier> suppliers) {
        this(suppliers, Collections.emptyMap());
    }

    public LazyBindings(Map<String, Supplier> suppliers, Map<String, Object> wrapped) {
        super(wrapped);
        this.suppliers = suppliers;
    }

    @Override
    public Object put(String key, Object value) {
        Object previous = super.get(key);
        if (value instanceof Supplier) {
            this.suppliers.put(key, (Supplier)value);
        } else {
            super.put(key, value);
        }
        return previous;
    }

    @Override
    public void putAll(Map<? extends String, ?> toMerge) {
        for (Map.Entry<String, ?> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.suppliers.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        HashSet keySet = new HashSet(super.keySet());
        if (!this.suppliers.isEmpty()) {
            keySet.addAll(this.suppliers.keySet());
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    @NotNull
    public Collection<Object> values() {
        return super.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap holder = new HashMap();
        Stream.concat(super.entrySet().stream(), this.suppliers.entrySet().stream()).forEach((? super T entry) -> holder.put((String)entry.getKey(), entry.getValue()));
        return holder.entrySet();
    }

    @Override
    public int size() {
        HashSet keys = new HashSet(super.keySet());
        keys.addAll(this.suppliers.keySet());
        return keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.suppliers.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        String k = key.toString();
        if (!super.containsKey(k) && this.suppliers.containsKey(k)) {
            Object value = this.suppliers.get(k).get();
            super.put(k, value);
            this.suppliers.remove(k);
        }
        return super.get(key);
    }

    @Override
    public Object remove(Object key) {
        Supplier supplier;
        Object previous = super.remove(key);
        if (previous == null && (supplier = this.suppliers.remove(key)) != null) {
            return supplier.get();
        }
        return previous;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LazyBindings && super.equals(o)) {
            LazyBindings other = (LazyBindings)o;
            return this.suppliers.equals(other.suppliers);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.suppliers.hashCode();
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        Object result = this.get(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @FunctionalInterface
    @ConsumerType
    public static interface Supplier
    extends java.util.function.Supplier {
    }
}

