/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.servlet.ServletContext;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.impl.EclipseJavaCompiler;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.maven.jspc.DependencyTracker;
import org.apache.sling.maven.jspc.FeatureSupport;
import org.apache.sling.maven.jspc.JspCClassLoaderWriter;
import org.apache.sling.maven.jspc.JspCIOProvider;
import org.apache.sling.maven.jspc.JspCServletContext;
import org.apache.sling.maven.jspc.JspCTldLocationsCache;
import org.apache.sling.maven.jspc.TrackingClassLoader;
import org.apache.sling.scripting.jsp.jasper.IOProvider;
import org.apache.sling.scripting.jsp.jasper.JasperException;
import org.apache.sling.scripting.jsp.jasper.JspCompilationContext;
import org.apache.sling.scripting.jsp.jasper.Options;
import org.apache.sling.scripting.jsp.jasper.compiler.JspConfig;
import org.apache.sling.scripting.jsp.jasper.compiler.JspRuntimeContext;
import org.apache.sling.scripting.jsp.jasper.compiler.PageInfo;
import org.apache.sling.scripting.jsp.jasper.compiler.TagPluginManager;
import org.apache.sling.scripting.jsp.jasper.compiler.TldLocationsCache;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="jspc", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class JspcMojo
extends AbstractMojo
implements Options {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="jspc.sourceDirectory", defaultValue="${project.build.scriptSourceDirectory}")
    private File sourceDirectory;
    @Parameter
    private File[] resourceDirectories = new File[0];
    @Parameter(property="jspc.outputDirectory", defaultValue="${project.build.outputDirectory}")
    private String outputDirectory;
    @Parameter(property="jspc.jasper.classdebuginfo", defaultValue="true")
    private boolean jasperClassDebugInfo;
    @Parameter(property="jspc.jasper.enablePooling", defaultValue="true")
    private boolean jasperEnablePooling;
    @Parameter(property="jspc.jasper.ieClassId", defaultValue="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93")
    private String jasperIeClassId;
    @Parameter(property="jspc.jasper.genStringAsCharArray", defaultValue="false")
    private boolean jasperGenStringAsCharArray;
    @Parameter(property="jspc.jasper.keepgenerated", defaultValue="true")
    private boolean jasperKeepGenerated;
    @Parameter(property="jspc.jasper.mappedfile", defaultValue="true")
    private boolean jasperMappedFile;
    @Parameter(property="jspc.jasper.trimSpaces", defaultValue="false")
    private boolean jasperTrimSpaces;
    @Parameter(property="jspc.jasper.suppressSmap", defaultValue="false")
    private boolean jasperSuppressSmap;
    @Parameter(property="jspc.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="jspc.showSuccess", defaultValue="false")
    private boolean showSuccess;
    @Parameter(property="jspc.compilerTargetVM", defaultValue="1.8")
    private String compilerTargetVM;
    @Parameter(property="jspc.compilerSourceVM", defaultValue="1.8")
    private String compilerSourceVM;
    @Parameter(property="jspc.printCompilationReport", defaultValue="false")
    private boolean printCompilationReport;
    @Parameter(property="jspc.generateCompilationReport", defaultValue="false")
    private boolean generateCompilationReport;
    private static final String COMPILATION_REPORT = "compilation_report.json";
    @Deprecated
    @Parameter(property="jspc.jspFileExtensions", defaultValue="jsp,jspx")
    private String jspFileExtensions;
    @Parameter(property="jspc.servletPackage")
    private String servletPackage;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter
    private FeatureDependency feature;
    @Parameter(property="session", defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    ArtifactHandlerManager artifactHandlerManager;
    @Component
    ArtifactResolver artifactResolver;
    private String uriSourceRoot;
    private List<String> pages = new ArrayList<String>();
    private JspCServletContext context;
    private JspRuntimeContext rctxt;
    private TrackingClassLoader loader;
    private List<Artifact> jspcCompileArtifacts;
    private TldLocationsCache tldLocationsCache;
    private FeatureSupport featureSupport;
    private JspConfig jspConfig;
    private TagPluginManager tagPluginManager;
    private JspCIOProvider ioProvider;
    private DependencyTracker dependencyTracker;
    private static final ConcurrentHashMap<String, Artifact> cache = new ConcurrentHashMap();

    public void execute() throws MojoExecutionException {
        try {
            this.uriSourceRoot = this.sourceDirectory.getCanonicalPath();
        }
        catch (Exception e) {
            this.uriSourceRoot = this.sourceDirectory.getAbsolutePath();
        }
        File outputDirectoryFile = new File(this.outputDirectory);
        if (!outputDirectoryFile.isDirectory()) {
            if (outputDirectoryFile.exists()) {
                throw new MojoExecutionException(this.outputDirectory + " exists but is not a directory");
            }
            if (!outputDirectoryFile.mkdirs()) {
                throw new MojoExecutionException("Cannot create output directory " + this.outputDirectory);
            }
        }
        String previousJasperPackageName = null;
        String oldValue = System.getProperty("org.apache.commons.logging.Log");
        try {
            System.setProperty("org.apache.commons.logging.Log", SimpleLog.class.getName());
            previousJasperPackageName = System.setProperty("org.apache.sling.scripting.jsp.jasper.Constants.JSP_PACKAGE_NAME", this.servletPackage != null ? this.servletPackage : "");
            this.executeInternal();
            if (this.dependencyTracker != null) {
                if (this.printCompilationReport) {
                    this.printCompilationReport(this.dependencyTracker);
                }
                if (this.generateCompilationReport) {
                    this.generateCompilationReport(this.dependencyTracker);
                }
            }
        }
        catch (JasperException je) {
            this.getLog().error((CharSequence)"Compilation Failure", (Throwable)je);
            throw new MojoExecutionException(je.getMessage(), (Exception)((Object)je));
        }
        finally {
            if (oldValue == null) {
                System.clearProperty("org.apache.commons.logging.Log");
            } else {
                System.setProperty("org.apache.commons.logging.Log", oldValue);
            }
            if (previousJasperPackageName == null) {
                System.clearProperty("org.apache.sling.scripting.jsp.jasper.Constants.JSP_PACKAGE_NAME");
            } else {
                System.setProperty("org.apache.sling.scripting.jsp.jasper.Constants.JSP_PACKAGE_NAME", previousJasperPackageName);
            }
            if (this.featureSupport != null) {
                try {
                    this.featureSupport.shutdown(10000L);
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                }
                this.featureSupport = null;
            }
        }
        this.project.addCompileSourceRoot(this.outputDirectory);
    }

    private void scanFiles(File base) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(base);
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        Collections.addAll(this.pages, scanner.getIncludedFiles());
    }

    private void executeInternal() throws JasperException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("execute() starting for " + this.pages.size() + " pages."));
        }
        try {
            File uriRootF;
            if (this.featureSupport == null && this.feature != null) {
                File target = null;
                if (this.feature.featureId != null) {
                    target = JspcMojo.getOrResolveArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.artifactResolver, ArtifactId.fromMvnId((String)this.feature.featureId.getId())).getFile();
                } else if (this.feature.featureFile != null && !this.feature.featureFile.trim().isEmpty()) {
                    target = new File(this.feature.featureFile);
                }
                if (target != null && target.isFile()) {
                    try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(target.toPath(), new OpenOption[0]), "UTF-8");){
                        Feature assembled = FeatureJSONReader.read((Reader)reader, (String)target.getAbsolutePath());
                        this.featureSupport = FeatureSupport.createFeatureSupport(assembled, artifactId -> {
                            try {
                                return JspcMojo.getOrResolveArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.artifactResolver, artifactId).getFile().toURI().toURL();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }, ((Object)((Object)this)).getClass().getClassLoader(), this.feature.failOnUnresolved, properties -> {
                            properties.put("org.osgi.framework.storage.clean", "onFirstInit");
                            properties.put("org.osgi.framework.storage", new File(this.project.getBuild().getDirectory(), "featuresupport").getAbsolutePath());
                            properties.put("org.osgi.framework.bootdelegation", "*");
                            return properties;
                        });
                    }
                }
            }
            if (this.context == null) {
                this.initServletContext();
            }
            if (this.printCompilationReport || this.generateCompilationReport) {
                this.dependencyTracker = new DependencyTracker(this.getLog(), this.project.getBasedir().toPath(), this.sourceDirectory.toPath(), this.context, this.loader, this.jspcCompileArtifacts);
            }
            if (this.includes == null) {
                this.includes = new String[]{"**/*.jsp"};
            }
            if (this.pages.size() == 0) {
                this.scanFiles(this.sourceDirectory);
            }
            if (!(uriRootF = new File(this.uriSourceRoot)).exists() || !uriRootF.isDirectory()) {
                throw new JasperException("The source location '" + this.uriSourceRoot + "' must be an existing directory");
            }
            ((Stream)this.pages.stream().parallel()).forEach(nextjsp -> {
                File fjsp = new File((String)nextjsp);
                if (!fjsp.isAbsolute()) {
                    fjsp = new File(uriRootF, (String)nextjsp);
                }
                if (!fjsp.exists()) {
                    if (this.getLog().isWarnEnabled()) {
                        this.getLog().warn((CharSequence)("JSP file " + fjsp + " does not exist"));
                    }
                } else {
                    String s = fjsp.getAbsolutePath();
                    if (s.startsWith(this.uriSourceRoot)) {
                        nextjsp = s.substring(this.uriSourceRoot.length());
                    }
                    if (nextjsp.startsWith("." + File.separatorChar)) {
                        nextjsp = nextjsp.substring(2);
                    }
                    try {
                        this.processFile((String)nextjsp);
                    }
                    catch (JasperException e) {
                        Throwable rootCause = e;
                        while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                            rootCause = rootCause.getRootCause();
                        }
                        if (rootCause != e) {
                            rootCause.printStackTrace();
                        }
                        throw new RuntimeException(e);
                    }
                }
            });
            if (this.dependencyTracker != null) {
                this.dependencyTracker.processCompileDependencies();
            }
        }
        catch (Exception ioe) {
            throw new JasperException((Throwable)ioe);
        }
    }

    private void processFile(String file) throws JasperException {
        try {
            String jspUri = file.replace('\\', '/');
            JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, (Options)this, (ServletContext)this.context, this.rctxt, false);
            JasperException error = clctxt.compile(true);
            PageInfo pageInfo = clctxt.getCompiler().getPageInfo();
            if (pageInfo != null && this.dependencyTracker != null) {
                this.dependencyTracker.collectJSPInfo(file, pageInfo);
            }
            if (error != null) {
                throw error;
            }
            if (this.showSuccess) {
                this.getLog().info((CharSequence)("Built File: " + file));
            }
        }
        catch (JasperException je) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                this.getLog().error((CharSequence)("General problem compiling " + file), rootCause);
            }
            if (this.failOnError) {
                throw je;
            }
            this.getLog().error((CharSequence)je.getMessage());
        }
        catch (Throwable e) {
            if (this.failOnError) {
                throw new JasperException(e);
            }
            this.getLog().error((CharSequence)e.getMessage(), e);
        }
    }

    private void initServletContext() throws IOException, DependencyResolutionRequiredException {
        if (this.loader == null) {
            this.initClassLoader();
        }
        this.tldLocationsCache = this.featureSupport != null ? this.featureSupport.getTldLocationsCache() : new JspCTldLocationsCache(true, this.loader);
        this.context = new JspCServletContext(this.getLog(), new URL("file:" + this.uriSourceRoot.replace('\\', '/') + '/'), this.tldLocationsCache);
        for (File resourceDir : this.resourceDirectories) {
            String root = resourceDir.getCanonicalPath().replace('\\', '/');
            URL altUrl = new URL("file:" + root + "/");
            this.context.addAlternativeBaseURL(altUrl);
        }
        if (this.tldLocationsCache instanceof JspCTldLocationsCache) {
            ((JspCTldLocationsCache)this.tldLocationsCache).init(this.context);
        }
        EclipseJavaCompiler compiler = new EclipseJavaCompiler();
        JspCClassLoaderWriter writer = new JspCClassLoaderWriter(this.loader, new File(this.outputDirectory));
        this.ioProvider = new JspCIOProvider(this.loader, (JavaCompiler)compiler, writer);
        this.rctxt = new JspRuntimeContext((ServletContext)this.context, (Options)this, (IOProvider)this.ioProvider);
        this.jspConfig = new JspConfig((ServletContext)this.context);
        this.tagPluginManager = new TagPluginManager((ServletContext)this.context);
    }

    private void initClassLoader() throws IOException, DependencyResolutionRequiredException {
        ArrayList<URL> classPath = new ArrayList<URL>();
        String targetDirectory = this.project.getBuild().getOutputDirectory();
        classPath.add(new File(targetDirectory).toURI().toURL());
        this.jspcCompileArtifacts = new ArrayList<Artifact>();
        if (this.featureSupport != null) {
            if (this.feature.dependencies != null) {
                for (Dependency dependency2 : this.feature.dependencies) {
                    Artifact artifact = JspcMojo.getOrResolveArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.artifactResolver, new ArtifactId(dependency2.getGroupId(), dependency2.getArtifactId(), dependency2.getVersion(), dependency2.getClassifier(), dependency2.getType()));
                    classPath.add(artifact.getFile().toURI().toURL());
                    this.jspcCompileArtifacts.add(artifact);
                }
            }
            this.featureSupport.getFeature().getBundles().stream().map(bundle -> bundle.getId()).map(dependency -> JspcMojo.getOrResolveArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.artifactResolver, new ArtifactId(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType()))).forEachOrdered(this.jspcCompileArtifacts::add);
            this.loader = new TrackingClassLoader(classPath.toArray(new URL[classPath.size()]), this.featureSupport.getClassLoader());
        } else {
            Set artifacts = this.project.getArtifacts();
            for (Artifact a : artifacts) {
                String scope = a.getScope();
                if (!"provided".equals(scope) && !"runtime".equals(scope) && !"compile".equals(scope) || this.containsProblematicPackage(a.getFile())) continue;
                classPath.add(a.getFile().toURI().toURL());
                this.jspcCompileArtifacts.add(a);
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Compiler classpath:");
                for (URL u : classPath) {
                    this.getLog().debug((CharSequence)("  " + u));
                }
            }
            this.loader = new TrackingClassLoader(classPath.toArray(new URL[classPath.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        }
    }

    private boolean containsProblematicPackage(File file) throws IOException {
        JarFile jar = new JarFile(file);
        boolean isJSPApi = jar.getEntry("/javax/servlet/jsp/JspPage.class") != null;
        jar.close();
        return isJSPApi;
    }

    /*
     * WARNING - void declaration
     */
    private void printCompilationReport(DependencyTracker dependencyTracker) {
        Map<String, Set<String>> jspDependencies;
        void var7_13;
        StringBuilder report = new StringBuilder("JSP compilation report:\n\n");
        int pad = 10;
        Map<String, Set<String>> packageProviders = dependencyTracker.getPackageProviders();
        ArrayList<String> packages = new ArrayList<String>(packageProviders.keySet());
        for (String string : packages) {
            pad = Math.max(pad, string.length());
        }
        report.append(StringUtils.rightPad((String)"Package", (int)(pad += 2))).append("Dependency");
        report.append("\n---------------------------------------------------------------\n");
        Collections.sort(packages);
        for (String string : packages) {
            report.append(StringUtils.rightPad((String)string, (int)pad));
            Set<String> artifacts = packageProviders.get(string);
            if (artifacts == null || artifacts.isEmpty()) {
                report.append("n/a");
            } else {
                StringBuilder ids = new StringBuilder();
                for (String id : artifacts) {
                    if (ids.length() > 0) {
                        ids.append(", ");
                    }
                    ids.append(id);
                }
                report.append((CharSequence)ids);
            }
            report.append("\n");
        }
        report.append("\n");
        Set<String> unusedDependencies = dependencyTracker.getUnusedDependencies();
        report.append(unusedDependencies.size()).append(" dependencies not used by JSPs:\n");
        if (!unusedDependencies.isEmpty()) {
            report.append("---------------------------------------------------------------\n");
            for (String id : unusedDependencies) {
                report.append(id).append("\n");
            }
        }
        boolean bl = false;
        StringBuilder msg = new StringBuilder();
        for (String packageName : packages) {
            Set<String> a = packageProviders.get(packageName);
            if (a == null || a.size() <= 1) continue;
            ++var7_13;
            msg.append(StringUtils.rightPad((String)packageName, (int)pad));
            msg.append(StringUtils.join(a.iterator(), (String)", ")).append("\n");
        }
        report.append("\n");
        report.append((int)var7_13).append(" packages are defined by multiple dependencies:\n");
        if (var7_13 > 0) {
            report.append("---------------------------------------------------------------\n");
            report.append((CharSequence)msg);
        }
        if (!(jspDependencies = dependencyTracker.getJspDependencies()).isEmpty()) {
            pad = 10;
            ArrayList<String> jspsWithDependencies = new ArrayList<String>(jspDependencies.keySet());
            for (String jsp : jspsWithDependencies) {
                pad = Math.max(pad, jsp.length());
            }
            report.append("\n");
            report.append(StringUtils.rightPad((String)"JSP", (int)(pad += 2))).append("Dependencies");
            report.append("\n---------------------------------------------------------------\n");
            Collections.sort(jspsWithDependencies);
            for (String jsp : jspsWithDependencies) {
                report.append(StringUtils.rightPad((String)jsp, (int)pad));
                report.append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)jspDependencies.get(jsp)));
            }
        }
        this.getLog().info((CharSequence)report);
    }

    private void generateCompilationReport(DependencyTracker dependencyTracker) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonArrayBuilder providers = Json.createArrayBuilder();
        JsonArrayBuilder jsps = Json.createArrayBuilder();
        dependencyTracker.getPackageProviders().forEach((pkg, providersForPackage) -> {
            JsonArrayBuilder providersForPackageBuilder = Json.createArrayBuilder((Collection)providersForPackage);
            JsonObject provider = Json.createObjectBuilder().add("package", pkg).add("providers", providersForPackageBuilder).build();
            providers.add((JsonValue)provider);
        });
        dependencyTracker.getJspDependencies().forEach((jsp, dependencies) -> {
            JsonArrayBuilder dependenciesBuilder = Json.createArrayBuilder((Collection)dependencies);
            JsonObject jspDependency = Json.createObjectBuilder().add("jsp", jsp).add("dependencies", dependenciesBuilder).build();
            jsps.add((JsonValue)jspDependency);
        });
        JsonArrayBuilder unusedDependencies = Json.createArrayBuilder(dependencyTracker.getUnusedDependencies());
        Path compilationReportPath = Paths.get(this.project.getBuild().getOutputDirectory(), COMPILATION_REPORT);
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriterFactory writerFactory = Json.createWriterFactory(properties);
        try (JsonWriter jsonWriter = writerFactory.createWriter((Writer)Files.newBufferedWriter(compilationReportPath, StandardCharsets.UTF_8, new OpenOption[0]));){
            jsonWriter.writeObject(jsonObjectBuilder.add("packageProviders", (JsonValue)providers.build()).add("jspDependencies", (JsonValue)jsps.build()).add("unusedDependencies", (JsonValue)unusedDependencies.build()).build());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot generate the compilation_report.json file.", (Throwable)e);
        }
    }

    public boolean genStringAsCharArray() {
        return this.jasperGenStringAsCharArray;
    }

    public boolean getClassDebugInfo() {
        return this.jasperClassDebugInfo;
    }

    public String getCompiler() {
        return null;
    }

    public String getCompilerClassName() {
        return null;
    }

    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return true;
    }

    public boolean getFork() {
        return false;
    }

    public String getIeClassId() {
        return this.jasperIeClassId;
    }

    public String getJavaEncoding() {
        return "UTF-8";
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public boolean getKeepGenerated() {
        return this.jasperKeepGenerated;
    }

    public boolean getMappedFile() {
        return this.jasperMappedFile;
    }

    public String getScratchDir() {
        return this.outputDirectory;
    }

    public boolean getSendErrorToClient() {
        return true;
    }

    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public boolean getTrimSpaces() {
        return this.jasperTrimSpaces;
    }

    public boolean isPoolingEnabled() {
        return this.jasperEnablePooling;
    }

    public boolean isSmapDumped() {
        return true;
    }

    public boolean isSmapSuppressed() {
        return this.jasperSuppressSmap;
    }

    public boolean isXpoweredBy() {
        return false;
    }

    public boolean getDisplaySourceFragment() {
        return true;
    }

    public static Artifact getOrResolveArtifact(MavenProject project, MavenSession session, ArtifactHandlerManager artifactHandlerManager, ArtifactResolver resolver, ArtifactId id) {
        Artifact result = cache.get(id.toMvnId());
        if (result == null) {
            result = JspcMojo.findArtifact(id, project.getAttachedArtifacts());
            if (result == null && (result = JspcMojo.findArtifact(id, project.getArtifacts())) == null) {
                DefaultArtifact prjArtifact = new DefaultArtifact(id.getGroupId(), id.getArtifactId(), VersionRange.createFromVersion((String)id.getVersion()), "provided", id.getType(), id.getClassifier(), artifactHandlerManager.getArtifactHandler(id.getType()));
                try {
                    resolver.resolve((Artifact)prjArtifact, project.getRemoteArtifactRepositories(), session.getLocalRepository());
                }
                catch (ArtifactNotFoundException | ArtifactResolutionException e) {
                    throw new RuntimeException("Unable to get artifact for " + id.toMvnId(), e);
                }
                result = prjArtifact;
            }
            cache.put(id.toMvnId(), result);
        }
        return result;
    }

    private static Artifact findArtifact(ArtifactId id, Collection<Artifact> artifacts) {
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getGroupId().equals(id.getGroupId()) || !artifact.getArtifactId().equals(id.getArtifactId()) || !artifact.getVersion().equals(id.getVersion()) || !artifact.getType().equals(id.getType()) || (id.getClassifier() != null || artifact.getClassifier() != null) && (id.getClassifier() == null || !id.getClassifier().equals(artifact.getClassifier()))) continue;
                return artifact.getFile() == null ? null : artifact;
            }
        }
        return null;
    }

    public static final class FeatureDependency {
        public Artifact featureId;
        public String featureFile;
        public List<Dependency> dependencies;
        public boolean failOnUnresolved;
    }
}

