/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TrackingClassLoader
extends URLClassLoader {
    private final Set<String> classNames = Collections.synchronizedSet(new HashSet());
    private final Set<String> packageNames = Collections.synchronizedSet(new HashSet());

    public TrackingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public Set<String> getClassNames() {
        return this.classNames;
    }

    public Set<String> getPackageNames() {
        return this.packageNames;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c = super.loadClass(name);
        this.classNames.add(name);
        this.packageNames.add(c.getPackage().getName());
        return c;
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url != null && name.endsWith(".class")) {
            int lastDot = name.lastIndexOf(46);
            int lastSlash = name.lastIndexOf(47);
            String className = name.substring(0, lastDot).replaceAll("/", ".");
            this.classNames.add(className);
            if (lastSlash > 0) {
                this.packageNames.add(className.substring(0, lastSlash));
            }
        }
        return url;
    }
}

